/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tweaks.ai;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import org.violetmoon.quark.content.tweaks.module.PatTheDogsModule;

public class WantLoveGoal
extends Goal {
    private static final String PET_TIME = "quark:PetTime";
    private final TamableAnimal creature;
    private LivingEntity leapTarget;
    public final float leapUpMotion;

    public static void setPetTime(TamableAnimal entity) {
        entity.getPersistentData().putLong(PET_TIME, entity.level().getGameTime());
    }

    public static boolean canPet(TamableAnimal entity) {
        return WantLoveGoal.timeSinceLastPet(entity) > 20L;
    }

    public static boolean needsPets(TamableAnimal entity) {
        if (PatTheDogsModule.dogsWantLove <= 0) {
            return false;
        }
        return WantLoveGoal.timeSinceLastPet(entity) > (long)PatTheDogsModule.dogsWantLove;
    }

    public static long timeSinceLastPet(TamableAnimal entity) {
        if (!entity.isTame()) {
            return 0L;
        }
        long lastPetAt = entity.getPersistentData().getLong(PET_TIME);
        return entity.level().getGameTime() - lastPetAt;
    }

    public WantLoveGoal(TamableAnimal creature, float leapMotion) {
        this.creature = creature;
        this.leapUpMotion = leapMotion;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP, Goal.Flag.TARGET));
    }

    public boolean canUse() {
        if (!WantLoveGoal.needsPets(this.creature)) {
            return false;
        }
        this.leapTarget = this.creature.getOwner();
        if (this.leapTarget == null) {
            return false;
        }
        double distanceToTarget = this.creature.distanceToSqr((Entity)this.leapTarget);
        return 4.0 <= distanceToTarget && distanceToTarget <= 16.0 && this.creature.onGround() && this.creature.getRandom().nextInt(5) == 0;
    }

    public boolean canContinueToUse() {
        if (!WantLoveGoal.needsPets(this.creature)) {
            return false;
        }
        return !this.creature.onGround();
    }

    public void start() {
        Vec3 leapPos = this.leapTarget.position();
        Vec3 creaturePos = this.creature.position();
        double dX = leapPos.x - creaturePos.x;
        double dZ = leapPos.z - creaturePos.z;
        float leapMagnitude = (float)Math.sqrt(dX * dX + dZ * dZ);
        Vec3 motion = this.creature.getDeltaMovement();
        if ((double)leapMagnitude >= 1.0E-4) {
            motion = motion.add(dX / (double)leapMagnitude * 0.4 + motion.x * 0.2, 0.0, dZ / (double)leapMagnitude * 0.4 + motion.z * 0.2);
        }
        motion = motion.add(0.0, (double)this.leapUpMotion, 0.0);
        this.creature.setDeltaMovement(motion);
    }
}

