/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.world.gen;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.violetmoon.quark.content.world.config.BlossomTreeConfig;
import org.violetmoon.zeta.world.generator.Generator;

public class BlossomTreeGenerator
extends Generator {
    private final BlossomTreeConfig quarkConfig;
    private final ResourceKey<ConfiguredFeature<?, ?>> treeKey;

    public BlossomTreeGenerator(BlossomTreeConfig quarkConfig, ResourceKey<ConfiguredFeature<?, ?>> treeKey) {
        super(quarkConfig.dimensions);
        this.quarkConfig = quarkConfig;
        this.treeKey = treeKey;
    }

    public void generateChunk(WorldGenRegion worldIn, ChunkGenerator generator, RandomSource rand, BlockPos pos) {
        BlockState ground;
        BlockPos placePos = pos.offset(rand.nextInt(16), 0, rand.nextInt(16));
        if (this.quarkConfig.biomeConfig.canSpawn(this.getBiome((LevelAccessor)worldIn, placePos, false)) && rand.nextInt(this.quarkConfig.rarity) == 0 && (ground = worldIn.getBlockState(placePos = worldIn.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, placePos).below())).getBlock().canSustainPlant(ground, (BlockGetter)worldIn, pos, Direction.UP, Blocks.OAK_SAPLING.defaultBlockState()).isTrue()) {
            BlockPos up = placePos.above();
            BlockState upState = worldIn.getBlockState(up);
            Registry cfgFeatureRegistry = worldIn.registryAccess().registryOrThrow(Registries.CONFIGURED_FEATURE);
            ConfiguredFeature cfgFeature = (ConfiguredFeature)cfgFeatureRegistry.get(this.treeKey);
            if (cfgFeature == null) {
                return;
            }
            ConfiguredFeature cool = cfgFeature;
            FeaturePlaceContext placeCtx = new FeaturePlaceContext(Optional.of(cool), (WorldGenLevel)worldIn, generator, rand, up, (FeatureConfiguration)((TreeConfiguration)cool.config()));
            if (upState.canBeReplaced((Fluid)Fluids.WATER)) {
                worldIn.setBlock(up, Blocks.AIR.defaultBlockState(), 0);
            }
            Feature.TREE.place(placeCtx);
        }
    }
}

