/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tweaks.client.layer;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.core.Rotations;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.SkullBlock;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.content.client.module.UsesForCursesModule;

public class ArmorStandFakePlayerLayer<M extends EntityModel<ArmorStand>>
extends RenderLayer<ArmorStand, M> {
    private final PlayerModel<?> playerModel;
    private final PlayerModel<?> playerModelSlim;

    public ArmorStandFakePlayerLayer(RenderLayerParent<ArmorStand, M> parent, EntityModelSet models) {
        super(parent);
        this.playerModel = new PlayerModel(models.bakeLayer(ModelLayers.PLAYER), false);
        this.playerModelSlim = new PlayerModel(models.bakeLayer(ModelLayers.PLAYER_SLIM), true);
    }

    public void render(@NotNull PoseStack pose, @NotNull MultiBufferSource buffer, int light, @NotNull ArmorStand armor, float p_117353_, float p_117354_, float p_117355_, float p_117356_, float p_117357_, float p_117358_) {
        GameProfile profile;
        RenderType rendertype;
        if (!UsesForCursesModule.staticEnabled || !UsesForCursesModule.bindArmorStandsWithPlayerHeads) {
            return;
        }
        ItemStack head = armor.getItemBySlot(EquipmentSlot.HEAD);
        if (head.is(Items.PLAYER_HEAD) && EnchantmentHelper.has((ItemStack)head, (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE) && head.has(DataComponents.PROFILE) && (rendertype = SkullBlockRenderer.getRenderType((SkullBlock.Type)SkullBlock.Types.PLAYER, (ResolvableProfile)new ResolvableProfile(profile = ((ResolvableProfile)head.get(DataComponents.PROFILE)).gameProfile()))) != null) {
            PlayerSkin playerSkin;
            boolean slim = false;
            if (profile != null && (playerSkin = Minecraft.getInstance().getSkinManager().getInsecureSkin(profile)) != null) {
                slim = playerSkin.model().equals((Object)PlayerSkin.Model.SLIM);
            }
            pose.pushPose();
            if (armor.isBaby()) {
                s = 1.0f;
                pose.translate(0.0f, 0.0f, 0.0f);
                pose.scale(s, s, s);
            } else {
                s = 2.0f;
                pose.translate(0.0f, -1.5f, 0.0f);
                pose.scale(s, s, s);
            }
            PlayerModel<?> model = slim ? this.playerModelSlim : this.playerModel;
            model.head.visible = false;
            model.hat.visible = false;
            this.rotateModel(model.leftArm, armor.getLeftArmPose());
            this.rotateModel(model.rightArm, armor.getRightArmPose());
            this.rotateModel(model.leftSleeve, armor.getLeftArmPose());
            this.rotateModel(model.rightSleeve, armor.getRightArmPose());
            this.rotateModel(model.leftLeg, armor.getLeftLegPose());
            this.rotateModel(model.rightLeg, armor.getRightLegPose());
            this.rotateModel(model.leftPants, armor.getLeftLegPose());
            this.rotateModel(model.rightPants, armor.getRightLegPose());
            model.renderToBuffer(pose, buffer.getBuffer(rendertype), light, OverlayTexture.NO_OVERLAY, -1);
            pose.popPose();
        }
    }

    private void rotateModel(ModelPart part, Rotations rot) {
        part.setRotation((float)Math.PI / 180 * rot.getX(), (float)Math.PI / 180 * rot.getY(), (float)Math.PI / 180 * rot.getZ());
    }
}

