/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.client.tooltip;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.TippedArrowItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.client.handler.ClientUtil;
import org.violetmoon.quark.catnip.animation.AnimationTickHolder;
import org.violetmoon.quark.content.client.module.ImprovedTooltipsModule;
import org.violetmoon.quark.content.client.resources.AttributeIconEntry;
import org.violetmoon.quark.content.client.resources.AttributeSlot;
import org.violetmoon.zeta.client.event.play.ZGatherTooltipComponents;

public class AttributeTooltips {
    public static final ResourceLocation TEXTURE_UPGRADE = Quark.asResource("textures/attribute/upgrade.png");
    public static final ResourceLocation TEXTURE_DOWNGRADE = Quark.asResource("textures/attribute/downgrade.png");
    private static final Map<ResourceLocation, AttributeIconEntry> attributes = new HashMap<ResourceLocation, AttributeIconEntry>();

    public static void receiveAttributes(Map<String, AttributeIconEntry> map) {
        attributes.clear();
        for (Map.Entry<String, AttributeIconEntry> entry : map.entrySet()) {
            attributes.put(ResourceLocation.parse((String)entry.getKey()), entry.getValue());
        }
    }

    @Nullable
    private static AttributeIconEntry getIconForAttribute(Holder<Attribute> attribute) {
        ResourceLocation loc = attribute.getKey().location();
        if (loc != null) {
            return attributes.get(loc);
        }
        return null;
    }

    private static MutableComponent format(ItemAttributeModifiers.Entry entry) {
        double value = entry.modifier().amount();
        switch (entry.modifier().operation()) {
            case ADD_VALUE: {
                return Component.literal((String)((value > 0.0 ? "+" : "") + ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(value).formatted(value < 0.0 ? ChatFormatting.RED : ChatFormatting.WHITE)));
            }
            case ADD_MULTIPLIED_BASE: {
                return Component.literal((String)((value > 0.0 ? "+" : "") + ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(value * 100.0 + "%").formatted(value < 0.0 ? ChatFormatting.RED : ChatFormatting.WHITE)));
            }
            case ADD_MULTIPLIED_TOTAL: {
                AttributeSupplier supplier = DefaultAttributes.getSupplier((EntityType)EntityType.PLAYER);
                double scaledValue = value / supplier.getBaseValue(entry.attribute());
                return Component.literal((String)(ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(scaledValue) + "x")).withStyle(scaledValue < 1.0 ? ChatFormatting.RED : ChatFormatting.WHITE);
            }
        }
        return Component.literal((String)ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(value)).withStyle(value < 0.0 ? ChatFormatting.RED : ChatFormatting.WHITE);
    }

    public static void makeTooltip(ZGatherTooltipComponents event) {
        ItemStack stack = event.getItemStack();
        if (!Screen.hasShiftDown() && stack.has(DataComponents.ATTRIBUTE_MODIFIERS) && !((ItemAttributeModifiers)stack.get(DataComponents.ATTRIBUTE_MODIFIERS)).modifiers().isEmpty()) {
            if (Minecraft.getInstance().player == null) {
                return;
            }
            List tooltipRaw = event.getTooltipElements();
            ItemAttributeModifiers modifiers = (ItemAttributeModifiers)stack.get(DataComponents.ATTRIBUTE_MODIFIERS);
            LocalPlayer player = Minecraft.getInstance().player;
            tooltipRaw.add(1, Either.right((Object)new AttributeComponent(stack)));
        }
    }

    private static Multimap<Attribute, AttributeModifier> getModifiersOnEquipped(Player player, ItemStack stack, Multimap<Attribute, AttributeModifier> attributes, AttributeSlot slot) {
        return ImmutableMultimap.of();
    }

    private static Multimap<Attribute, AttributeModifier> getModifiers(ItemStack stack, AttributeSlot slot) {
        return ImmutableMultimap.of();
    }

    private static int renderAttribute(GuiGraphics guiGraphics, ItemAttributeModifiers.Entry entry, int x, int y, ItemStack stack, ItemAttributeModifiers slotAttributes, Minecraft mc, boolean forceRenderIfZero, ItemAttributeModifiers equippedSlotAttributes, @Nullable Set<ItemAttributeModifiers.Entry> equippedAttrsToRender) {
        AttributeIconEntry iconEntry = AttributeTooltips.getIconForAttribute((Holder<Attribute>)entry.attribute());
        if (iconEntry != null) {
            if (equippedAttrsToRender != null) {
                equippedAttrsToRender.remove(entry);
            }
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.blit(iconEntry.texture(), x, y, 0.0f, 0.0f, 9, 9, 9, 9);
            MutableComponent valueStr = AttributeTooltips.format(entry);
            if (ImprovedTooltipsModule.showUpgradeStatus) {
                ItemStack equipped;
                AttributeIconEntry.CompareType compareType = iconEntry.comparison();
                if (!(mc.player == null || (equipped = mc.player.getItemBySlot(mc.player.getEquipmentSlotForItem(stack))).equals(stack) || equipped.isEmpty() || equippedSlotAttributes.modifiers().isEmpty())) {
                    ItemAttributeModifiers.Entry comparedAttribute = null;
                    for (ItemAttributeModifiers.Entry real : equippedSlotAttributes.modifiers()) {
                        if (!real.attribute().equals((Object)entry.attribute())) continue;
                        comparedAttribute = real;
                    }
                    if (comparedAttribute != null) {
                        ChatFormatting color = compareType.getColor(entry.modifier().amount(), comparedAttribute.modifier().amount());
                        if (color != ChatFormatting.WHITE) {
                            int xp = x - 2;
                            int yp = y - 2;
                            if (ImprovedTooltipsModule.animateUpDownArrows && (float)AnimationTickHolder.getTicks() + Minecraft.getInstance().getTimer().getGameTimeDeltaTicks() % 20.0f < 10.0f) {
                                ++yp;
                            }
                            guiGraphics.blit(color == ChatFormatting.RED ? TEXTURE_DOWNGRADE : TEXTURE_UPGRADE, xp, yp, 0.0f, 0.0f, 13, 13, 13, 13);
                        }
                        valueStr = valueStr.withStyle(color);
                    }
                }
            }
            guiGraphics.drawString(mc.font, (Component)valueStr, x + 12, y + 1, -1);
            x += mc.font.width((FormattedText)valueStr) + 20;
        }
        return x;
    }

    private static AttributeSlot getPrimarySlot(ItemStack stack) {
        if (stack.getItem() instanceof PotionItem || stack.getItem() instanceof TippedArrowItem) {
            return AttributeSlot.POTION;
        }
        return AttributeSlot.fromCanonicalSlot(stack.getEquipmentSlot());
    }

    private static boolean canShowAttributes(ItemStack stack) {
        if (stack.isEmpty() || !stack.has(DataComponents.ATTRIBUTE_MODIFIERS) || ((ItemAttributeModifiers)stack.get(DataComponents.ATTRIBUTE_MODIFIERS)).modifiers().isEmpty()) {
            return false;
        }
        return !stack.has(DataComponents.HIDE_TOOLTIP);
    }

    public record AttributeComponent(ItemStack stack) implements ClientTooltipComponent,
    TooltipComponent
    {
        public void renderImage(@NotNull Font font, int tooltipX, int tooltipY, @NotNull GuiGraphics guiGraphics) {
            PoseStack pose = guiGraphics.pose();
            if (!Screen.hasShiftDown()) {
                pose.pushPose();
                pose.translate(0.0f, 0.0f, 500.0f);
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft mc = Minecraft.getInstance();
                int y = tooltipY - 1;
                EquipmentSlot primarySlot = mc.player.getEquipmentSlotForItem(this.stack);
                boolean showSlots = false;
                int x = tooltipX;
                ItemAttributeModifiers attributeModifiers = (ItemAttributeModifiers)this.stack.get(DataComponents.ATTRIBUTE_MODIFIERS);
                ItemStack itemInSlot = mc.player.getItemBySlot(primarySlot);
                ItemAttributeModifiers modifiersOnItemInSlot = (ItemAttributeModifiers)itemInSlot.get(DataComponents.ATTRIBUTE_MODIFIERS);
                LinkedHashSet temporaryLookAtMe = new LinkedHashSet();
                modifiersOnItemInSlot.modifiers().forEach(entry -> temporaryLookAtMe.add(entry.attribute()));
                LinkedHashSet<ItemAttributeModifiers.Entry> equippedAttrsToRender = new LinkedHashSet<ItemAttributeModifiers.Entry>();
                for (ItemAttributeModifiers.Entry entry2 : attributeModifiers.modifiers()) {
                    if (!temporaryLookAtMe.contains(entry2.attribute())) continue;
                    equippedAttrsToRender.add(entry2);
                }
                for (ItemAttributeModifiers.Entry entry2 : attributeModifiers.modifiers()) {
                    if (AttributeTooltips.getIconForAttribute((Holder<Attribute>)entry2.attribute()) == null || !entry2.slot().test(primarySlot)) continue;
                    showSlots = true;
                    break;
                }
                boolean anyToRender = false;
                for (ItemAttributeModifiers.Entry entry3 : attributeModifiers.modifiers()) {
                    if (entry3.modifier().amount() == 0.0) continue;
                    anyToRender = true;
                    break;
                }
                if (anyToRender) {
                    if (showSlots) {
                        RenderSystem.setShader(GameRenderer::getPositionTexShader);
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        guiGraphics.blit(ClientUtil.GENERAL_ICONS, x, y, (float)(193 + primarySlot.ordinal() * 9), 35.0f, 9, 9, 256, 256);
                        x += 20;
                    }
                    for (ItemAttributeModifiers.Entry entry3 : attributeModifiers.modifiers()) {
                        x = AttributeTooltips.renderAttribute(guiGraphics, entry3, x, y, this.stack, attributeModifiers, mc, false, modifiersOnItemInSlot, equippedAttrsToRender);
                    }
                    for (ItemAttributeModifiers.Entry entry3 : equippedAttrsToRender) {
                        x = AttributeTooltips.renderAttribute(guiGraphics, entry3, x, y, this.stack, attributeModifiers, mc, true, modifiersOnItemInSlot, null);
                    }
                    for (ItemAttributeModifiers.Entry entry3 : attributeModifiers.modifiers()) {
                        if (AttributeTooltips.getIconForAttribute((Holder<Attribute>)entry3.attribute()) != null) continue;
                        guiGraphics.drawString(font, "[+]", x + 1, y + 1, 0xFFFF55, true);
                        break;
                    }
                }
                pose.popPose();
            }
        }

        public int getHeight() {
            return 10;
        }

        public int getWidth(@NotNull Font font) {
            return 128;
        }
    }

    public record ModifierData(Holder<Attribute> attribute, AttributeModifier modifier, EquipmentSlotGroup slot) {
    }
}

