/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.mobs.ai;

import java.util.EnumSet;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.violetmoon.quark.content.mobs.entity.Shiba;

public class BarkAtDarknessGoal
extends Goal {
    private final Shiba shiba;
    private final PathNavigation navigator;

    public BarkAtDarknessGoal(Shiba shiba) {
        this.shiba = shiba;
        this.navigator = shiba.getNavigation();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public void tick() {
        if (this.shiba.currentHyperfocus != null) {
            this.navigator.moveTo(this.navigator.createPath(this.shiba.currentHyperfocus, 1), 1.1);
            Level level = this.shiba.level();
            if (level instanceof ServerLevel) {
                ServerLevel slevel = (ServerLevel)level;
                if (this.shiba.tickCount % 10 == 0) {
                    Vec3 pos = this.shiba.position();
                    slevel.sendParticles((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, pos.x, pos.y + 0.5, pos.z, 1, 0.25, (double)0.1f, 0.25, 0.0);
                    this.shiba.lookAt(EntityAnchorArgument.Anchor.EYES, new Vec3((double)this.shiba.currentHyperfocus.getX() + 0.5, (double)this.shiba.currentHyperfocus.getY(), (double)this.shiba.currentHyperfocus.getZ() + 0.5));
                    this.shiba.playAmbientSound();
                }
            }
        }
    }

    public boolean canUse() {
        return this.shiba.currentHyperfocus != null;
    }
}

