/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tools.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.base.components.QuarkDataComponents;
import org.violetmoon.zeta.item.ZetaItem;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.CreativeTabManager;

public class SlimeInABucketItem
extends ZetaItem {
    public static final String TAG_ENTITY_DATA = "slime_nbt";
    public static final String TAG_EXCITED = "excited";

    public SlimeInABucketItem(ZetaModule module) {
        super("slime_in_a_bucket", module, new Item.Properties().stacksTo(1).craftRemainder(Items.BUCKET));
        CreativeTabManager.addToCreativeTabNextTo((ResourceKey)CreativeModeTabs.TOOLS_AND_UTILITIES, (ItemLike)this, (ItemLike)Items.TADPOLE_BUCKET, (boolean)false);
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level world, @NotNull Entity entity, int itemSlot, boolean isSelected) {
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            Vec3 pos = entity.position();
            int x = Mth.floor((double)pos.x);
            int z = Mth.floor((double)pos.z);
            boolean slime = SlimeInABucketItem.isSlimeChunk(serverLevel, x, z);
            boolean excited = Boolean.TRUE.equals(stack.get(QuarkDataComponents.EXCITED));
            if (excited != slime) {
                stack.set(QuarkDataComponents.EXCITED, (Object)slime);
            }
        }
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos = context.getClickedPos();
        Direction facing = context.getClickedFace();
        Level worldIn = context.getLevel();
        Player playerIn = context.getPlayer();
        InteractionHand hand = context.getHand();
        double x = (double)pos.getX() + 0.5 + (double)facing.getStepX();
        double y = (double)pos.getY() + 0.5 + (double)facing.getStepY();
        double z = (double)pos.getZ() + 0.5 + (double)facing.getStepZ();
        if (!worldIn.isClientSide) {
            Slime slime = new Slime(EntityType.SLIME, worldIn);
            if (playerIn.getItemInHand(hand).has(QuarkDataComponents.SLIME_NBT)) {
                CompoundTag data = ((CustomData)playerIn.getItemInHand(hand).get(QuarkDataComponents.SLIME_NBT)).copyTag();
                slime.load(data);
            } else {
                slime.getAttribute(Attributes.MAX_HEALTH).setBaseValue(1.0);
                slime.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.3);
                slime.setHealth(slime.getMaxHealth());
            }
            slime.setPos(x, y, z);
            worldIn.gameEvent((Entity)playerIn, (Holder)GameEvent.ENTITY_PLACE, slime.position());
            worldIn.addFreshEntity((Entity)slime);
            playerIn.swing(hand);
        }
        worldIn.playSound(playerIn, pos, SoundEvents.BUCKET_EMPTY, SoundSource.NEUTRAL, 1.0f, 1.0f);
        if (!playerIn.getAbilities().instabuild) {
            playerIn.setItemInHand(hand, new ItemStack((ItemLike)Items.BUCKET));
        }
        return InteractionResult.sidedSuccess((boolean)worldIn.isClientSide);
    }

    @NotNull
    public Component getName(@NotNull ItemStack stack) {
        CompoundTag cmp;
        if (stack.has(QuarkDataComponents.SLIME_NBT) && (cmp = ((CustomData)stack.get(QuarkDataComponents.SLIME_NBT)).copyTag()) != null && cmp.contains("CustomName")) {
            MutableComponent custom = Component.Serializer.fromJson((String)cmp.getString("CustomName"), (HolderLookup.Provider)RegistryAccess.EMPTY);
            return Component.translatable((String)"item.quark.slime_in_a_bucket.named", (Object[])new Object[]{custom});
        }
        return super.getName(stack);
    }

    public static boolean isSlimeChunk(ServerLevel world, int x, int z) {
        ChunkPos chunkpos = new ChunkPos(new BlockPos(x, 0, z));
        return WorldgenRandom.seedSlimeChunk((int)chunkpos.x, (int)chunkpos.z, (long)world.getSeed(), (long)987234911L).nextInt(10) == 0;
    }
}

