/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.base.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ExclusionRecipe
implements CraftingRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    protected final CraftingRecipe parent;
    private final List<ResourceLocation> excluded;

    public ExclusionRecipe(CraftingRecipe parent, List<ResourceLocation> excluded) {
        this.parent = parent;
        this.excluded = excluded;
    }

    public boolean matches(CraftingInput input, Level level) {
        for (ResourceLocation recipeLoc : this.excluded) {
            CraftingRecipe craftingRecipe;
            Recipe recipe;
            Optional recipeHolder = level.getRecipeManager().byKey(recipeLoc);
            if (!recipeHolder.isPresent() || !((recipe = ((RecipeHolder)recipeHolder.get()).value()) instanceof CraftingRecipe) || !(craftingRecipe = (CraftingRecipe)recipe).matches((RecipeInput)input, level)) continue;
            return false;
        }
        return this.parent.matches((RecipeInput)input, level);
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider provider) {
        return this.parent.assemble((RecipeInput)input, provider);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return this.parent.canCraftInDimensions(width, height);
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.parent.getResultItem(provider);
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @NotNull
    public RecipeType<?> getType() {
        return this.parent.getType();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput input) {
        return this.parent.getRemainingItems((RecipeInput)input);
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return this.parent.getIngredients();
    }

    public boolean isSpecial() {
        return this.parent.isSpecial();
    }

    @NotNull
    public String getGroup() {
        return this.parent.getGroup();
    }

    @NotNull
    public ItemStack getToastSymbol() {
        return this.parent.getToastSymbol();
    }

    public CraftingBookCategory category() {
        return this.parent.category();
    }

    public static class Serializer
    implements RecipeSerializer<ExclusionRecipe> {
        public static final MapCodec<ExclusionRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.listOf().fieldOf("excluded").forGetter(exclusionRecipe -> exclusionRecipe.excluded), (App)Recipe.CODEC.fieldOf("parent").forGetter(exclusionRecipe -> exclusionRecipe.parent)).apply((Applicative)instance, (excluded, parent) -> new ExclusionRecipe((CraftingRecipe)parent, (List<ResourceLocation>)excluded)));
        public static final StreamCodec<RegistryFriendlyByteBuf, ExclusionRecipe> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ExclusionRecipe>(){

            @NotNull
            public ExclusionRecipe decode(@NotNull RegistryFriendlyByteBuf buf) {
                Recipe parent = (Recipe)Recipe.STREAM_CODEC.decode((Object)buf);
                List output = buf.readList((StreamDecoder)ResourceLocation.STREAM_CODEC);
                return new ExclusionRecipe((CraftingRecipe)parent, output);
            }

            public void encode(@NotNull RegistryFriendlyByteBuf buf, ExclusionRecipe recipe) {
                Recipe.STREAM_CODEC.encode((Object)buf, (Object)recipe.parent);
                buf.writeCollection(recipe.excluded, (StreamEncoder)ResourceLocation.STREAM_CODEC);
            }
        };

        public MapCodec<ExclusionRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ExclusionRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }

    private static class ShapedExclusionRecipe
    extends ExclusionRecipe
    implements CraftingRecipe {
        private final ShapedRecipe shapedParent;

        public ShapedExclusionRecipe(CraftingRecipe shapedParent, List<ResourceLocation> excluded) {
            super(shapedParent, excluded);
            this.shapedParent = (ShapedRecipe)shapedParent;
        }
    }
}

