/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.building.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.zeta.block.ext.IZetaBlockExtensions;
import org.violetmoon.zeta.registry.IZetaBlockColorProvider;
import org.violetmoon.zeta.registry.IZetaItemColorProvider;
import org.violetmoon.zeta.util.handler.FuelHandler;

public class VerticalSlabBlock
extends Block
implements SimpleWaterloggedBlock,
IZetaBlockColorProvider,
IZetaBlockExtensions,
FuelHandler.ICustomWoodFuelValue {
    public static final EnumProperty<VerticalSlabType> TYPE = EnumProperty.create((String)"type", VerticalSlabType.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public final Supplier<Block> parent;

    public VerticalSlabBlock(Supplier<Block> parent, BlockBehaviour.Properties properties) {
        super(properties);
        this.parent = parent;
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(TYPE, (Comparable)((Object)VerticalSlabType.NORTH))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean isFlammableZeta(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        BlockState parentState = this.parent.get().defaultBlockState();
        return Quark.ZETA.blockExtensions.get(parentState).isFlammableZeta(parentState, world, pos, face);
    }

    public int getFlammabilityZeta(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        BlockState parentState = this.parent.get().defaultBlockState();
        return Quark.ZETA.blockExtensions.get(parentState).getFlammabilityZeta(parentState, world, pos, face);
    }

    @NotNull
    public BlockState rotate(BlockState state, @NotNull Rotation rot) {
        return state.getValue(TYPE) == VerticalSlabType.DOUBLE ? state : (BlockState)state.setValue(TYPE, (Comparable)((Object)VerticalSlabType.fromDirection(rot.rotate(((VerticalSlabType)((Object)state.getValue(VerticalSlabBlock.TYPE))).direction))));
    }

    @NotNull
    public BlockState mirror(BlockState state, @NotNull Mirror mirrorIn) {
        VerticalSlabType type = (VerticalSlabType)((Object)state.getValue(TYPE));
        if (type == VerticalSlabType.DOUBLE || mirrorIn == Mirror.NONE) {
            return state;
        }
        if (mirrorIn == Mirror.LEFT_RIGHT && type.direction.getAxis() == Direction.Axis.Z || mirrorIn == Mirror.FRONT_BACK && type.direction.getAxis() == Direction.Axis.X) {
            return (BlockState)state.setValue(TYPE, (Comparable)((Object)VerticalSlabType.fromDirection(((VerticalSlabType)((Object)state.getValue(VerticalSlabBlock.TYPE))).direction.getOpposite())));
        }
        return state;
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return state.getValue(TYPE) != VerticalSlabType.DOUBLE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TYPE, WATERLOGGED});
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return ((VerticalSlabType)((Object)state.getValue(VerticalSlabBlock.TYPE))).shape;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockpos = context.getClickedPos();
        BlockState blockstate = context.getLevel().getBlockState(blockpos);
        if (blockstate.getBlock() == this) {
            return (BlockState)((BlockState)blockstate.setValue(TYPE, (Comparable)((Object)VerticalSlabType.DOUBLE))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        FluidState fluid = context.getLevel().getFluidState(blockpos);
        BlockState retState = (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.getType() == Fluids.WATER));
        Direction direction = this.getDirectionForPlacement(context);
        VerticalSlabType type = VerticalSlabType.fromDirection(direction);
        return (BlockState)retState.setValue(TYPE, (Comparable)((Object)type));
    }

    private Direction getDirectionForPlacement(BlockPlaceContext context) {
        Direction direction = context.getClickedFace();
        if (direction.getAxis() != Direction.Axis.Y) {
            return direction;
        }
        BlockPos pos = context.getClickedPos();
        Vec3 vec = context.getClickLocation().subtract(new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ())).subtract(0.5, 0.0, 0.5);
        double angle = Math.atan2(vec.x, vec.z) * -180.0 / Math.PI;
        return Direction.fromYRot((double)angle).getOpposite();
    }

    public boolean canBeReplaced(BlockState state, @NotNull BlockPlaceContext useContext) {
        ItemStack itemstack = useContext.getItemInHand();
        VerticalSlabType slabtype = (VerticalSlabType)((Object)state.getValue(TYPE));
        return slabtype != VerticalSlabType.DOUBLE && itemstack.getItem() == this.asItem() && (useContext.replacingClickedOnBlock() && useContext.getClickedFace() == slabtype.direction && this.getDirectionForPlacement(useContext) == slabtype.direction || !useContext.replacingClickedOnBlock() && useContext.getClickedFace() != slabtype.direction);
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean placeLiquid(@NotNull LevelAccessor worldIn, @NotNull BlockPos pos, BlockState state, @NotNull FluidState fluidStateIn) {
        return state.getValue(TYPE) != VerticalSlabType.DOUBLE && super.placeLiquid(worldIn, pos, state, fluidStateIn);
    }

    public boolean canPlaceLiquid(@Nullable Player player, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, BlockState state, @NotNull Fluid fluidIn) {
        return state.getValue(TYPE) != VerticalSlabType.DOUBLE && super.canPlaceLiquid(player, worldIn, pos, state, fluidIn);
    }

    @NotNull
    public BlockState updateShape(@NotNull BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return type == PathComputationType.WATER && state.getFluidState().is(FluidTags.WATER);
    }

    @Nullable
    public String getBlockColorProviderName() {
        String string;
        Block block = this.parent.get();
        if (block instanceof IZetaBlockColorProvider) {
            IZetaBlockColorProvider prov = (IZetaBlockColorProvider)block;
            string = prov.getBlockColorProviderName();
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public String getItemColorProviderName() {
        String string;
        Block block = this.parent.get();
        if (block instanceof IZetaItemColorProvider) {
            IZetaItemColorProvider prov = (IZetaItemColorProvider)block;
            string = prov.getItemColorProviderName();
        } else {
            string = null;
        }
        return string;
    }

    public int getBurnTimeInTicksWhenWooden() {
        return 150;
    }

    public static enum VerticalSlabType implements StringRepresentable
    {
        NORTH(Direction.NORTH),
        SOUTH(Direction.SOUTH),
        WEST(Direction.WEST),
        EAST(Direction.EAST),
        DOUBLE(null);

        private final String name;
        public final Direction direction;
        public final VoxelShape shape;

        private VerticalSlabType(Direction direction) {
            this.name = direction == null ? "double" : direction.getSerializedName();
            this.direction = direction;
            if (direction == null) {
                this.shape = Shapes.block();
            } else {
                double min = 0.0;
                double max = 8.0;
                if (direction.getAxisDirection() == Direction.AxisDirection.NEGATIVE) {
                    min = 8.0;
                    max = 16.0;
                }
                this.shape = direction.getAxis() == Direction.Axis.X ? Block.box((double)min, (double)0.0, (double)0.0, (double)max, (double)16.0, (double)16.0) : Block.box((double)0.0, (double)0.0, (double)min, (double)16.0, (double)16.0, (double)max);
            }
        }

        public String toString() {
            return this.name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        public static VerticalSlabType fromDirection(Direction direction) {
            for (VerticalSlabType type : VerticalSlabType.values()) {
                if (type.direction == null || direction != type.direction) continue;
                return type;
            }
            return null;
        }
    }
}

