/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.base.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MinecartItem;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TippedArrowItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.violetmoon.quark.addons.oddities.inventory.BackpackMenu;
import org.violetmoon.quark.addons.oddities.inventory.slot.CachedItemHandlerSlot;
import org.violetmoon.quark.api.ICustomSorting;
import org.violetmoon.quark.api.ISortingLockedSlots;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.management.module.InventorySortingModule;

public final class SortingHandler {
    private static final Comparator<ItemStack> FALLBACK_COMPARATOR = SortingHandler.jointComparator(Arrays.asList(Comparator.comparingInt(s -> Item.getId((Item)s.getItem())), SortingHandler::damageCompare, (s1, s2) -> s2.getCount() - s1.getCount(), (s1, s2) -> s2.hashCode() - s1.hashCode(), SortingHandler::fallbackComponentCompare));
    private static final Comparator<ItemStack> FOOD_COMPARATOR = SortingHandler.jointComparator(Arrays.asList(SortingHandler::foodHealCompare, SortingHandler::foodSaturationCompare));
    private static final Comparator<ItemStack> TOOL_COMPARATOR = SortingHandler.jointComparator(Arrays.asList(SortingHandler::toolPowerCompare, SortingHandler::enchantmentCompare, SortingHandler::damageCompare));
    private static final Comparator<ItemStack> SWORD_COMPARATOR = SortingHandler.jointComparator(Arrays.asList(SortingHandler::swordPowerCompare, SortingHandler::enchantmentCompare, SortingHandler::damageCompare));
    private static final Comparator<ItemStack> ARMOR_COMPARATOR = SortingHandler.jointComparator(Arrays.asList(SortingHandler::armorSlotAndToughnessCompare, SortingHandler::enchantmentCompare, SortingHandler::damageCompare));
    private static final Comparator<ItemStack> BOW_COMPARATOR = SortingHandler.jointComparator(Arrays.asList(SortingHandler::enchantmentCompare, SortingHandler::damageCompare));
    private static final Comparator<ItemStack> POTION_COMPARATOR = SortingHandler.jointComparator(Arrays.asList(SortingHandler::potionComplexityCompare, SortingHandler::potionTypeCompare));

    public static void sortInventory(Player player, boolean forcePlayer) {
        AbstractContainerMenu c;
        if (!Quark.ZETA.modules.isEnabled(InventorySortingModule.class)) {
            return;
        }
        AbstractContainerMenu ogc = c = player.containerMenu;
        boolean backpack = c instanceof BackpackMenu;
        boolean sortingLocked = c instanceof ISortingLockedSlots;
        if (!backpack && forcePlayer || c == null) {
            c = player.inventoryMenu;
        }
        boolean playerContainer = c == player.inventoryMenu || backpack;
        int[] lockedSlots = null;
        if (sortingLocked) {
            ISortingLockedSlots sls = (ISortingLockedSlots)ogc;
            lockedSlots = sls.getSortingLockedSlots(playerContainer);
        }
        for (Slot s : c.slots) {
            Container inv = s.container;
            if (inv == player.getInventory() != playerContainer) continue;
            if (playerContainer) {
                SortingHandler.sortInventory(inv, 9, 36, lockedSlots);
                break;
            }
            SortingHandler.sortInventory(inv, lockedSlots);
            break;
        }
        if (backpack) {
            for (Slot s : c.slots) {
                if (!(s instanceof CachedItemHandlerSlot)) continue;
                CachedItemHandlerSlot cachedSlot = (CachedItemHandlerSlot)s;
                SortingHandler.sortInventory(cachedSlot.container, lockedSlots);
                break;
            }
        }
    }

    public static void sortInventory(Container container, int[] lockedSlots) {
        SortingHandler.sortInventory(container, 0, lockedSlots);
    }

    public static void sortInventory(Container container, int iStart, int[] lockedSlots) {
        SortingHandler.sortInventory(container, iStart, container.getContainerSize(), lockedSlots);
    }

    public static void sortInventory(Container container, int iStart, int iEnd, int[] lockedSlots) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        ArrayList<ItemStack> restore = new ArrayList<ItemStack>();
        for (int i = iStart; i < iEnd; ++i) {
            ItemStack stackAt = container.getItem(i);
            restore.add(stackAt.copy());
            if (SortingHandler.isLocked(i, lockedSlots) || stackAt.isEmpty()) continue;
            stacks.add(stackAt.copy());
        }
        SortingHandler.mergeStacks(stacks);
        SortingHandler.sortStackList(stacks);
        if (SortingHandler.setInventory(container, stacks, iStart, iEnd, lockedSlots) == InteractionResult.FAIL) {
            SortingHandler.setInventory(container, restore, iStart, iEnd, lockedSlots);
        }
    }

    private static InteractionResult setInventory(Container container, List<ItemStack> stacks, int iStart, int iEnd, int[] lockedSlots) {
        int slot;
        int skipped = 0;
        HashMap<Integer, ItemStack> containerCopy = new HashMap<Integer, ItemStack>();
        for (int containSlot = 0; containSlot < container.getContainerSize(); ++containSlot) {
            containerCopy.put(containSlot, container.getItem(containSlot));
        }
        container.clearContent();
        for (slot = 0; slot < container.getContainerSize(); ++slot) {
            if (slot >= iStart && slot <= iEnd) continue;
            container.setItem(slot, (ItemStack)containerCopy.get(slot));
        }
        for (slot = iStart; slot < iEnd; ++slot) {
            if (SortingHandler.isLocked(slot, lockedSlots)) {
                container.setItem(slot, (ItemStack)containerCopy.get(slot));
                ++skipped;
                continue;
            }
            container.setItem(slot, stacks.get(slot - iStart - skipped));
        }
        return InteractionResult.SUCCESS;
    }

    private static boolean isLocked(int slot, int[] locked) {
        if (locked == null) {
            return false;
        }
        for (int i : locked) {
            if (slot != i) continue;
            return true;
        }
        return false;
    }

    public static void mergeStacks(List<ItemStack> list) {
        for (int i = 0; i < list.size(); ++i) {
            ItemStack set = SortingHandler.mergeStackWithOthers(list, i);
            list.set(i, set);
        }
        list.removeIf(stack -> stack.isEmpty() || stack.getCount() == 0);
    }

    private static ItemStack mergeStackWithOthers(List<ItemStack> list, int index) {
        ItemStack stack = list.get(index);
        if (stack.isEmpty()) {
            return stack;
        }
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stackAt;
            if (i == index || (stackAt = list.get(i)).isEmpty() || stackAt.getCount() >= stackAt.getMaxStackSize() || !ItemStack.isSameItem((ItemStack)stack, (ItemStack)stackAt) || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)stackAt)) continue;
            int setSize = stackAt.getCount() + stack.getCount();
            int carryover = Math.max(0, setSize - stackAt.getMaxStackSize());
            stackAt.setCount(carryover);
            stack.setCount(setSize - carryover);
            if (stack.getCount() != stack.getMaxStackSize()) continue;
            return stack;
        }
        return stack;
    }

    public static void sortStackList(List<ItemStack> list) {
        list.sort(SortingHandler::stackCompare);
    }

    private static int stackCompare(ItemStack stack1, ItemStack stack2) {
        ItemType type2;
        ItemType type1;
        if (stack1 == stack2) {
            return 0;
        }
        if (stack1.isEmpty()) {
            return -1;
        }
        if (stack2.isEmpty()) {
            return 1;
        }
        if (SortingHandler.hasCustomSorting(stack1) && SortingHandler.hasCustomSorting(stack2)) {
            ICustomSorting sort1 = SortingHandler.getCustomSorting(stack1);
            ICustomSorting sort2 = SortingHandler.getCustomSorting(stack2);
            if (sort1.getSortingCategory().equals(sort2.getSortingCategory())) {
                return sort1.getItemComparator().compare(stack1, stack2);
            }
        }
        if ((type1 = SortingHandler.getType(stack1)) == (type2 = SortingHandler.getType(stack2))) {
            return type1.comparator.compare(stack1, stack2);
        }
        return type1.ordinal() - type2.ordinal();
    }

    private static ItemType getType(ItemStack stack) {
        for (ItemType type : ItemType.values()) {
            if (!type.fitsInType(stack)) continue;
            return type;
        }
        throw new RuntimeException("Having an ItemStack that doesn't fit in any type is impossible.");
    }

    private static Predicate<ItemStack> classPredicate(Class<? extends Item> clazz) {
        return s -> !s.isEmpty() && clazz.isInstance(s.getItem());
    }

    private static Predicate<ItemStack> inverseClassPredicate(Class<? extends Item> clazz) {
        return SortingHandler.classPredicate(clazz).negate();
    }

    private static Predicate<ItemStack> itemPredicate(List<Item> list) {
        return s -> !s.isEmpty() && list.contains(s.getItem());
    }

    public static Comparator<ItemStack> jointComparator(Comparator<ItemStack> finalComparator, List<Comparator<ItemStack>> otherComparators) {
        if (otherComparators == null) {
            return SortingHandler.jointComparator(List.of(finalComparator));
        }
        ArrayList<Comparator<ItemStack>> newList = new ArrayList<Comparator<ItemStack>>(otherComparators);
        newList.add(finalComparator);
        return SortingHandler.jointComparator(newList);
    }

    public static Comparator<ItemStack> jointComparator(List<Comparator<ItemStack>> comparators) {
        return SortingHandler.jointComparatorFallback((s1, s2) -> {
            for (Comparator comparator : comparators) {
                int compare;
                if (comparator == null || (compare = comparator.compare(s1, s2)) == 0) continue;
                return compare;
            }
            return 0;
        }, FALLBACK_COMPARATOR);
    }

    private static Comparator<ItemStack> jointComparatorFallback(Comparator<ItemStack> comparator, Comparator<ItemStack> fallback) {
        return (s1, s2) -> {
            int compare = comparator.compare((ItemStack)s1, (ItemStack)s2);
            if (compare == 0) {
                return fallback == null ? 0 : fallback.compare((ItemStack)s1, (ItemStack)s2);
            }
            return compare;
        };
    }

    private static Comparator<ItemStack> listOrderComparator(List<Item> list) {
        return (stack1, stack2) -> {
            Item i1 = stack1.getItem();
            Item i2 = stack2.getItem();
            if (list.contains(i1)) {
                if (list.contains(i2)) {
                    return list.indexOf(i1) - list.indexOf(i2);
                }
                return 1;
            }
            if (list.contains(i2)) {
                return -1;
            }
            return 0;
        };
    }

    private static List<Item> list(Object ... items) {
        ArrayList<Item> itemList = new ArrayList<Item>();
        for (Object o : items) {
            String s;
            Item item;
            if (o == null) continue;
            if (o instanceof Item) {
                Item item2 = (Item)o;
                itemList.add(item2);
                continue;
            }
            if (o instanceof Block) {
                Block block = (Block)o;
                itemList.add(block.asItem());
                continue;
            }
            if (o instanceof ItemStack) {
                ItemStack stack = (ItemStack)o;
                itemList.add(stack.getItem());
                continue;
            }
            if (!(o instanceof String) || (item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)(s = (String)o)))) == Items.AIR) continue;
            itemList.add(item);
        }
        return itemList;
    }

    private static int nutrition(FoodProperties properties) {
        if (properties == null) {
            return 0;
        }
        return properties.nutrition();
    }

    private static int foodHealCompare(ItemStack stack1, ItemStack stack2) {
        return SortingHandler.nutrition((FoodProperties)stack2.get(DataComponents.FOOD)) - SortingHandler.nutrition((FoodProperties)stack1.get(DataComponents.FOOD));
    }

    private static float saturation(FoodProperties properties) {
        if (properties == null) {
            return 0.0f;
        }
        return Math.min(20.0f, (float)properties.nutrition() * properties.saturation() * 2.0f);
    }

    private static int foodSaturationCompare(ItemStack stack1, ItemStack stack2) {
        return (int)(SortingHandler.saturation((FoodProperties)stack2.get(DataComponents.FOOD)) - SortingHandler.saturation((FoodProperties)stack1.get(DataComponents.FOOD)));
    }

    private static int enchantmentCompare(ItemStack stack1, ItemStack stack2) {
        return SortingHandler.enchantmentPower(stack2) - SortingHandler.enchantmentPower(stack1);
    }

    private static int enchantmentPower(ItemStack stack) {
        if (!stack.isEnchanted()) {
            return 0;
        }
        ItemEnchantments enchantments = stack.getTagEnchantments();
        int total = 0;
        for (Holder enchantment : enchantments.keySet()) {
            total += enchantments.getLevel(enchantment);
        }
        return total;
    }

    private static int toolPowerCompare(ItemStack stack1, ItemStack stack2) {
        Tier mat1 = ((DiggerItem)stack1.getItem()).getTier();
        Tier mat2 = ((DiggerItem)stack2.getItem()).getTier();
        return (int)(mat2.getSpeed() * 100.0f - mat1.getSpeed() * 100.0f);
    }

    private static int swordPowerCompare(ItemStack stack1, ItemStack stack2) {
        Tier mat1 = ((SwordItem)stack1.getItem()).getTier();
        Tier mat2 = ((SwordItem)stack2.getItem()).getTier();
        return (int)(mat2.getAttackDamageBonus() * 100.0f - mat1.getAttackDamageBonus() * 100.0f);
    }

    private static int armorSlotAndToughnessCompare(ItemStack stack1, ItemStack stack2) {
        EquipmentSlot slot2;
        ArmorItem armor1 = (ArmorItem)stack1.getItem();
        ArmorItem armor2 = (ArmorItem)stack2.getItem();
        EquipmentSlot slot1 = armor1.getEquipmentSlot();
        if (slot1 == (slot2 = armor2.getEquipmentSlot())) {
            return ((ArmorMaterial)armor2.getMaterial().value()).getDefense(armor2.getType()) - ((ArmorMaterial)armor2.getMaterial().value()).getDefense(armor1.getType());
        }
        return slot2.getIndex() - slot1.getIndex();
    }

    public static int damageCompare(ItemStack stack1, ItemStack stack2) {
        return stack1.getDamageValue() - stack2.getDamageValue();
    }

    public static int fallbackComponentCompare(ItemStack stack1, ItemStack stack2) {
        boolean hasTag2;
        boolean hasTag1 = !stack1.getComponents().isEmpty();
        boolean bl = hasTag2 = !stack2.getComponents().isEmpty();
        if (hasTag2 && !hasTag1) {
            return -1;
        }
        if (hasTag1 && !hasTag2) {
            return 1;
        }
        if (!hasTag1) {
            return 0;
        }
        return stack2.getComponents().toString().hashCode() - stack1.getComponents().toString().hashCode();
    }

    public static int potionComplexityCompare(ItemStack stack1, ItemStack stack2) {
        ArrayList effects1 = new ArrayList();
        ((PotionContents)stack1.get(DataComponents.POTION_CONTENTS)).getAllEffects().forEach(effects1::add);
        ArrayList effects2 = new ArrayList();
        ((PotionContents)stack2.get(DataComponents.POTION_CONTENTS)).getAllEffects().forEach(effects2::add);
        int totalPower1 = 0;
        int totalPower2 = 0;
        for (MobEffectInstance inst : effects1) {
            totalPower1 += inst.getAmplifier() * inst.getDuration();
        }
        for (MobEffectInstance inst : effects2) {
            totalPower2 += inst.getAmplifier() * inst.getDuration();
        }
        return totalPower2 - totalPower1;
    }

    public static int potionTypeCompare(ItemStack stack1, ItemStack stack2) {
        Holder potion1 = (Holder)((PotionContents)stack1.get(DataComponents.POTION_CONTENTS)).potion().get();
        Holder potion2 = (Holder)((PotionContents)stack2.get(DataComponents.POTION_CONTENTS)).potion().get();
        return BuiltInRegistries.POTION.getId((Object)((Potion)potion2.value())) - BuiltInRegistries.POTION.getId((Object)((Potion)potion1.value()));
    }

    static boolean hasCustomSorting(ItemStack stack) {
        return false;
    }

    static ICustomSorting getCustomSorting(ItemStack stack) {
        return new ICustomSorting(){

            @Override
            public Comparator<ItemStack> getItemComparator() {
                return null;
            }

            @Override
            public String getSortingCategory() {
                return "NULL";
            }
        };
    }

    private static enum ItemType {
        TORCH(SortingHandler.list(Blocks.TORCH)),
        TOOL_PICKAXE(SortingHandler.classPredicate(PickaxeItem.class), TOOL_COMPARATOR),
        TOOL_SHOVEL(SortingHandler.classPredicate(ShovelItem.class), TOOL_COMPARATOR),
        TOOL_AXE(SortingHandler.classPredicate(AxeItem.class), TOOL_COMPARATOR),
        TOOL_SWORD(SortingHandler.classPredicate(SwordItem.class), SWORD_COMPARATOR),
        TOOL_GENERIC(SortingHandler.classPredicate(DiggerItem.class), TOOL_COMPARATOR),
        ARMOR(SortingHandler.classPredicate(ArmorItem.class), ARMOR_COMPARATOR),
        BOW(SortingHandler.classPredicate(BowItem.class), BOW_COMPARATOR),
        CROSSBOW(SortingHandler.classPredicate(CrossbowItem.class), BOW_COMPARATOR),
        TRIDENT(SortingHandler.classPredicate(TridentItem.class), BOW_COMPARATOR),
        ARROWS(SortingHandler.classPredicate(ArrowItem.class)),
        POTION(SortingHandler.classPredicate(PotionItem.class), POTION_COMPARATOR),
        TIPPED_ARROW(SortingHandler.classPredicate(TippedArrowItem.class), POTION_COMPARATOR),
        MINECART(SortingHandler.classPredicate(MinecartItem.class)),
        RAIL(SortingHandler.list(Blocks.RAIL, Blocks.POWERED_RAIL, Blocks.DETECTOR_RAIL, Blocks.ACTIVATOR_RAIL)),
        DYE(SortingHandler.classPredicate(DyeItem.class)),
        ANY(SortingHandler.inverseClassPredicate(BlockItem.class)),
        BLOCK(SortingHandler.classPredicate(BlockItem.class));

        private final Predicate<ItemStack> predicate;
        private final Comparator<ItemStack> comparator;

        private ItemType(List<Item> list) {
            this(SortingHandler.itemPredicate(list), SortingHandler.jointComparator(SortingHandler.listOrderComparator(list), new ArrayList<Comparator<ItemStack>>()));
        }

        private ItemType(Predicate<ItemStack> predicate) {
            this(predicate, FALLBACK_COMPARATOR);
        }

        private ItemType(Predicate<ItemStack> predicate, Comparator<ItemStack> comparator) {
            this.predicate = predicate;
            this.comparator = comparator;
        }

        public boolean fitsInType(ItemStack stack) {
            return this.predicate.test(stack);
        }
    }
}

