/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.datagen;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonWriter;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.concurrent.CompletableFuture;
import java.util.function.ToIntFunction;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.GsonHelper;

public interface QuarkDataProvider
extends DataProvider {
    public static final ToIntFunction<String> FIXED_ORDER_FIELDS = (ToIntFunction)Util.make((Object)new Object2IntOpenHashMap(), map -> {
        map.put((Object)"quark:conditions", -1);
        map.put((Object)"type", 0);
        map.put((Object)"flag", 1);
        map.defaultReturnValue(2);
    });
    public static final Comparator<String> KEY_COMPARATOR = Comparator.comparingInt(FIXED_ORDER_FIELDS).thenComparing(s -> s);

    public static <T> CompletableFuture<?> saveStable2(CachedOutput cachedOutput, HolderLookup.Provider holderLookupProvider, Codec<T> codec, T t, Path path, String module, String flag) {
        RegistryOps registryops = holderLookupProvider.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
        JsonElement jsonelement = (JsonElement)codec.encodeStart((DynamicOps)registryops, t).getOrThrow();
        return QuarkDataProvider.saveStable(cachedOutput, jsonelement, path, module, flag);
    }

    public static CompletableFuture<?> saveStable(CachedOutput cachedOutput, JsonElement jsonElement, Path path, String module, String flag) {
        return CompletableFuture.runAsync(() -> {
            try {
                ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
                HashingOutputStream hashingoutputstream = new HashingOutputStream(Hashing.sha1(), (OutputStream)bytearrayoutputstream);
                try (JsonWriter jsonwriter = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)hashingoutputstream, StandardCharsets.UTF_8));){
                    jsonwriter.setSerializeNulls(false);
                    jsonwriter.setIndent(" ".repeat(Math.max(0, INDENT_WIDTH.get())));
                    GsonHelper.writeValue((JsonWriter)jsonwriter, (JsonElement)jsonElement, KEY_COMPARATOR);
                }
                cachedOutput.writeIfNeeded(path, bytearrayoutputstream.toByteArray(), hashingoutputstream.hash());
            }
            catch (IOException ioexception) {
                LOGGER.error("Failed to save file to {}", (Object)path, (Object)ioexception);
            }
        }, Util.backgroundExecutor());
    }
}

