/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.item;

import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.addons.oddities.inventory.BackpackContainer;
import org.violetmoon.quark.addons.oddities.inventory.BackpackMenu;
import org.violetmoon.quark.addons.oddities.module.BackpackModule;
import org.violetmoon.zeta.item.IZetaItem;
import org.violetmoon.zeta.item.ext.IZetaItemExtensions;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.CreativeTabManager;

public class BackpackItem
extends ArmorItem
implements IZetaItem,
IZetaItemExtensions,
MenuProvider {
    private static final String WORN_TEXTURE = "quark:textures/misc/backpack_worn.png";
    private static final String WORN_OVERLAY_TEXTURE = "quark:textures/misc/backpack_worn_overlay.png";
    @Nullable
    private final ZetaModule module;

    public BackpackItem(@Nullable ZetaModule module) {
        super(ArmorMaterials.LEATHER, ArmorItem.Type.CHESTPLATE, new Item.Properties().stacksTo(1).durability(0).rarity(Rarity.RARE).attributes(BackpackItem.createAttributes()));
        this.module = module;
        if (module == null) {
            return;
        }
        module.zeta().registry.registerItem(this.getItem(), "backpack");
        CreativeTabManager.addToCreativeTabNextTo((ResourceKey)CreativeModeTabs.TOOLS_AND_UTILITIES, (ItemLike)this.getItem(), (ItemLike)Items.SADDLE, (boolean)true);
    }

    public ZetaModule getModule() {
        return this.module;
    }

    public IZetaItem setCondition(BooleanSupplier condition) {
        return this;
    }

    public boolean doesConditionApply() {
        return true;
    }

    public static boolean doesBackpackHaveItems(ItemStack stack) {
        if (!stack.has(DataComponents.CONTAINER) && stack.is(BackpackModule.backpack)) {
            return false;
        }
        BackpackContainer backpackInv = new BackpackContainer(stack);
        for (int i = 0; i < backpackInv.getContainerSize(); ++i) {
            if (backpackInv.getItem(i).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean canEquipZeta(ItemStack stack, EquipmentSlot armorType, LivingEntity entity) {
        return armorType == EquipmentSlot.CHEST;
    }

    public boolean isBookEnchantableZeta(ItemStack stack, ItemStack book) {
        return false;
    }

    public int getEnchantmentValueZeta(ItemStack stack) {
        return 0;
    }

    public <T extends LivingEntity> int damageItemZeta(ItemStack stack, int amount, T entity, Consumer<Item> onBroken) {
        return 0;
    }

    public void inventoryTick(@NotNull ItemStack stack, Level worldIn, @NotNull Entity entityIn, int itemSlot, boolean isSelected) {
        if (worldIn.isClientSide) {
            return;
        }
        HolderLookup.RegistryLookup enchantmentLookup = worldIn.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        Holder.Reference bindingCurse = enchantmentLookup.getOrThrow(Enchantments.BINDING_CURSE);
        boolean hasItems = !BackpackModule.superOpMode && BackpackItem.doesBackpackHaveItems(stack);
        ItemEnchantments.Mutable enchants = new ItemEnchantments.Mutable((ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY));
        boolean isCursed = enchants.getLevel((Holder)bindingCurse) == 1;
        boolean changedEnchants = false;
        if (hasItems) {
            if (BackpackModule.isEntityWearingBackpack(entityIn, stack)) {
                if (!isCursed) {
                    enchants.set((Holder)bindingCurse, 1);
                    changedEnchants = true;
                }
                if (BackpackModule.itemsInBackpackTick) {
                    Optional<IItemHandler> handlerOpt = Optional.ofNullable((IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM, null));
                    IItemHandler handler = handlerOpt.orElse((IItemHandler)new ItemStackHandler());
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        ItemStack inStack = handler.getStackInSlot(i);
                        if (inStack.isEmpty()) continue;
                        inStack.getItem().inventoryTick(inStack, worldIn, entityIn, i, false);
                    }
                }
            } else {
                ItemStack copy = stack.copy();
                stack.setCount(0);
                entityIn.spawnAtLocation(copy, 0.0f);
            }
        } else if (isCursed) {
            enchants.removeIf(e -> e.is(bindingCurse.key()));
            changedEnchants = true;
        }
        if (changedEnchants) {
            stack.set(DataComponents.ENCHANTMENTS, (Object)enchants.toImmutable());
        }
    }

    public boolean onEntityItemUpdateZeta(ItemStack stack, ItemEntity entityItem) {
        if (BackpackModule.superOpMode || entityItem.level().isClientSide) {
            return false;
        }
        Optional<IItemHandler> handlerOpt = Optional.ofNullable((IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM, null));
        if (handlerOpt.isEmpty()) {
            return false;
        }
        IItemHandler handler = handlerOpt.orElse((IItemHandler)new ItemStackHandler());
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stackAt = handler.getStackInSlot(i);
            if (stackAt.isEmpty()) continue;
            ItemStack copy = stackAt.copy();
            Containers.dropItemStack((Level)entityItem.level(), (double)entityItem.getX(), (double)entityItem.getY(), (double)entityItem.getZ(), (ItemStack)copy);
        }
        ItemEnchantments enchantments = Optional.ofNullable((ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS)).orElse(ItemEnchantments.EMPTY);
        Holder.Reference binding_curse = entityItem.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.BINDING_CURSE);
        ItemEnchantments.Mutable replaceEnch = new ItemEnchantments.Mutable(enchantments);
        if (replaceEnch.keySet().contains(binding_curse)) {
            replaceEnch.set((Holder)binding_curse, 0);
            stack.set(DataComponents.ENCHANTMENTS, (Object)replaceEnch.toImmutable());
        }
        stack.remove(DataComponents.CONTAINER);
        return false;
    }

    public static ItemAttributeModifiers createAttributes() {
        return ItemAttributeModifiers.builder().build();
    }

    public boolean isFoil(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return false;
    }

    public AbstractContainerMenu createMenu(int id, @NotNull Inventory inv, @NotNull Player player) {
        return new BackpackMenu(id, player);
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)this.getDescriptionId());
    }
}

