/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.datagen;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.violetmoon.quark.datagen.QuarkBlockLootTableProvider;
import org.violetmoon.quark.datagen.QuarkEntityLootTableProvider;
import org.violetmoon.quark.datagen.QuarkRecipeProvider;

@EventBusSubscriber(modid="quark", bus=EventBusSubscriber.Bus.MOD)
public class QuarkDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent gatherDataEvent) {
        System.out.println("GENERATING QUARK DATA. PLEASE HOLD");
        DataGenerator generator = gatherDataEvent.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = gatherDataEvent.getExistingFileHelper();
        CompletableFuture holderLookupProvider = gatherDataEvent.getLookupProvider();
        if (gatherDataEvent.includeServer()) {
            System.out.println("It does server!");
        }
        if (gatherDataEvent.includeClient()) {
            System.out.println("It does client!");
        }
        generator.addProvider(gatherDataEvent.includeServer(), (DataProvider)new QuarkRecipeProvider(packOutput, holderLookupProvider));
        generator.addProvider(gatherDataEvent.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(QuarkBlockLootTableProvider::new, LootContextParamSets.BLOCK), new LootTableProvider.SubProviderEntry(QuarkEntityLootTableProvider::new, LootContextParamSets.ENTITY)), holderLookupProvider));
        System.out.println("QUARK DATA GENERATED. YIPPEE");
    }
}

