/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tools.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.content.tools.module.TorchArrowModule;

public class TorchArrow
extends AbstractArrow {
    public TorchArrow(EntityType<TorchArrow> type, Level level) {
        super(type, level);
    }

    public TorchArrow(Level level, LivingEntity owner, ItemStack pickupStack, @Nullable ItemStack weapon) {
        super(TorchArrowModule.torchArrowType, owner, level, pickupStack, weapon);
    }

    public TorchArrow(Level level, double x, double y, double z, ItemStack pickupStack, @Nullable ItemStack weapon) {
        super(TorchArrowModule.torchArrowType, x, y, z, level, pickupStack, weapon);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
    }

    public void tick() {
        super.tick();
        if (!this.inGround && this.level().isClientSide && this.tickCount > 2) {
            Vec3 motion = this.getDeltaMovement();
            double rs = 0.03;
            double ms = 0.08;
            double sprd = 0.1;
            int parts = 6;
            for (int i = 0; i < parts; ++i) {
                double px = this.getX() - motion.x * (double)((float)i / (float)parts) + (Math.random() - 0.5) * sprd;
                double py = this.getY() - motion.y * (double)((float)i / (float)parts) + (Math.random() - 0.5) * sprd;
                double pz = this.getZ() - motion.z * (double)((float)i / (float)parts) + (Math.random() - 0.5) * sprd;
                double mx = (Math.random() - 0.5) * rs - motion.x * ms;
                double my = (Math.random() - 0.5) * rs - motion.y * ms;
                double mz = (Math.random() - 0.5) * rs - motion.z * ms;
                this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, px, py, pz, mx, my, mz);
            }
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        if (this.level().isClientSide) {
            return;
        }
        BlockPos pos = result.getBlockPos();
        Direction direction = result.getDirection();
        BlockPos finalPos = pos.relative(direction);
        BlockState state = this.level().getBlockState(finalPos);
        if ((state.isAir() || state.canBeReplaced()) && direction != Direction.DOWN) {
            BlockState setState;
            BlockState blockState = setState = direction == Direction.UP ? Blocks.TORCH.defaultBlockState() : (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue((Property)WallTorchBlock.FACING, (Comparable)direction);
            if (setState.canSurvive((LevelReader)this.level(), finalPos)) {
                this.level().setBlock(finalPos, setState, 2);
                this.playSound(setState.getSoundType().getPlaceSound());
                this.discard();
                return;
            }
        }
        super.onHitBlock(result);
    }

    protected void onHitEntity(EntityHitResult result) {
        this.igniteForSeconds(1.0f);
        super.onHitEntity(result);
        this.igniteForSeconds(0.0f);
    }

    @NotNull
    protected ItemStack getPickupItem() {
        return new ItemStack((ItemLike)(TorchArrowModule.extinguishOnMiss ? Items.ARROW : TorchArrowModule.torch_arrow));
    }

    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)(TorchArrowModule.extinguishOnMiss ? Items.ARROW : TorchArrowModule.torch_arrow));
    }
}

