/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.client.tooltip;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.TippedArrowItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.client.handler.ClientUtil;
import org.violetmoon.quark.catnip.animation.AnimationTickHolder;
import org.violetmoon.quark.content.client.hax.PseudoAccessorItemStack;
import org.violetmoon.quark.content.client.module.ImprovedTooltipsModule;
import org.violetmoon.quark.content.client.resources.AttributeDisplayType;
import org.violetmoon.quark.content.client.resources.AttributeIconEntry;
import org.violetmoon.quark.content.client.resources.AttributeSlot;
import org.violetmoon.zeta.client.event.play.ZGatherTooltipComponents;

public class AttributeTooltips {
    public static final ResourceLocation TEXTURE_UPGRADE = Quark.asResource("textures/attribute/upgrade.png");
    public static final ResourceLocation TEXTURE_DOWNGRADE = Quark.asResource("textures/attribute/downgrade.png");
    private static final Map<ResourceLocation, AttributeIconEntry> attributes = new HashMap<ResourceLocation, AttributeIconEntry>();

    public static void receiveAttributes(Map<String, AttributeIconEntry> map) {
        attributes.clear();
        for (Map.Entry<String, AttributeIconEntry> entry : map.entrySet()) {
            attributes.put(ResourceLocation.parse((String)entry.getKey()), entry.getValue());
        }
    }

    @Nullable
    private static AttributeIconEntry getIconForAttribute(Attribute attribute) {
        ResourceLocation loc = BuiltInRegistries.ATTRIBUTE.getKey((Object)attribute);
        if (loc != null) {
            return attributes.get(loc);
        }
        return null;
    }

    private static MutableComponent format(Attribute attribute, double value, AttributeDisplayType displayType) {
        switch (displayType) {
            case DIFFERENCE: {
                return Component.literal((String)((value > 0.0 ? "+" : "") + ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(value).formatted(value < 0.0 ? ChatFormatting.RED : ChatFormatting.WHITE)));
            }
            case PERCENTAGE: {
                return Component.literal((String)((value > 0.0 ? "+" : "") + ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(value * 100.0 + "%").formatted(value < 0.0 ? ChatFormatting.RED : ChatFormatting.WHITE)));
            }
            case MULTIPLIER: {
                AttributeSupplier supplier = DefaultAttributes.getSupplier((EntityType)EntityType.PLAYER);
                double scaledValue = value / supplier.getBaseValue(Holder.direct((Object)attribute));
                return Component.literal((String)(ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(scaledValue) + "x")).withStyle(scaledValue < 1.0 ? ChatFormatting.RED : ChatFormatting.WHITE);
            }
        }
        return Component.literal((String)ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(value)).withStyle(value < 0.0 ? ChatFormatting.RED : ChatFormatting.WHITE);
    }

    public static void makeTooltip(ZGatherTooltipComponents event) {
        ItemStack stack = event.getItemStack();
        if (!Screen.hasShiftDown()) {
            List tooltipRaw = event.getTooltipElements();
            HashMap attributeTooltips = Maps.newHashMap();
            boolean onlyInvalid = true;
            Multimap<Attribute, AttributeModifier> baseCheck = null;
            boolean allAreSame = true;
            for (AttributeSlot slot : AttributeSlot.values()) {
                if (!AttributeTooltips.canShowAttributes(stack, slot)) continue;
                Multimap<Attribute, AttributeModifier> slotAttributes = AttributeTooltips.getModifiers(stack, slot);
                if (baseCheck == null) {
                    baseCheck = slotAttributes;
                } else if (slot.hasCanonicalSlot() && allAreSame && !slotAttributes.equals(baseCheck)) {
                    allAreSame = false;
                }
                if (!slotAttributes.isEmpty() && !slot.hasCanonicalSlot()) {
                    allAreSame = false;
                }
                onlyInvalid = AttributeTooltips.extractAttributeValues(stack, attributeTooltips, onlyInvalid, slot, slotAttributes);
            }
            AttributeSlot primarySlot = AttributeTooltips.getPrimarySlot(stack);
            int i = 1;
            for (AttributeSlot slot : AttributeSlot.values()) {
                if (!attributeTooltips.containsKey((Object)slot)) continue;
                int tooltipSlot = slot == primarySlot ? 1 : i;
                tooltipRaw.add(tooltipSlot, Either.right((Object)new AttributeComponent(stack, slot)));
                ++i;
                if (allAreSame) break;
            }
        }
    }

    private static Multimap<Attribute, AttributeModifier> getModifiersOnEquipped(Player player, ItemStack stack, Multimap<Attribute, AttributeModifier> attributes, AttributeSlot slot) {
        ItemStack equipped;
        if (ImprovedTooltipsModule.showUpgradeStatus && slot.hasCanonicalSlot() && !(equipped = player.getItemBySlot(slot.getCanonicalSlot())).equals(stack) && !equipped.isEmpty()) {
            equipped.getTooltipLines(Item.TooltipContext.of((Level)player.level()), player, (TooltipFlag)TooltipFlag.Default.NORMAL);
            return AttributeTooltips.getModifiers(equipped, slot);
        }
        return ImmutableMultimap.of();
    }

    private static Multimap<Attribute, AttributeModifier> getModifiers(ItemStack stack, AttributeSlot slot) {
        if (!Quark.ZETA.isProduction && !(stack instanceof PseudoAccessorItemStack)) {
            return ImmutableMultimap.of();
        }
        Map<AttributeSlot, Multimap<Attribute, AttributeModifier>> capturedModifiers = ((PseudoAccessorItemStack)stack).quark$getCapturedAttributes();
        if (capturedModifiers.containsKey((Object)slot)) {
            Multimap<Attribute, AttributeModifier> map = capturedModifiers.get((Object)slot);
            if (slot == AttributeSlot.MAINHAND && !map.containsKey((Object)Attributes.ATTACK_SPEED) && map.containsKey((Object)Attributes.ATTACK_DAMAGE)) {
                map.put((Object)((Attribute)Attributes.ATTACK_SPEED.value()), (Object)new AttributeModifier(Quark.asResource("ign_id"), 0.0, AttributeModifier.Operation.ADD_VALUE));
            }
            return map;
        }
        return ImmutableMultimap.of();
    }

    private static boolean extractAttributeValues(ItemStack stack, Map<AttributeSlot, MutableComponent> attributeTooltips, boolean onlyInvalid, AttributeSlot slot, Multimap<Attribute, AttributeModifier> slotAttributes) {
        boolean anyInvalid = false;
        for (Attribute attr : slotAttributes.keySet()) {
            AttributeIconEntry entry = AttributeTooltips.getIconForAttribute(attr);
            if (entry != null) {
                onlyInvalid = false;
                Minecraft mc = Minecraft.getInstance();
                double attributeValue = AttributeTooltips.getAttribute((Player)mc.player, slot, stack, slotAttributes, attr);
                if (attributeValue == 0.0) continue;
                if (!attributeTooltips.containsKey((Object)slot)) {
                    attributeTooltips.put(slot, Component.literal((String)""));
                }
                attributeTooltips.get((Object)slot).append(AttributeTooltips.format(attr, attributeValue, entry.displayTypes().get((Object)slot)).getString()).append("/");
                continue;
            }
            if (anyInvalid) continue;
            anyInvalid = true;
            if (!attributeTooltips.containsKey((Object)slot)) {
                attributeTooltips.put(slot, Component.literal((String)""));
            }
            attributeTooltips.get((Object)slot).append("[+]");
        }
        return onlyInvalid;
    }

    private static int renderAttribute(GuiGraphics guiGraphics, Attribute attribute, AttributeSlot slot, int x, int y, ItemStack stack, Multimap<Attribute, AttributeModifier> slotAttributes, Minecraft mc, boolean forceRenderIfZero, Multimap<Attribute, AttributeModifier> equippedSlotAttributes, @Nullable Set<Attribute> equippedAttrsToRender) {
        AttributeIconEntry entry = AttributeTooltips.getIconForAttribute(attribute);
        if (entry != null) {
            double value;
            if (equippedAttrsToRender != null) {
                equippedAttrsToRender.remove(attribute);
            }
            if ((value = AttributeTooltips.getAttribute((Player)mc.player, slot, stack, slotAttributes, attribute)) != 0.0 || forceRenderIfZero) {
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                guiGraphics.blit(entry.texture(), x, y, 0.0f, 0.0f, 9, 9, 9, 9);
                MutableComponent valueStr = AttributeTooltips.format(attribute, value, entry.displayTypes().get((Object)slot));
                if (ImprovedTooltipsModule.showUpgradeStatus && slot.hasCanonicalSlot()) {
                    ItemStack equipped;
                    AttributeIconEntry.CompareType compareType = entry.comparison();
                    EquipmentSlot equipSlot = slot.getCanonicalSlot();
                    if (!(mc.player == null || (equipped = mc.player.getItemBySlot(equipSlot)).equals(stack) || equipped.isEmpty() || equippedSlotAttributes.isEmpty())) {
                        double otherValue = AttributeTooltips.getAttribute((Player)mc.player, slot, equipped, equippedSlotAttributes, attribute);
                        ChatFormatting color = compareType.getColor(value, otherValue);
                        if (color != ChatFormatting.WHITE) {
                            int xp = x - 2;
                            int yp = y - 2;
                            if (ImprovedTooltipsModule.animateUpDownArrows && (float)AnimationTickHolder.getTicks() + Minecraft.getInstance().getTimer().getGameTimeDeltaTicks() % 20.0f < 10.0f) {
                                ++yp;
                            }
                            guiGraphics.blit(color == ChatFormatting.RED ? TEXTURE_DOWNGRADE : TEXTURE_UPGRADE, xp, yp, 0.0f, 0.0f, 13, 13, 13, 13);
                        }
                        valueStr = valueStr.withStyle(color);
                    }
                }
                guiGraphics.drawString(mc.font, (Component)valueStr, x + 12, y + 1, -1);
                x += mc.font.width((FormattedText)valueStr) + 20;
            }
        }
        return x;
    }

    private static AttributeSlot getPrimarySlot(ItemStack stack) {
        if (stack.getItem() instanceof PotionItem || stack.getItem() instanceof TippedArrowItem) {
            return AttributeSlot.POTION;
        }
        return AttributeSlot.fromCanonicalSlot(stack.getEquipmentSlot());
    }

    private static boolean canShowAttributes(ItemStack stack, AttributeSlot slot) {
        if (stack.isEmpty()) {
            return false;
        }
        if (slot == AttributeSlot.POTION) {
            return stack.has(DataComponents.HIDE_ADDITIONAL_TOOLTIP);
        }
        return stack.has(DataComponents.HIDE_TOOLTIP);
    }

    private static double getAttribute(Player player, AttributeSlot slot, ItemStack stack, Multimap<Attribute, AttributeModifier> map, Attribute key) {
        AttributeInstance attribute;
        AttributeInstance attribute2;
        if (player == null) {
            return 0.0;
        }
        Collection collection = map.get((Object)key);
        if (collection.isEmpty()) {
            return 0.0;
        }
        double value = 0.0;
        AttributeIconEntry entry = AttributeTooltips.getIconForAttribute(key);
        if (entry == null) {
            return 0.0;
        }
        AttributeDisplayType displayType = entry.displayTypes().get((Object)slot);
        if (!(displayType == AttributeDisplayType.PERCENTAGE || slot == AttributeSlot.POTION && key.equals(Attributes.ATTACK_DAMAGE) || (attribute2 = player.getAttribute(Holder.direct((Object)key))) == null)) {
            value = attribute2.getBaseValue();
        }
        for (AttributeModifier modifier : collection) {
            if (modifier.operation() != AttributeModifier.Operation.ADD_VALUE) continue;
            value += modifier.amount();
        }
        double rawValue = value;
        for (AttributeModifier modifier : collection) {
            if (modifier.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_BASE) continue;
            value += rawValue * modifier.amount();
        }
        for (AttributeModifier modifier : collection) {
            if (modifier.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL) continue;
            value += value * modifier.amount();
        }
        if (key.equals(Attributes.ATTACK_KNOCKBACK) && slot == AttributeSlot.MAINHAND) {
            value += (double)Quark.ZETA.itemExtensions.get(stack).getEnchantmentLevelZeta(stack, player.level().registryAccess().holderOrThrow(Enchantments.KNOCKBACK));
        }
        if (!(displayType != AttributeDisplayType.DIFFERENCE || slot == AttributeSlot.POTION && key.equals(Attributes.ATTACK_DAMAGE) || (attribute = player.getAttribute(Holder.direct((Object)key))) == null)) {
            value -= attribute.getBaseValue();
        }
        return value;
    }

    public record AttributeComponent(ItemStack stack, AttributeSlot slot) implements ClientTooltipComponent,
    TooltipComponent
    {
        public void renderImage(@NotNull Font font, int tooltipX, int tooltipY, @NotNull GuiGraphics guiGraphics) {
            PoseStack pose = guiGraphics.pose();
            if (!Screen.hasShiftDown()) {
                pose.pushPose();
                pose.translate(0.0f, 0.0f, 500.0f);
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft mc = Minecraft.getInstance();
                int y = tooltipY - 1;
                AttributeSlot primarySlot = AttributeTooltips.getPrimarySlot(this.stack);
                boolean showSlots = false;
                int x = tooltipX;
                if (AttributeTooltips.canShowAttributes(this.stack, this.slot)) {
                    Multimap<Attribute, AttributeModifier> slotAttributes = AttributeTooltips.getModifiers(this.stack, this.slot);
                    Multimap<Attribute, AttributeModifier> presentOnEquipped = AttributeTooltips.getModifiersOnEquipped((Player)mc.player, this.stack, slotAttributes, this.slot);
                    LinkedHashSet<Attribute> equippedAttrsToRender = new LinkedHashSet<Attribute>(presentOnEquipped.keySet());
                    for (Attribute attr : slotAttributes.keySet()) {
                        if (AttributeTooltips.getIconForAttribute(attr) == null || this.slot == primarySlot) continue;
                        showSlots = true;
                        break;
                    }
                    boolean anyToRender = false;
                    for (Attribute attr : slotAttributes.keySet()) {
                        double value = AttributeTooltips.getAttribute((Player)mc.player, this.slot, this.stack, slotAttributes, attr);
                        if (value == 0.0) continue;
                        anyToRender = true;
                        break;
                    }
                    if (anyToRender) {
                        if (showSlots) {
                            RenderSystem.setShader(GameRenderer::getPositionTexShader);
                            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            guiGraphics.blit(ClientUtil.GENERAL_ICONS, x, y, (float)(193 + this.slot.ordinal() * 9), 35.0f, 9, 9, 256, 256);
                            x += 20;
                        }
                        for (Attribute key : slotAttributes.keySet()) {
                            x = AttributeTooltips.renderAttribute(guiGraphics, key, this.slot, x, y, this.stack, slotAttributes, mc, false, presentOnEquipped, equippedAttrsToRender);
                        }
                        for (Attribute key : equippedAttrsToRender) {
                            x = AttributeTooltips.renderAttribute(guiGraphics, key, this.slot, x, y, this.stack, slotAttributes, mc, true, presentOnEquipped, null);
                        }
                        for (Attribute key : slotAttributes.keys()) {
                            if (AttributeTooltips.getIconForAttribute(key) != null) continue;
                            guiGraphics.drawString(font, "[+]", x + 1, y + 1, 0xFFFF55, true);
                            break;
                        }
                    }
                }
                pose.popPose();
            }
        }

        public int getHeight() {
            return 10;
        }

        public int getWidth(@NotNull Font font) {
            int width = 0;
            if (AttributeTooltips.canShowAttributes(this.stack, this.slot)) {
                Minecraft mc = Minecraft.getInstance();
                Multimap<Attribute, AttributeModifier> slotAttributes = AttributeTooltips.getModifiers(this.stack, this.slot);
                Multimap<Attribute, AttributeModifier> presentOnEquipped = AttributeTooltips.getModifiersOnEquipped((Player)mc.player, this.stack, slotAttributes, this.slot);
                LinkedHashSet equippedAttrsToRender = new LinkedHashSet(presentOnEquipped.keySet());
                AttributeSlot primarySlot = AttributeTooltips.getPrimarySlot(this.stack);
                boolean showSlots = false;
                for (Attribute attr : slotAttributes.keySet()) {
                    if (AttributeTooltips.getIconForAttribute(attr) == null || this.slot == primarySlot) continue;
                    showSlots = true;
                    break;
                }
                boolean anyToRender = false;
                for (Attribute attr : slotAttributes.keySet()) {
                    double value = AttributeTooltips.getAttribute((Player)mc.player, this.slot, this.stack, slotAttributes, attr);
                    if (value == 0.0) continue;
                    anyToRender = true;
                    break;
                }
                if (anyToRender) {
                    MutableComponent valueStr;
                    double value;
                    if (showSlots) {
                        width += 20;
                    }
                    for (Attribute key : slotAttributes.keySet()) {
                        AttributeIconEntry icons = AttributeTooltips.getIconForAttribute(key);
                        if (icons == null) continue;
                        equippedAttrsToRender.remove(key);
                        value = AttributeTooltips.getAttribute((Player)mc.player, this.slot, this.stack, slotAttributes, key);
                        if (value == 0.0) continue;
                        valueStr = AttributeTooltips.format(key, value, icons.displayTypes().get((Object)this.slot));
                        width += font.width((FormattedText)valueStr) + 20;
                    }
                    for (Attribute key : equippedAttrsToRender) {
                        AttributeIconEntry icons = AttributeTooltips.getIconForAttribute(key);
                        if (icons == null) continue;
                        value = AttributeTooltips.getAttribute((Player)mc.player, this.slot, this.stack, slotAttributes, key);
                        valueStr = AttributeTooltips.format(key, value, icons.displayTypes().get((Object)this.slot));
                        width += font.width((FormattedText)valueStr) + 20;
                    }
                    for (Attribute key : slotAttributes.keys()) {
                        if (AttributeTooltips.getIconForAttribute(key) != null) continue;
                        width += font.width("[+]") + 8;
                        break;
                    }
                }
            }
            return width - 8;
        }
    }
}

