/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.world.undergroundstyle.base;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import org.violetmoon.quark.content.world.undergroundstyle.base.UndergroundStyleConfig;
import org.violetmoon.zeta.config.type.ClusterSizeConfig;
import org.violetmoon.zeta.world.generator.multichunk.ClusterBasedGenerator;

public class UndergroundStyleGenerator
extends ClusterBasedGenerator {
    public final UndergroundStyleConfig info;

    public UndergroundStyleGenerator(UndergroundStyleConfig info, String name) {
        super(info.dimensions, (ClusterSizeConfig)info, (long)name.hashCode());
        this.info = info;
    }

    public int getFeatureRadius() {
        return this.info.horizontalSize + this.info.horizontalVariation;
    }

    public BlockPos[] getSourcesInChunk(WorldGenRegion world, Random random, ChunkGenerator generator, BlockPos chunkCorner) {
        int z;
        int y;
        int x;
        BlockPos pos;
        if (this.info.rarity > 0 && random.nextInt(this.info.rarity) == 0 && this.info.biomes.canSpawn(this.getBiome((LevelAccessor)world, pos = new BlockPos(x = chunkCorner.getX() + random.nextInt(16), y = random.nextInt(this.info.minYLevel, this.info.maxYLevel), z = chunkCorner.getZ() + random.nextInt(16)), true)) && world.getHeight(Heightmap.Types.WORLD_SURFACE_WG, x, z) >= y) {
            return new BlockPos[]{pos};
        }
        return new BlockPos[0];
    }

    public ClusterBasedGenerator.IGenerationContext createContext(BlockPos src, ChunkGenerator generator, Random random, BlockPos chunkCorner, WorldGenRegion world) {
        return new Context(world, src, generator, random, this.info);
    }

    public String toString() {
        return "UndergroundBiomeGenerator[" + String.valueOf(this.info.style) + "]";
    }

    public static class Context
    implements ClusterBasedGenerator.IGenerationContext {
        public final WorldGenRegion world;
        public final BlockPos source;
        public final ChunkGenerator generator;
        public final Random random;
        public final UndergroundStyleConfig info;

        public Context(WorldGenRegion world, BlockPos source, ChunkGenerator generator, Random random, UndergroundStyleConfig info) {
            this.world = world;
            this.source = source;
            this.generator = generator;
            this.random = random;
            this.info = info;
        }

        public boolean canPlaceAt(BlockPos pos) {
            return this.world.getHeight(Heightmap.Types.WORLD_SURFACE_WG, pos.getX(), pos.getZ()) > pos.getY();
        }

        public void consume(BlockPos pos) {
            this.info.style.fill(this, pos);
        }
    }
}

