/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.violetmoon.quark.addons.oddities.inventory.BackpackMenu;
import org.violetmoon.quark.addons.oddities.module.BackpackModule;
import org.violetmoon.quark.api.IQuarkButtonAllowed;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.network.message.oddities.HandleBackpackMessage;

public class BackpackInventoryScreen
extends InventoryScreen
implements IQuarkButtonAllowed {
    private static final ResourceLocation BACKPACK_INVENTORY_BACKGROUND = Quark.asResource("textures/misc/backpack_gui.png");
    private final Player player;
    private final Map<Button, Integer> buttonYs = new HashMap<Button, Integer>();
    private boolean closeHack = false;
    private static InventoryMenu oldContainer;

    public BackpackInventoryScreen(InventoryMenu backpack, Inventory inventory, Component component) {
        super(BackpackInventoryScreen.setBackpackContainer(inventory.player, backpack));
        this.player = inventory.player;
        BackpackInventoryScreen.setBackpackContainer(this.player, oldContainer);
    }

    public static Player setBackpackContainer(Player entity, InventoryMenu container) {
        oldContainer = entity.inventoryMenu;
        entity.inventoryMenu = container;
        return entity;
    }

    public void init() {
        this.imageHeight = 224;
        super.init();
        this.buttonYs.clear();
        for (Renderable renderable : this.renderables) {
            Button b;
            if (!(renderable instanceof Button) || !(b = (Button)renderable).getClass().getName().contains("GuiButtonInventoryBook") || this.buttonYs.containsKey(b)) continue;
            b.setY(b.getY() - 29);
            this.buttonYs.put(b, b.getY());
        }
    }

    public void containerTick() {
        this.buttonYs.forEach(AbstractWidget::setY);
        super.containerTick();
        if (!BackpackModule.isEntityWearingBackpack((Entity)this.player)) {
            ItemStack curr = this.player.containerMenu.getCarried();
            BackpackMenu.saveCraftingInventory(this.player);
            this.closeHack = true;
            PacketDistributor.sendToServer((CustomPacketPayload)new HandleBackpackMessage(false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.minecraft.setScreen((Screen)new InventoryScreen(this.player));
            this.player.inventoryMenu.setCarried(curr);
        }
    }

    public void removed() {
        if (this.closeHack) {
            this.closeHack = false;
            return;
        }
        super.removed();
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int leftPos = this.leftPos;
        int topPos = this.topPos;
        guiGraphics.blit(BACKPACK_INVENTORY_BACKGROUND, leftPos, topPos, 0, 0, this.imageWidth, this.imageHeight);
        BackpackInventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)guiGraphics, (int)(leftPos + 51), (int)(topPos + 75), (int)(leftPos + 51 - mouseX), (int)(topPos + 75 - 50 - mouseY), (int)30, (float)0.0f, (float)mouseX, (float)mouseY, (LivingEntity)this.minecraft.player);
        this.moveCharmsButtons();
    }

    private void moveCharmsButtons() {
        for (Renderable renderable : this.renderables) {
            ImageButton img;
            if (!(renderable instanceof ImageButton) || (img = (ImageButton)renderable).getY() != this.height / 2 - 22) continue;
            img.setPosition(img.getX(), img.getY() - 29);
        }
    }
}

