/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.integration.jei;

import java.util.List;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryExtension;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.violetmoon.quark.addons.oddities.util.Influence;
import org.violetmoon.quark.base.components.QuarkDataComponents;
import org.violetmoon.quark.content.experimental.module.EnchantmentsBegoneModule;
import org.violetmoon.quark.content.tools.base.RuneColor;
import org.violetmoon.quark.content.tools.module.ColorRunesModule;

public class InfluenceEntry
implements IRecipeCategoryExtension {
    private final ItemStack candleStack;
    private final ItemStack boost;
    private final ItemStack dampen;
    private final List<ItemStack> associatedBooks;

    public InfluenceEntry(Block candle, Influence influence) {
        this.candleStack = new ItemStack((ItemLike)candle);
        this.boost = InfluenceEntry.getEnchantedBook(influence.boost(), RuneColor.GREEN, ChatFormatting.GREEN, "quark.jei.boost_influence");
        this.dampen = InfluenceEntry.getEnchantedBook(influence.dampen(), RuneColor.RED, ChatFormatting.RED, "quark.jei.dampen_influence");
        this.associatedBooks = InfluenceEntry.buildAssociatedBooks(influence);
    }

    public ItemStack getBoostBook() {
        return this.boost;
    }

    public ItemStack getDampenBook() {
        return this.dampen;
    }

    public ItemStack getCandleStack() {
        return this.candleStack;
    }

    public List<ItemStack> getAssociatedBooks() {
        return this.associatedBooks;
    }

    private static ItemStack getEnchantedBook(List<Holder<Enchantment>> enchantments, RuneColor runeColor, ChatFormatting chatColor, String locKey) {
        ItemStack stack = ItemStack.EMPTY;
        for (Holder<Enchantment> enchantment : enchantments) {
            if (enchantment.value() == null || EnchantmentsBegoneModule.shouldBegone(enchantment)) continue;
            if (stack.isEmpty()) {
                stack = ColorRunesModule.withRune(new ItemStack((ItemLike)Items.ENCHANTED_BOOK), runeColor);
                stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)locKey).withStyle(chatColor));
                stack.set(QuarkDataComponents.TABLE_ONLY_ENCHANTS, (Object)true);
            }
            stack = EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance(enchantment, ((Enchantment)enchantment.value()).getMaxLevel()));
        }
        return stack;
    }

    private static List<ItemStack> buildAssociatedBooks(Influence influence) {
        int i;
        NonNullList books = NonNullList.create();
        for (Holder<Enchantment> boostedEnchants : influence.boost()) {
            for (i = 0; i < ((Enchantment)boostedEnchants.value()).getMaxLevel(); ++i) {
                books.add((Object)EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance(boostedEnchants, i + 1)));
            }
        }
        for (Holder<Enchantment> dampenedEnchants : influence.dampen()) {
            for (i = 0; i < ((Enchantment)dampenedEnchants.value()).getMaxLevel(); ++i) {
                books.add((Object)EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance(dampenedEnchants, i + 1)));
            }
        }
        return books;
    }

    public boolean hasAny() {
        return !this.boost.isEmpty() || !this.dampen.isEmpty();
    }
}

