/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tools.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.components.QuarkDataComponents;
import org.violetmoon.quark.catnip.animation.AnimationTickHolder;
import org.violetmoon.quark.content.mobs.module.StonelingsModule;
import org.violetmoon.quark.content.tools.module.PathfinderMapsModule;
import org.violetmoon.quark.content.world.module.GlimmeringWealdModule;
import org.violetmoon.zeta.item.ZetaItem;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.CreativeTabManager;

public class PathfindersQuillItem
extends ZetaItem
implements CreativeTabManager.AppendsUniquely {
    private static final Direction[] DIRECTIONS = new Direction[]{Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.NORTH};
    protected static final String TAG_POS_X = "searchPosX";
    protected static final String TAG_POS_Z = "searchPosZ";
    protected static final String TAG_POS_LEG = "searchPosLeg";
    protected static final String TAG_POS_LEG_INDEX = "searchPosLegIndex";
    private static final Map<Key, InteractionResultHolder<BlockPos>> RESULTS = new ConcurrentHashMap<Key, InteractionResultHolder<BlockPos>>();
    private static final Set<Key> COMPUTING = ConcurrentHashMap.newKeySet();
    protected static final ExecutorService EXECUTORS = Executors.newCachedThreadPool();

    public PathfindersQuillItem(ZetaModule module, Item.Properties properties) {
        super("pathfinders_quill", module, properties);
        CreativeTabManager.addToCreativeTabNextTo((ResourceKey)CreativeModeTabs.TOOLS_AND_UTILITIES, (ItemLike)this, (ItemLike)Items.MAP, (boolean)false);
    }

    public PathfindersQuillItem(ZetaModule module) {
        this(module, new Item.Properties().stacksTo(1));
    }

    public static ResourceLocation getTargetBiome(ItemStack stack) {
        String str = Optional.ofNullable((String)stack.get(QuarkDataComponents.TARGET_BIOME)).orElse("");
        return str.isEmpty() ? null : ResourceLocation.parse((String)str);
    }

    public static int getOverlayColor(ItemStack stack) {
        return Optional.ofNullable((Integer)stack.get(QuarkDataComponents.BIOME_COLOR)).orElse(0xFFFFFF);
    }

    public static ItemStack forBiome(String biome, int color) {
        ItemStack stack = new ItemStack((ItemLike)PathfinderMapsModule.pathfinders_quill);
        PathfindersQuillItem.setBiome(stack, biome, color, false);
        return stack;
    }

    public static void setBiome(ItemStack stack, String biome, int color, boolean underground) {
        stack.set(QuarkDataComponents.TARGET_BIOME, (Object)biome);
        stack.set(QuarkDataComponents.BIOME_COLOR, (Object)color);
        stack.set(QuarkDataComponents.IS_UNDERGROUND, (Object)underground);
    }

    @Nullable
    public static ItemStack getActiveQuill(Player player) {
        boolean searching;
        for (ItemStack stack : player.getInventory().items) {
            if (!(stack.getItem() instanceof PathfindersQuillItem) || !(searching = Optional.ofNullable((Boolean)stack.get(QuarkDataComponents.IS_SEARCHING)).orElse(false).booleanValue())) continue;
            return stack;
        }
        for (ItemStack stack : player.getInventory().offhand) {
            if (!(stack.getItem() instanceof PathfindersQuillItem) || !(searching = Optional.ofNullable((Boolean)stack.get(QuarkDataComponents.IS_SEARCHING)).orElse(false).booleanValue())) continue;
            return stack;
        }
        for (ItemStack stack : player.getInventory().armor) {
            if (!(stack.getItem() instanceof PathfindersQuillItem) || !(searching = Optional.ofNullable((Boolean)stack.get(QuarkDataComponents.IS_SEARCHING)).orElse(false).booleanValue())) continue;
            return stack;
        }
        return null;
    }

    public boolean shouldCauseReequipAnimationZeta(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.getItem() != newStack.getItem();
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (this.getTarget(stack) == null) {
            return InteractionResultHolder.pass((Object)stack);
        }
        ItemStack active = PathfindersQuillItem.getActiveQuill(player);
        if (active != null) {
            player.displayClientMessage((Component)Component.translatable((String)"quark.misc.only_one_quill"), true);
            return InteractionResultHolder.fail((Object)stack);
        }
        Vec3 pos = player.getPosition(1.0f);
        level.playSound(null, pos.x, pos.y, pos.z, SoundEvents.BOOK_PAGE_TURN, SoundSource.PLAYERS, 0.5f, 1.0f);
        stack.set(QuarkDataComponents.IS_SEARCHING, (Object)true);
        stack.set(QuarkDataComponents.TAG_SOURCE_X, (Object)player.getBlockX());
        stack.set(QuarkDataComponents.TAG_SOURCE_Z, (Object)player.getBlockZ());
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
    }

    public ResourceLocation getTarget(ItemStack stack) {
        return PathfindersQuillItem.getTargetBiome(stack);
    }

    protected int getIterations() {
        return PathfinderMapsModule.pathfindersQuillSpeed;
    }

    protected boolean isMultiThreaded() {
        return PathfinderMapsModule.multiThreaded;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean held) {
        if (!level.isClientSide && level instanceof ServerLevel) {
            ItemStack runningStack;
            Player player;
            ServerLevel sl = (ServerLevel)level;
            if (Optional.ofNullable((Boolean)stack.get(QuarkDataComponents.IS_SEARCHING)).orElse(false).booleanValue() && entity instanceof Player && PathfindersQuillItem.getActiveQuill(player = (Player)entity) == stack && (runningStack = this.search(stack, sl, player, slot)) != stack) {
                String msg;
                if (runningStack.isEmpty()) {
                    if (PathfinderMapsModule.allowRetrying) {
                        runningStack = this.resetSearchingTags(stack);
                        msg = this.getRetryMessage();
                    } else {
                        msg = this.getFailMessage();
                    }
                } else {
                    msg = this.getSuccessMessage();
                }
                player.displayClientMessage((Component)Component.translatable((String)msg), true);
                Vec3 pos = player.getPosition(1.0f);
                level.playSound(null, pos.x, pos.y, pos.z, (Holder)SoundEvents.NOTE_BLOCK_CHIME, SoundSource.PLAYERS, 0.5f, 1.0f);
                if (player.getOffhandItem() == stack) {
                    player.setItemInHand(InteractionHand.OFF_HAND, runningStack);
                } else {
                    player.getInventory().setItem(slot, runningStack);
                }
            }
        }
    }

    protected ItemStack resetSearchingTags(ItemStack stack) {
        stack.remove(QuarkDataComponents.TAG_SOURCE_X);
        stack.remove(QuarkDataComponents.TAG_SOURCE_Z);
        stack.remove(QuarkDataComponents.IS_SEARCHING);
        stack.remove(QuarkDataComponents.TAG_POS_X);
        stack.remove(QuarkDataComponents.TAG_POS_Z);
        stack.remove(QuarkDataComponents.TAG_POS_LEG);
        stack.remove(QuarkDataComponents.TAG_POS_LEG_INDEX);
        return stack;
    }

    protected String getRetryMessage() {
        return "quark.misc.quill_retry";
    }

    protected String getSuccessMessage() {
        return "quark.misc.quill_finished";
    }

    protected String getFailMessage() {
        return "quark.misc.quill_failed";
    }

    protected ItemStack search(ItemStack stack, ServerLevel level, Player player, int slot) {
        ResourceLocation searchKey = this.getTarget(stack);
        if (searchKey == null) {
            return ItemStack.EMPTY;
        }
        InteractionResultHolder<BlockPos> result = this.isMultiThreaded() ? this.searchConcurrent(searchKey, stack, level, player) : this.searchIterative(searchKey, stack, level, player, this.getIterations());
        if (result.getResult() == InteractionResult.FAIL) {
            return ItemStack.EMPTY;
        }
        if (result.getResult() == InteractionResult.PASS) {
            return stack;
        }
        BlockPos found = (BlockPos)result.getObject();
        return this.createMap(level, found, searchKey, stack);
    }

    protected InteractionResultHolder<BlockPos> searchConcurrent(ResourceLocation searchKey, ItemStack stack, ServerLevel level, Player player) {
        int sourceX = Optional.ofNullable((Integer)stack.get(QuarkDataComponents.TAG_SOURCE_X)).orElse(0);
        int sourceZ = Optional.ofNullable((Integer)stack.get(QuarkDataComponents.TAG_SOURCE_Z)).orElse(0);
        BlockPos centerPos = new BlockPos(sourceX, 64, sourceZ);
        Key key = new Key(GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)centerPos), searchKey);
        if (COMPUTING.contains(key)) {
            return InteractionResultHolder.pass((Object)BlockPos.ZERO);
        }
        if (RESULTS.containsKey(key)) {
            InteractionResultHolder<BlockPos> ret = RESULTS.get(key);
            if (ret.getResult() == InteractionResult.PASS) {
                return InteractionResultHolder.fail((Object)BlockPos.ZERO);
            }
            return ret;
        }
        ItemStack dummy = stack.copy();
        EXECUTORS.submit(() -> {
            COMPUTING.add(key);
            RESULTS.put(key, this.searchIterative(searchKey, dummy, level, player, Integer.MAX_VALUE));
            COMPUTING.remove(key);
        });
        return InteractionResultHolder.pass((Object)BlockPos.ZERO);
    }

    protected InteractionResultHolder<BlockPos> searchIterative(ResourceLocation searchKey, ItemStack stack, ServerLevel level, Player player, int maxIter) {
        int y = player.getBlockY();
        for (int i = 0; i < maxIter; ++i) {
            int height = 64;
            BlockPos nextPos = PathfindersQuillItem.nextPos(stack);
            if (nextPos == null) {
                return InteractionResultHolder.fail((Object)BlockPos.ZERO);
            }
            int[] searchedHeights = Mth.outFromOrigin((int)y, (int)(level.getMinBuildHeight() + 1), (int)level.getMaxBuildHeight(), (int)64).toArray();
            int testX = nextPos.getX();
            int testZ = nextPos.getZ();
            int quartX = QuartPos.fromBlock((int)testX);
            int quartZ = QuartPos.fromBlock((int)testZ);
            for (int testY : searchedHeights) {
                Climate.Sampler sampler;
                int quartY = QuartPos.fromBlock((int)testY);
                ServerChunkCache cache = level.getChunkSource();
                BiomeSource source = cache.getGenerator().getBiomeSource();
                Holder holder = source.getNoiseBiome(quartX, quartY, quartZ, sampler = cache.randomState().sampler());
                if (!holder.is(searchKey)) continue;
                BlockPos mapPos = new BlockPos(testX, testY, testZ);
                return InteractionResultHolder.sidedSuccess((Object)mapPos, (boolean)level.isClientSide);
            }
        }
        return InteractionResultHolder.pass((Object)BlockPos.ZERO);
    }

    protected static BlockPos nextPos(ItemStack stack) {
        int step = 32;
        int sourceX = Optional.ofNullable((Integer)stack.get(QuarkDataComponents.TAG_SOURCE_X)).orElse(0);
        int sourceZ = Optional.ofNullable((Integer)stack.get(QuarkDataComponents.TAG_SOURCE_Z)).orElse(0);
        int x = Optional.ofNullable((Integer)stack.get(QuarkDataComponents.TAG_POS_X)).orElse(0);
        int z = Optional.ofNullable((Integer)stack.get(QuarkDataComponents.TAG_POS_Z)).orElse(0);
        int leg = Optional.ofNullable((Integer)stack.get(QuarkDataComponents.TAG_POS_LEG)).orElse(0);
        int legIndex = Optional.ofNullable((Integer)stack.get(QuarkDataComponents.TAG_POS_LEG_INDEX)).orElse(0);
        BlockPos cursor = new BlockPos(x, 0, z).relative(DIRECTIONS[(leg + 4) % 4]);
        int newX = cursor.getX();
        int newZ = cursor.getZ();
        int legSize = leg / 2 + 1;
        int maxLegs = 4 * Math.floorDiv(PathfinderMapsModule.searchRadius, 32);
        if (legIndex >= legSize) {
            if (leg > maxLegs) {
                return null;
            }
            ++leg;
            legIndex = 0;
        }
        ++legIndex;
        stack.set(QuarkDataComponents.TAG_POS_X, (Object)newX);
        stack.set(QuarkDataComponents.TAG_POS_Z, (Object)newZ);
        stack.set(QuarkDataComponents.TAG_POS_LEG, (Object)leg);
        stack.set(QuarkDataComponents.TAG_POS_LEG_INDEX, (Object)legIndex);
        int retX = sourceX + newX * 32;
        int retZ = sourceZ + newZ * 32;
        return new BlockPos(retX, 0, retZ);
    }

    public ItemStack createMap(ServerLevel level, BlockPos targetPos, ResourceLocation target, ItemStack original) {
        int color = PathfindersQuillItem.getOverlayColor(original);
        MutableComponent biomeComponent = Component.translatable((String)("biome." + target.getNamespace() + "." + target.getPath()));
        ItemStack stack = MapItem.create((Level)level, (int)targetPos.getX(), (int)targetPos.getZ(), (byte)2, (boolean)true, (boolean)true);
        MapItem.renderBiomePreviewMap((ServerLevel)level, (ItemStack)stack);
        MapItemSavedData.addTargetDecoration((ItemStack)stack, (BlockPos)targetPos, (String)"+", (Holder)MapDecorationTypes.RED_X);
        stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"item.quark.biome_map", (Object[])new Object[]{biomeComponent}));
        stack.set(QuarkDataComponents.MAP_COLOR, (Object)color);
        stack.set(QuarkDataComponents.IS_PATHFINDER, (Object)true);
        return stack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static MutableComponent getSearchingComponent() {
        MutableComponent comp = Component.translatable((String)"quark.misc.quill_searching");
        int dots = AnimationTickHolder.getTicks() / 10 % 4;
        for (int i = 0; i < dots; ++i) {
            comp.append(".");
        }
        return comp;
    }

    public List<ItemStack> appendItemsToCreativeTab() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        boolean generatedWeald = false;
        for (PathfinderMapsModule.TradeInfo trade : PathfinderMapsModule.tradeList) {
            if (trade.biome.equals((Object)GlimmeringWealdModule.BIOME_NAME)) {
                generatedWeald = true;
            }
            items.add(PathfindersQuillItem.forBiome(trade.biome.toString(), trade.color));
        }
        if (!generatedWeald && Quark.ZETA.modules.isEnabled(StonelingsModule.class) && Quark.ZETA.modules.isEnabled(GlimmeringWealdModule.class) && StonelingsModule.wealdPathfinderMaps) {
            items.add(PathfindersQuillItem.forBiome(GlimmeringWealdModule.BIOME_NAME.toString(), 3241286));
        }
        return items;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext p_339594_, List<Component> comps, TooltipFlag flags) {
        ResourceLocation biome = this.getTarget(stack);
        if (biome != null) {
            if (Optional.ofNullable((Boolean)stack.get(QuarkDataComponents.IS_SEARCHING)).orElse(false).booleanValue()) {
                comps.add((Component)PathfindersQuillItem.getSearchingComponent().withStyle(ChatFormatting.BLUE));
            }
            comps.add((Component)Component.translatable((String)("biome." + biome.getNamespace() + "." + biome.getPath())).withStyle(ChatFormatting.GRAY));
        } else {
            comps.add((Component)Component.translatable((String)"quark.misc.quill_blank").withStyle(ChatFormatting.GRAY));
        }
    }

    private record Key(GlobalPos pos, ResourceLocation structure) {
    }
}

