/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tweaks.module;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.play.entity.player.ZRightClickBlock;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.Hint;
import org.violetmoon.zeta.util.MiscUtil;

@ZetaLoadModule(category="tweaks")
public class ReplaceScaffoldingModule
extends ZetaModule {
    @Config(description="How many times the algorithm for finding out where a block would be placed is allowed to turn. If you set this to large values (> 3) it may start producing weird effects.")
    public int maxBounces = 1;
    @Hint
    Item scaffold = Items.SCAFFOLDING;

    @PlayEvent
    public void onInteract(ZRightClickBlock event) {
        Level world = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = world.getBlockState(pos);
        Player player = event.getPlayer();
        if (state.getBlock() == Blocks.SCAFFOLDING && !player.isDiscrete()) {
            BlockPos last;
            UseOnContext context;
            BlockPlaceContext bcontext;
            BlockState stateToPlace;
            BlockItem bitem;
            Block block;
            Direction dir = event.getFace();
            ItemStack stack = event.getItemStack();
            InteractionHand hand = event.getHand();
            Item item = stack.getItem();
            if (item instanceof BlockItem && (block = (bitem = (BlockItem)item).getBlock()) != Blocks.SCAFFOLDING && !(block instanceof EntityBlock) && (stateToPlace = block.getStateForPlacement(bcontext = new BlockPlaceContext(context = new UseOnContext(player, hand, new BlockHitResult(new Vec3(0.5, 1.0, 0.5), dir, last = this.getLastInLine(world, pos, dir), false))))) != null && stateToPlace.canSurvive((LevelReader)world, last)) {
                BlockState currState = world.getBlockState(last);
                world.setBlockAndUpdate(last, stateToPlace);
                BlockPos testUp = last.above();
                BlockState testUpState = world.getBlockState(testUp);
                if (testUpState.getBlock() == Blocks.SCAFFOLDING && !stateToPlace.isFaceSturdy((BlockGetter)world, last, Direction.UP)) {
                    world.setBlockAndUpdate(last, currState);
                    return;
                }
                world.playSound(player, last, stateToPlace.getSoundType().getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                    ItemStack giveStack = new ItemStack((ItemLike)Items.SCAFFOLDING);
                    if (!player.addItem(giveStack)) {
                        player.drop(giveStack, false);
                    }
                }
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.sidedSuccess((boolean)world.isClientSide));
            }
        }
    }

    private BlockPos getLastInLine(Level world, BlockPos start, Direction clickDir) {
        BlockPos result = this.getLastInLineOrNull(world, start, clickDir);
        if (result != null) {
            return result;
        }
        if (clickDir != Direction.UP && (result = this.getLastInLineOrNull(world, start, Direction.UP)) != null) {
            return result;
        }
        for (Direction horizontal : MiscUtil.HORIZONTALS) {
            if (horizontal == clickDir || (result = this.getLastInLineOrNull(world, start, horizontal)) == null) continue;
            return result;
        }
        if (clickDir != Direction.DOWN && (result = this.getLastInLineOrNull(world, start, Direction.DOWN)) != null) {
            return result;
        }
        return start;
    }

    private BlockPos getLastInLineOrNull(Level world, BlockPos start, Direction dir) {
        BlockPos last = this.getLastInLineRecursive(world, start, dir, this.maxBounces);
        if (last.equals((Object)start)) {
            return null;
        }
        return last;
    }

    private BlockPos getLastInLineRecursive(Level world, BlockPos start, Direction dir, int bouncesAllowed) {
        BlockState testState;
        BlockPos test;
        BlockPos curr = start;
        BlockState currState = world.getBlockState(start);
        Block currBlock = currState.getBlock();
        while (world.isLoaded(test = curr.relative(dir)) && (testState = world.getBlockState(test)).getBlock() == currBlock) {
            curr = test;
        }
        if (!curr.equals((Object)start) && bouncesAllowed > 0) {
            BlockPos maxDist = null;
            double maxDistVal = -1.0;
            for (Direction dir2 : Direction.values()) {
                BlockPos testDist;
                double testDistVal;
                BlockPos bounceStart;
                if (dir.getAxis() == dir2.getAxis() || world.getBlockState(bounceStart = curr.relative(dir2)).getBlock() != currBlock || !((testDistVal = (double)(testDist = this.getLastInLineRecursive(world, bounceStart, dir2, bouncesAllowed - 1)).distManhattan((Vec3i)curr)) > maxDistVal)) continue;
                maxDist = testDist;
            }
            if (maxDist != null) {
                curr = maxDist;
            }
        }
        return curr;
    }
}

