/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tools.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.handler.QuarkSounds;
import org.violetmoon.quark.content.tools.config.PickarangType;
import org.violetmoon.quark.content.tools.entity.rang.AbstractPickarang;
import org.violetmoon.quark.content.tools.module.PickarangModule;
import org.violetmoon.zeta.item.ZetaItem;
import org.violetmoon.zeta.module.ZetaModule;

public class PickarangItem
extends ZetaItem {
    public final PickarangType<?> type;

    public PickarangItem(String regname, ZetaModule module, Item.Properties properties, PickarangType<?> type) {
        super(regname, module, properties);
        this.type = type;
    }

    public boolean hurtEnemy(ItemStack stack, @NotNull LivingEntity target, @NotNull LivingEntity attacker) {
        stack.hurtAndBreak(2, attacker, EquipmentSlot.MAINHAND);
        return true;
    }

    public boolean isCorrectToolForDrops(@NotNull ItemStack stack, @NotNull BlockState blockIn) {
        return switch (this.type.harvestLevel) {
            case 0 -> {
                if (Items.WOODEN_PICKAXE.isCorrectToolForDrops(stack, blockIn) || this.type.canActAsAxe && Items.WOODEN_AXE.isCorrectToolForDrops(stack, blockIn) || this.type.canActAsShovel && Items.WOODEN_SHOVEL.isCorrectToolForDrops(stack, blockIn) || this.type.canActAsHoe && Items.WOODEN_HOE.isCorrectToolForDrops(stack, blockIn)) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (Items.STONE_PICKAXE.isCorrectToolForDrops(stack, blockIn) || this.type.canActAsAxe && Items.STONE_AXE.isCorrectToolForDrops(stack, blockIn) || this.type.canActAsShovel && Items.STONE_SHOVEL.isCorrectToolForDrops(stack, blockIn) || this.type.canActAsHoe && Items.STONE_HOE.isCorrectToolForDrops(stack, blockIn)) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (Items.IRON_PICKAXE.isCorrectToolForDrops(stack, blockIn) || this.type.canActAsAxe && Items.IRON_AXE.isCorrectToolForDrops(stack, blockIn) || this.type.canActAsShovel && Items.IRON_SHOVEL.isCorrectToolForDrops(stack, blockIn) || this.type.canActAsHoe && Items.IRON_HOE.isCorrectToolForDrops(stack, blockIn)) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (Items.DIAMOND_PICKAXE.isCorrectToolForDrops(stack, blockIn) || this.type.canActAsAxe && Items.DIAMOND_AXE.isCorrectToolForDrops(stack, blockIn) || this.type.canActAsShovel && Items.DIAMOND_SHOVEL.isCorrectToolForDrops(stack, blockIn) || this.type.canActAsHoe && Items.DIAMOND_HOE.isCorrectToolForDrops(stack, blockIn)) {
                    yield true;
                }
                yield false;
            }
            default -> Items.NETHERITE_PICKAXE.isCorrectToolForDrops(stack, blockIn) || this.type.canActAsAxe && Items.NETHERITE_AXE.isCorrectToolForDrops(stack, blockIn) || this.type.canActAsShovel && Items.NETHERITE_SHOVEL.isCorrectToolForDrops(stack, blockIn) || this.type.canActAsHoe && Items.NETHERITE_HOE.isCorrectToolForDrops(stack, blockIn);
        };
    }

    public int getMaxDamage(ItemStack stack) {
        return Math.max(this.type.durability, 0);
    }

    public boolean mineBlock(@NotNull ItemStack stack, @NotNull Level worldIn, BlockState state, @NotNull BlockPos pos, @NotNull LivingEntity entityLiving) {
        if (state.getDestroySpeed((BlockGetter)worldIn, pos) != 0.0f) {
            stack.hurtAndBreak(1, entityLiving, EquipmentSlot.MAINHAND);
        }
        return true;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, @NotNull InteractionHand handIn) {
        int cooldown;
        ItemStack itemstack = playerIn.getItemInHand(handIn);
        playerIn.setItemInHand(handIn, ItemStack.EMPTY);
        Holder.Reference enchantment = ((Registry)playerIn.level().registryAccess().registry(Registries.ENCHANTMENT).get()).getHolderOrThrow(Enchantments.EFFICIENCY);
        int eff = Quark.ZETA.itemExtensions.get(itemstack).getEnchantmentLevelZeta(itemstack, (Holder)enchantment);
        Vec3 pos = playerIn.position();
        worldIn.playSound(null, pos.x, pos.y, pos.z, QuarkSounds.ENTITY_PICKARANG_THROW, SoundSource.NEUTRAL, 0.5f + (float)eff * 0.14f, 0.4f / (worldIn.random.nextFloat() * 0.4f + 0.8f));
        if (!worldIn.isClientSide) {
            Inventory inventory = playerIn.getInventory();
            int slot = handIn == InteractionHand.OFF_HAND ? inventory.getContainerSize() - 1 : inventory.selected;
            AbstractPickarang<?> entity = this.type.makePickarang(worldIn, playerIn);
            entity.setThrowData(slot, itemstack);
            entity.shoot((Entity)playerIn, playerIn.getXRot(), playerIn.getYRot(), 0.0f, 1.5f + (float)eff * 0.325f, 0.0f);
            entity.setOwner((Entity)playerIn);
            worldIn.addFreshEntity(entity);
            if (playerIn instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)playerIn;
                PickarangModule.throwPickarangTrigger.trigger(sp);
            }
        }
        if (!playerIn.getAbilities().instabuild && this.type.cooldown > 0 && (cooldown = this.type.cooldown - eff) > 0) {
            playerIn.getCooldowns().addCooldown((Item)this, cooldown);
        }
        playerIn.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)worldIn.isClientSide);
    }

    public static ItemAttributeModifiers createAttributes(PickarangType<?> type) {
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        builder.add(Attributes.ATTACK_DAMAGE, new AttributeModifier(Quark.asResource("pickarang_attack_damage"), (double)type.attackDamage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        builder.add(Attributes.ATTACK_SPEED, new AttributeModifier(Quark.asResource("pickarang_attack_speed"), -2.8, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        return builder.build();
    }

    public float getDestroySpeed(@NotNull ItemStack stack, @NotNull BlockState state) {
        return 0.0f;
    }

    public boolean isRepairableZeta(@NotNull ItemStack stack) {
        return true;
    }

    public boolean isValidRepairItem(@NotNull ItemStack toRepair, ItemStack repair) {
        return this.type.repairMaterial != null && repair.getItem() == this.type.repairMaterial;
    }

    public int getEnchantmentValueZeta(ItemStack stack) {
        return this.getEnchantmentValue();
    }

    public int getEnchantmentValue() {
        return this.type.pickaxeEquivalent != null ? this.type.pickaxeEquivalent.getEnchantmentValue() : 0;
    }
}

