/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.automation.block.be;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.content.automation.block.ChuteBlock;
import org.violetmoon.quark.content.automation.module.ChuteModule;
import org.violetmoon.quark.content.building.module.GrateModule;
import org.violetmoon.zeta.block.be.ZetaBlockEntity;

public class ChuteBlockEntity
extends ZetaBlockEntity {
    private static final AABB CLEARANCE = new AABB(BlockPos.ZERO).deflate(0.25).move(0.0, 0.25, 0.0);
    private final IItemHandler handler = new IItemHandler(){

        public int getSlots() {
            return 1;
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return ItemStack.EMPTY;
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (!ChuteBlockEntity.this.canDropItem()) {
                return stack;
            }
            if (!simulate && ChuteBlockEntity.this.level != null && !stack.isEmpty()) {
                ItemEntity entity = new ItemEntity(ChuteBlockEntity.this.level, (double)ChuteBlockEntity.this.worldPosition.getX() + 0.5, (double)ChuteBlockEntity.this.worldPosition.getY() - 0.5, (double)ChuteBlockEntity.this.worldPosition.getZ() + 0.5, stack.copy());
                entity.setDeltaMovement(0.0, 0.0, 0.0);
                ChuteBlockEntity.this.level.addFreshEntity((Entity)entity);
            }
            return ItemStack.EMPTY;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.EMPTY;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return true;
        }
    };

    public ChuteBlockEntity(BlockPos pos, BlockState state) {
        super(ChuteModule.blockEntityType, pos, state);
    }

    private boolean canDropItem() {
        if (this.level != null && ((Boolean)this.level.getBlockState(this.worldPosition).getValue((Property)ChuteBlock.ENABLED)).booleanValue()) {
            BlockPos below = this.worldPosition.below();
            BlockState state = this.level.getBlockState(below);
            if (state.isAir()) {
                return true;
            }
            if (state.is(GrateModule.grate)) {
                return true;
            }
            VoxelShape shape = state.getCollisionShape((BlockGetter)this.level, below);
            if (shape.isEmpty()) {
                return true;
            }
            if (shape.max(Direction.Axis.Y) > 1.0) {
                return false;
            }
            for (AABB box : shape.toAabbs()) {
                if (!box.intersects(CLEARANCE)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

