/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import org.violetmoon.quark.addons.oddities.module.BackpackModule;
import org.violetmoon.quark.addons.oddities.module.CrateModule;
import org.violetmoon.quark.addons.oddities.module.MagnetsModule;
import org.violetmoon.quark.addons.oddities.module.PipesModule;
import org.violetmoon.quark.addons.oddities.module.TinyPotatoModule;
import org.violetmoon.quark.content.automation.module.ChuteModule;
import org.violetmoon.quark.content.automation.module.EnderWatcherModule;
import org.violetmoon.quark.content.automation.module.FeedingTroughModule;
import org.violetmoon.quark.content.automation.module.GravisandModule;
import org.violetmoon.quark.content.automation.module.MetalButtonsModule;
import org.violetmoon.quark.content.automation.module.ObsidianPlateModule;
import org.violetmoon.quark.content.automation.module.RedstoneRandomizerModule;
import org.violetmoon.quark.content.building.module.CompressedBlocksModule;
import org.violetmoon.quark.content.building.module.FramedGlassModule;
import org.violetmoon.quark.content.building.module.NetherBrickFenceGateModule;
import org.violetmoon.quark.content.building.module.VariantChestsModule;
import org.violetmoon.quark.content.experimental.module.VariantSelectorModule;
import org.violetmoon.quark.content.mobs.module.StonelingsModule;
import org.violetmoon.quark.content.tools.module.AbacusModule;
import org.violetmoon.quark.content.tools.module.ColorRunesModule;
import org.violetmoon.quark.content.tools.module.PickarangModule;
import org.violetmoon.quark.content.tools.module.SeedPouchModule;
import org.violetmoon.quark.content.tools.module.TorchArrowModule;
import org.violetmoon.quark.content.tools.module.TrowelModule;
import org.violetmoon.quark.content.tweaks.module.GlassShardModule;

public class QuarkRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public QuarkRecipeProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> holderLookupProvider) {
        super(packOutput, holderLookupProvider);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)ChuteModule.chute).pattern("WWW").pattern("SWS").pattern(" S ").define(Character.valueOf('W'), ItemTags.PLANKS).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).save(recipeOutput, "quark:automation/crafting/chute");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)EnderWatcherModule.ender_watcher).pattern("BRB").pattern("RER").pattern("BRB").define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('B'), (ItemLike)Blocks.OBSIDIAN.asItem()).define(Character.valueOf('E'), (ItemLike)Items.ENDER_EYE).save(recipeOutput, "quark:automation/crafting/ender_watcher");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)FeedingTroughModule.feeding_trough).pattern("#W#").pattern("###").define(Character.valueOf('#'), ItemTags.PLANKS).define(Character.valueOf('#'), (ItemLike)Items.WHEAT).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)MetalButtonsModule.gold_button).requires(ItemTags.WOODEN_BUTTONS).requires(Tags.Items.INGOTS_GOLD).save(recipeOutput, "quark:automation/crafting/gold_button");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)GravisandModule.gravisand).pattern("SSS").pattern("SES").pattern("SSS").define(Character.valueOf('S'), Tags.Items.SANDS_COLORLESS).define(Character.valueOf('E'), Tags.Items.ENDER_PEARLS).save(recipeOutput, "quark:automation/crafting/gravisand");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)MetalButtonsModule.iron_button).requires(ItemTags.WOODEN_BUTTONS).requires(Tags.Items.INGOTS_IRON).save(recipeOutput, "quark:automation/crafting/iron_button");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)NetherBrickFenceGateModule.netherBrickFenceGate).pattern("#W#").pattern("#W#").define(Character.valueOf('#'), Tags.Items.BRICKS_NETHER).define(Character.valueOf('W'), (ItemLike)Blocks.NETHER_BRICKS.asItem()).save(recipeOutput, "quark:automation/crafting/nether_brick_fence_gate");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)ObsidianPlateModule.obsidian_plate).pattern("OO").define(Character.valueOf('W'), Tags.Items.OBSIDIANS).save(recipeOutput, "quark:automation/crafting/obsidian_late");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)RedstoneRandomizerModule.redstone_randomizer).pattern(" X ").pattern("XBX").pattern("III").define(Character.valueOf('X'), (ItemLike)Items.REDSTONE_TORCH).define(Character.valueOf('X'), (ItemLike)Items.STONE).define(Character.valueOf('X'), (ItemLike)Items.PRISMARINE_CRYSTALS).save(recipeOutput, "quark:automation/crafting/redstone_randomizer");
        for (Block block : VariantChestsModule.regularChests) {
        }
        for (Block block : VariantChestsModule.trappedChests) {
        }
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.APPLE, (ItemLike)CompressedBlocksModule.apple, recipeOutput, null, "apple_crate");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.BEETROOT, (ItemLike)CompressedBlocksModule.beetroot, recipeOutput, null, "beetroot_crate");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.SWEET_BERRIES, (ItemLike)CompressedBlocksModule.berry, recipeOutput, null, "berry_sack");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.LEATHER, (ItemLike)CompressedBlocksModule.leather, recipeOutput, null, "bonded_leather");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.RABBIT_HIDE, (ItemLike)CompressedBlocksModule.hide, recipeOutput, null, "bonded_rabbit_hide");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.CACTUS, (ItemLike)CompressedBlocksModule.cactus, recipeOutput, null, "cactus_block");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.CARROT, (ItemLike)CompressedBlocksModule.carrot, recipeOutput, null, "carrot_crate");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.CHARCOAL, (ItemLike)CompressedBlocksModule.charcoal_block, recipeOutput, null, "charcoal_block");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.CHORUS_FRUIT, (ItemLike)CompressedBlocksModule.chorus, recipeOutput, null, "chorus_fruit_block");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.COCOA_BEANS, (ItemLike)CompressedBlocksModule.cocoa, recipeOutput, null, "cocoa_beans_sack");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.GLOW_BERRIES, (ItemLike)CompressedBlocksModule.glowberry, recipeOutput, null, "glowberry_sack");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.GOLDEN_APPLE, (ItemLike)CompressedBlocksModule.golden_apple_crate, recipeOutput, null, "golden_apple_crate");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.GOLDEN_CARROT, (ItemLike)CompressedBlocksModule.golden_carrot, recipeOutput, null, "golden_carrot_crate");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.GUNPOWDER, (ItemLike)CompressedBlocksModule.gunpowder, recipeOutput, null, "gunpowder_sack");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.NETHER_WART, (ItemLike)CompressedBlocksModule.wart, recipeOutput, null, "nether_wart_sack");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.POTATO, (ItemLike)CompressedBlocksModule.potato, recipeOutput, null, "potato_crate");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.STICK, (ItemLike)CompressedBlocksModule.stick_block, recipeOutput, null, "stick_block");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.SUGAR_CANE, (ItemLike)CompressedBlocksModule.sugarCane, recipeOutput, null, "sugar_cane_block");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)FramedGlassModule.framed_glass, (int)8).pattern("IGI").pattern("G G").pattern("IGI").define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS_COLORLESS).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).save(recipeOutput, "quark:building/crafting/glass/framed_glass");
        for (DyeColor dyeColor : FramedGlassModule.blockMap.keySet()) {
            QuarkRecipeProvider.dyedFramedGlassRecipe((ItemLike)FramedGlassModule.blockMap.get(dyeColor).getBlock(), dyeColor).save(recipeOutput, "quark:building/glass/" + dyeColor.getName() + "_framed_glass");
        }
        for (DyeColor dyeColor : FramedGlassModule.paneMap.keySet()) {
            QuarkRecipeProvider.paneRecipe((ItemLike)FramedGlassModule.blockMap.get(dyeColor).getBlock(), (ItemLike)FramedGlassModule.blockMap.get(dyeColor).getBlock()).save(recipeOutput, "quark:building/panes/" + dyeColor.getName() + "_framed_glass_pane");
        }
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)VariantSelectorModule.hammer).pattern("III").pattern("ISI").pattern(" S ").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).save(recipeOutput, "quark:experimental/crafting/hammer");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)BackpackModule.ravager_hide, (int)9).requires((ItemLike)BackpackModule.bonded_ravager_hide).save(recipeOutput, "quark:oddities/crafting/bonded_ravager_hide_uncompress");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)BackpackModule.bonded_ravager_hide).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)BackpackModule.ravager_hide).save(recipeOutput, "quark:oddities/crafting/bonded_ravager_hide");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)CrateModule.crate).pattern("IWI").pattern("WCW").pattern("IWI").define(Character.valueOf('W'), ItemTags.PLANKS).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).save(recipeOutput, "quark:oddities/crafting/crate");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)PipesModule.encasedPipe).requires((ItemLike)PipesModule.pipe).requires(Tags.Items.GLASS_BLOCKS_COLORLESS).save(recipeOutput, "quark:oddities/crafting/encased_pipe");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)PipesModule.pipe).requires((ItemLike)PipesModule.encasedPipe).save(recipeOutput, "quark:oddities/crafting/encased_pipe_revert");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)MagnetsModule.magnet).pattern("CIC").pattern("BFR").pattern("CIC").define(Character.valueOf('C'), Tags.Items.COBBLESTONES).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('B'), Tags.Items.DYES_BLUE).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('F'), (ItemLike)Items.CHORUS_FRUIT).save(recipeOutput, "quark:oddities/crafting/crate");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)PipesModule.pipe).pattern("I").pattern("G").pattern("I").define(Character.valueOf('I'), Tags.Items.INGOTS_COPPER).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS).save(recipeOutput, "quark:oddities/crafting/pipe");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)TinyPotatoModule.tiny_potato).pattern("H").pattern("P").define(Character.valueOf('H'), (ItemLike)StonelingsModule.diamondHeart).define(Character.valueOf('P'), (ItemLike)Items.POTATO).save(recipeOutput, "quark:oddities/crafting/tiny_potato_heart");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)TinyPotatoModule.tiny_potato).pattern("D").pattern("P").define(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).define(Character.valueOf('P'), (ItemLike)Items.POTATO).save(recipeOutput, "quark:oddities/crafting/tiny_potato_no_heart");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)AbacusModule.abacus).pattern("WSW").pattern("WIW").pattern("WSW").define(Character.valueOf('W'), ItemTags.PLANKS).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).save(recipeOutput, "quark:tools/crafting/abacus");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)PickarangModule.pickarang).pattern("DWH").pattern("  W").pattern("  D").define(Character.valueOf('W'), ItemTags.PLANKS).define(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).define(Character.valueOf('H'), (ItemLike)StonelingsModule.diamondHeart).save(recipeOutput, "quark:tools/crafting/pickarang_heart");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)PickarangModule.pickarang).pattern("DWD").pattern("  W").pattern("  D").define(Character.valueOf('W'), ItemTags.PLANKS).define(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).save(recipeOutput, "quark:tools/crafting/pickarang_no_heart");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)ColorRunesModule.rune).pattern("#S#").pattern("#C#").pattern("###").define(Character.valueOf('#'), TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"quark", (String)"corundum"))).define(Character.valueOf('S'), Tags.Items.COBBLESTONES).define(Character.valueOf('I'), (ItemLike)ColorRunesModule.rune).save(recipeOutput, "quark:tools/crafting/rune_duplication");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)SeedPouchModule.seed_pouch, (int)2).pattern(" S ").pattern("HXH").pattern(" H").define(Character.valueOf('S'), (ItemLike)Items.STRING).define(Character.valueOf('H'), TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"quark", (String)"seed_pouch_holdable"))).define(Character.valueOf('X'), (ItemLike)ColorRunesModule.rune).save(recipeOutput, "quark:tools/crafting/seed_pouch");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)TorchArrowModule.torch_arrow).requires((ItemLike)Items.TORCH).requires((ItemLike)Items.ARROW).save(recipeOutput, "quark:tools/crafting/torch_arrow");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)TrowelModule.trowel).pattern("S  ").pattern(" II").define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).save(recipeOutput, "quark:tools/crafting/trowel");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)GlassShardModule.dirtyGlassPane, (int)16).pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)GlassShardModule.dirtyGlass).save(recipeOutput, "quark:tweaks/crafting/panes/dirty_glass_pane");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)Items.BREAD).pattern("##").pattern("# ").define(Character.valueOf('#'), (ItemLike)Items.WHEAT).save(recipeOutput, "quark:tweaks/crafting/utility/bent/bread");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)Items.COOKIE).pattern("X#").pattern("# ").define(Character.valueOf('#'), (ItemLike)Items.WHEAT).define(Character.valueOf('X'), (ItemLike)Items.COCOA_BEANS).save(recipeOutput, "quark:tweaks/crafting/utility/bent/cookie");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.PAPER, (int)3).pattern("##").pattern("# ").define(Character.valueOf('#'), (ItemLike)Items.SUGAR_CANE).save(recipeOutput, "quark:tweaks/crafting/utility/bent/paper");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.BLACK_DYE).requires((ItemLike)Items.CHARCOAL).group("black_dye").save(recipeOutput, "quark:tweaks/crafting/utility/misc/charcoal_to_black_dye");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.CHEST_MINECART).pattern("#C#").pattern("### ").define(Character.valueOf('#'), Tags.Items.INGOTS_IRON).define(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).save(recipeOutput, "quark:tweaks/crafting/utility/misc/chest_minecart");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.DISPENSER).requires((ItemLike)Items.BOW).requires((ItemLike)Items.DROPPER).save(recipeOutput, "quark:tweaks/crafting/utility/misc/dispenser_bow");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.DISPENSER).pattern(" #X").pattern("#DX").pattern(" #X").define(Character.valueOf('#'), Tags.Items.RODS_WOODEN).define(Character.valueOf('X'), (ItemLike)Items.STRING).define(Character.valueOf('D'), (ItemLike)Items.DROPPER).save(recipeOutput, "quark:tweaks/crafting/utility/misc/dispenser_no_bow");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.HOPPER).pattern("IWI").pattern("IWI").pattern(" I ").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('X'), ItemTags.LOGS).save(recipeOutput, "quark:tweaks/crafting/utility/misc/easy_hopper");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.STICK, (int)16).pattern("#").pattern("#").define(Character.valueOf('#'), ItemTags.LOGS).save(recipeOutput, "quark:tweaks/crafting/utility/misc/easy_sticks");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.STICK, (int)8).pattern("#").pattern("#").define(Character.valueOf('#'), ItemTags.BAMBOO_BLOCKS).save(recipeOutput, "quark:tweaks/crafting/utility/misc/easy_sticks_bamboo");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.FURNACE_MINECART).pattern("#X#").pattern("###").define(Character.valueOf('#'), Tags.Items.INGOTS_IRON).define(Character.valueOf('#'), (ItemLike)Items.FURNACE).save(recipeOutput, "quark:tweaks/crafting/utility/misc/furnace_minecart");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.HOPPER_MINECART).pattern("#X#").pattern("###").define(Character.valueOf('#'), Tags.Items.INGOTS_IRON).define(Character.valueOf('#'), (ItemLike)Items.HOPPER).save(recipeOutput, "quark:tweaks/crafting/utility/misc/hopper_minecart");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.HOPPER_MINECART).pattern("X X").pattern("#X#").pattern("III").define(Character.valueOf('#'), Tags.Items.RODS_WOODEN).define(Character.valueOf('X'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('I'), (ItemLike)Items.STONE).save(recipeOutput, "quark:tweaks/crafting/utility/misc/repeater");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.TNT_MINECART).pattern("#X#").pattern("###").define(Character.valueOf('#'), Tags.Items.INGOTS_IRON).define(Character.valueOf('#'), (ItemLike)Items.TNT).save(recipeOutput, "quark:tweaks/crafting/utility/misc/tnt_minecart");
        QuarkRecipeProvider.shardGlassRecipe(Items.BLACK_STAINED_GLASS).save(recipeOutput, "quark:tweaks/crafting/utility/glass/black_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.BLUE_STAINED_GLASS).save(recipeOutput, "quark:tweaks/crafting/utility/glass/blue_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.BROWN_STAINED_GLASS).save(recipeOutput, "quark:tweaks/crafting/utility/glass/brown_glass");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.GLASS).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)GlassShardModule.clearShard).save(recipeOutput, "quark:tweaks/crafting/utility/glass/clear_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.CYAN_STAINED_GLASS).save(recipeOutput, "quark:tweaks/crafting/utility/glass/cyan_glass");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)GlassShardModule.dirtyGlass).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)GlassShardModule.dirtyShard).save(recipeOutput, "quark:tweaks/crafting/utility/glass/dirty_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.GRAY_STAINED_GLASS).save(recipeOutput, "quark:tweaks/crafting/utility/glass/gray_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.GREEN_STAINED_GLASS).save(recipeOutput, "quark:tweaks/crafting/utility/glass/green_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.LIGHT_BLUE_STAINED_GLASS).save(recipeOutput, "quark:tweaks/crafting/utility/glass/light_blue_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.LIGHT_GRAY_STAINED_GLASS).save(recipeOutput, "quark:tweaks/crafting/utility/glass/light_gray_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.LIME_STAINED_GLASS).save(recipeOutput, "quark:tweaks/crafting/utility/glass/lime_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.MAGENTA_STAINED_GLASS).save(recipeOutput, "quark:tweaks/crafting/utility/glass/magenta_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.ORANGE_STAINED_GLASS).save(recipeOutput, "quark:tweaks/crafting/utility/glass/orange_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.PINK_STAINED_GLASS).save(recipeOutput, "quark:tweaks/crafting/utility/glass/pink_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.PURPLE_STAINED_GLASS).save(recipeOutput, "quark:tweaks/crafting/utility/glass/purple_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.RED_STAINED_GLASS).save(recipeOutput, "quark:tweaks/crafting/utility/glass/red_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.WHITE_STAINED_GLASS).save(recipeOutput, "quark:tweaks/crafting/utility/glass/white_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.YELLOW_STAINED_GLASS).save(recipeOutput, "quark:tweaks/crafting/utility/glass/yellow_glass");
    }

    public static ShapedRecipeBuilder chestRecipe(ItemLike output, ItemLike plank) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)output).pattern("###").pattern("# #").pattern("###").define(Character.valueOf('#'), plank);
    }

    public static ShapelessRecipeBuilder trappedChestRecipe(ItemLike output, ItemLike originalChest) {
        return ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)output).requires(originalChest).requires((ItemLike)Items.TRIPWIRE_HOOK);
    }

    public static ShapedRecipeBuilder shardGlassRecipe(Item output) {
        StainedGlassBlock glass = (StainedGlassBlock)Block.byItem((Item)output);
        DyeColor shardColor = glass.getColor();
        Item shard = GlassShardModule.shardColors.get(shardColor);
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)shard);
    }

    public static ShapelessRecipeBuilder dyedFramedGlassRecipe(ItemLike output, DyeColor dye) {
        return ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)8).requires((ItemLike)FramedGlassModule.framed_glass).requires((ItemLike)FramedGlassModule.framed_glass).requires((ItemLike)FramedGlassModule.framed_glass).requires((ItemLike)FramedGlassModule.framed_glass).requires((ItemLike)FramedGlassModule.framed_glass).requires((ItemLike)FramedGlassModule.framed_glass).requires((ItemLike)FramedGlassModule.framed_glass).requires((ItemLike)FramedGlassModule.framed_glass).requires((ItemLike)DyeItem.byColor((DyeColor)dye));
    }

    public static ShapedRecipeBuilder paneRecipe(ItemLike output, ItemLike glass) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)16).pattern("###").pattern("###").define(Character.valueOf('#'), glass);
    }

    public static void compressUncompress(ItemLike item, ItemLike block, RecipeOutput recipeOutput, String configFlag, String blockName) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)block).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), item).save(recipeOutput, "quark:building/crafting/compressed/" + blockName);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)item, (int)9).requires(block).save(recipeOutput, "quark:oddities/crafting/" + blockName + "uncompress");
    }
}

