/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tools.module;

import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.world.block.CorundumClusterBlock;
import org.violetmoon.quark.content.world.module.CorundumModule;
import org.violetmoon.zeta.advancement.ManualTrigger;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.load.ZConfigChanged;
import org.violetmoon.zeta.event.load.ZGatherHints;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.Hint;

@ZetaLoadModule(category="tools")
public class BeaconRedirectionModule
extends ZetaModule {
    private static final TagKey<Block> BEACON_TRANSPARENT = Quark.asTagKey(Registries.BLOCK, "beacon_transparent");
    @Config
    public static int horizontalMoveLimit = 64;
    @Config(flag="tinted_glass_dims")
    public static boolean allowTintedGlassTransparency = true;
    @Hint(value="tinted_glass_dims")
    Item tinted_glass = Items.TINTED_GLASS;
    public static boolean staticEnabled;
    public static ManualTrigger redirectTrigger;

    @LoadEvent
    public final void register(ZRegister event) {
        redirectTrigger = event.getAdvancementModifierRegistry().registerManualTrigger("redirect_beacon");
    }

    @LoadEvent
    public final void configChanged(ZConfigChanged event) {
        staticEnabled = this.isEnabled();
    }

    @LoadEvent
    public void addAdditionalHints(ZGatherHints event) {
        String redirectHint = "beacon_redirect_item";
        String type = "amethyst";
        if (!Quark.ZETA.modules.isEnabled(CorundumModule.class)) {
            event.hintItem((ItemLike)Items.AMETHYST_CLUSTER, "beacon_redirect_item", new Object[]{this.zeta()});
        } else {
            type = "corundum";
        }
        MutableComponent comp = Component.translatable((String)"quark.jei.hint.beacon_redirection", (Object[])new Object[]{Component.translatable((String)("quark.jei.hint.beacon_" + type))});
        event.accept((ItemLike)Items.BEACON, (Component)comp);
    }

    public static int tickBeacon(BeaconBlockEntity beacon, int original) {
        BlockPos beaconPos;
        if (!staticEnabled) {
            return original;
        }
        Level world = beacon.getLevel();
        BlockPos currPos = beaconPos = beacon.getBlockPos();
        int horizontalMoves = horizontalMoveLimit;
        int targetHeight = world.getHeight(Heightmap.Types.WORLD_SURFACE, beaconPos.getX(), beaconPos.getZ());
        boolean broke = false;
        boolean didRedirection = false;
        beacon.checkingBeamSections.clear();
        int currColor = 0xFFFFFF;
        float alpha = 1.0f;
        Direction lastDir = null;
        ExtendedBeamSegment currSegment = new ExtendedBeamSegment(Direction.UP, Vec3i.ZERO, currColor, alpha);
        HashSet<BlockPos> seenPositions = new HashSet<BlockPos>();
        boolean check = true;
        boolean hardColorSet = false;
        while (world.isInWorldBounds(currPos) && horizontalMoves > 0) {
            boolean added;
            if (currSegment.dir == Direction.UP && currSegment.dir != lastDir) {
                int heightmapVal = world.getHeight(Heightmap.Types.WORLD_SURFACE, currPos.getX(), currPos.getZ());
                if (heightmapVal == currPos.getY() + 1) {
                    currSegment.setHeight(heightmapVal + 1000);
                    break;
                }
                lastDir = currSegment.dir;
            }
            currPos = currPos.relative(currSegment.dir);
            horizontalMoves = currSegment.dir.getAxis().isHorizontal() ? --horizontalMoves : horizontalMoveLimit;
            BlockState blockstate = world.getBlockState(currPos);
            Block block = blockstate.getBlock();
            Integer targetColor = blockstate.getBeaconColorMultiplier((LevelReader)world, currPos, beaconPos);
            float targetAlpha = -1.0f;
            if (allowTintedGlassTransparency && block == Blocks.TINTED_GLASS) {
                float f = targetAlpha = alpha < 0.3f ? 0.0f : alpha / 2.0f;
            }
            if (BeaconRedirectionModule.isRedirectingBlock(block)) {
                Direction dir = (Direction)blockstate.getValue((Property)BlockStateProperties.FACING);
                if (dir == currSegment.dir) {
                    currSegment.increaseHeight();
                } else {
                    check = true;
                    beacon.checkingBeamSections.add(currSegment);
                    targetColor = BeaconRedirectionModule.getTargetColor(block);
                    if (targetColor >> 16 == 255 && targetColor >> 8 == 255 && targetColor == 255) {
                        targetColor = currColor;
                    }
                    currColor = ((currColor >> 16) + (targetColor >> 16) * 3) / 4 + ((currColor >> 8) + (targetColor >> 8) * 3) / 4 + (currColor + targetColor * 3) / 4;
                    alpha = 1.0f;
                    didRedirection = true;
                    lastDir = currSegment.dir;
                    currSegment = new ExtendedBeamSegment(dir, (Vec3i)currPos.subtract((Vec3i)beaconPos), currColor, alpha);
                }
            } else if (targetColor != null || targetAlpha != -1.0f) {
                if (targetColor.equals(currColor) && targetAlpha == alpha) {
                    currSegment.increaseHeight();
                } else {
                    check = true;
                    beacon.checkingBeamSections.add(currSegment);
                    int mixedColor = currColor;
                    if (targetColor != null) {
                        mixedColor = ((currColor >> 16) + (targetColor >> 16)) / 2 + ((currColor >> 8) + (targetColor >> 8)) / 2 + (currColor + targetColor) / 2;
                        if (!hardColorSet) {
                            mixedColor = targetColor;
                            hardColorSet = true;
                        }
                        currColor = mixedColor;
                    }
                    if (targetAlpha != -1.0f) {
                        alpha = targetAlpha;
                    }
                    lastDir = currSegment.dir;
                    currSegment = new ExtendedBeamSegment(currSegment.dir, (Vec3i)currPos.subtract((Vec3i)beaconPos), mixedColor, alpha);
                }
            } else {
                boolean bedrock = blockstate.is(BEACON_TRANSPARENT);
                if (!bedrock && blockstate.getLightBlock((BlockGetter)world, currPos) >= 15) {
                    broke = true;
                    break;
                }
                currSegment.increaseHeight();
                if (bedrock) continue;
            }
            if (!check || (added = seenPositions.add(currPos))) continue;
            broke = true;
            break;
        }
        if (horizontalMoves == 0 || currPos.getY() <= world.getMinBuildHeight()) {
            broke = true;
        }
        String tag = "quark:redirected";
        if (!broke) {
            beacon.checkingBeamSections.add(currSegment);
            beacon.lastCheckY = targetHeight + 1;
        } else {
            beacon.getPersistentData().putBoolean("quark:redirected", false);
            beacon.checkingBeamSections.clear();
            beacon.lastCheckY = targetHeight;
        }
        if (!beacon.getPersistentData().getBoolean("quark:redirected") && didRedirection && !beacon.checkingBeamSections.isEmpty()) {
            beacon.getPersistentData().putBoolean("quark:redirected", true);
            int i = beaconPos.getX();
            int j = beaconPos.getY();
            int k = beaconPos.getZ();
            for (ServerPlayer serverplayer : beacon.getLevel().getEntitiesOfClass(ServerPlayer.class, new AABB((double)i, (double)j, (double)k, (double)i, (double)(j - 4), (double)k).inflate(10.0, 5.0, 10.0))) {
                redirectTrigger.trigger(serverplayer);
            }
        }
        return Integer.MAX_VALUE;
    }

    private static boolean isRedirectingBlock(Block block) {
        return CorundumModule.staticEnabled ? block instanceof CorundumClusterBlock : block == Blocks.AMETHYST_CLUSTER;
    }

    private static int getTargetColor(Block block) {
        int n;
        if (block instanceof CorundumClusterBlock) {
            CorundumClusterBlock cc = (CorundumClusterBlock)block;
            n = cc.base.color;
        } else {
            n = 0x1000000;
        }
        return n;
    }

    public static class ExtendedBeamSegment
    extends BeaconBlockEntity.BeaconBeamSection {
        public final Direction dir;
        public final Vec3i offset;
        public final float alpha;
        private boolean isTurn = false;

        public ExtendedBeamSegment(Direction dir, Vec3i offset, int colorsIn, float alpha) {
            super(colorsIn);
            this.offset = offset;
            this.dir = dir;
            this.alpha = alpha;
        }

        public void makeTurn() {
            this.isTurn = true;
        }

        public boolean isTurn() {
            return this.isTurn;
        }

        public void increaseHeight() {
            super.increaseHeight();
        }

        public void setHeight(int target) {
            this.height = target;
        }
    }
}

