/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import org.violetmoon.quark.content.automation.module.ChuteModule;
import org.violetmoon.quark.content.automation.module.EnderWatcherModule;
import org.violetmoon.quark.content.automation.module.FeedingTroughModule;
import org.violetmoon.quark.content.automation.module.GravisandModule;
import org.violetmoon.quark.content.automation.module.MetalButtonsModule;
import org.violetmoon.quark.content.automation.module.ObsidianPlateModule;
import org.violetmoon.quark.content.automation.module.RedstoneRandomizerModule;
import org.violetmoon.quark.content.building.module.NetherBrickFenceGateModule;
import org.violetmoon.quark.content.building.module.VariantChestsModule;
import org.violetmoon.quark.content.experimental.module.VariantSelectorModule;
import org.violetmoon.quark.content.tools.module.AbacusModule;
import org.violetmoon.quark.content.tools.module.ColorRunesModule;
import org.violetmoon.quark.content.tools.module.SeedPouchModule;
import org.violetmoon.quark.content.tools.module.TorchArrowModule;
import org.violetmoon.quark.content.tools.module.TrowelModule;

public class QuarkRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public QuarkRecipeProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> holderLookupProvider) {
        super(packOutput, holderLookupProvider);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)ChuteModule.chute).pattern("WWW").pattern("SWS").pattern(" S ").define(Character.valueOf('W'), ItemTags.PLANKS).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).save(recipeOutput, "quark:automation/crafting/chute");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)EnderWatcherModule.ender_watcher).pattern("BRB").pattern("RER").pattern("BRB").define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('B'), (ItemLike)Blocks.OBSIDIAN.asItem()).define(Character.valueOf('E'), (ItemLike)Items.ENDER_EYE).save(recipeOutput, "quark:automation/crafting/ender_watcher");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)FeedingTroughModule.feeding_trough).pattern("#W#").pattern("###").define(Character.valueOf('#'), ItemTags.PLANKS).define(Character.valueOf('#'), (ItemLike)Items.WHEAT).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)MetalButtonsModule.gold_button).requires(ItemTags.WOODEN_BUTTONS).requires(Tags.Items.INGOTS_GOLD).save(recipeOutput, "quark:automation/crafting/gold_button");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)GravisandModule.gravisand).pattern("SSS").pattern("SES").pattern("SSS").define(Character.valueOf('S'), Tags.Items.SANDS_COLORLESS).define(Character.valueOf('E'), Tags.Items.ENDER_PEARLS).save(recipeOutput, "quark:automation/crafting/gravisand");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)MetalButtonsModule.iron_button).requires(ItemTags.WOODEN_BUTTONS).requires(Tags.Items.INGOTS_IRON).save(recipeOutput, "quark:automation/crafting/iron_button");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)NetherBrickFenceGateModule.netherBrickFenceGate).pattern("#W#").pattern("#W#").define(Character.valueOf('#'), Tags.Items.BRICKS_NETHER).define(Character.valueOf('W'), (ItemLike)Blocks.NETHER_BRICKS.asItem()).save(recipeOutput, "quark:automation/crafting/nether_brick_fence_gate");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)ObsidianPlateModule.obsidian_plate).pattern("OO").define(Character.valueOf('W'), Tags.Items.OBSIDIANS).save(recipeOutput, "quark:automation/crafting/obsidian_late");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)RedstoneRandomizerModule.redstone_randomizer).pattern(" X ").pattern("XBX").pattern("III").define(Character.valueOf('X'), (ItemLike)Items.REDSTONE_TORCH).define(Character.valueOf('X'), (ItemLike)Items.STONE).define(Character.valueOf('X'), (ItemLike)Items.PRISMARINE_CRYSTALS).save(recipeOutput, "quark:automation/crafting/redstone_randomizer");
        for (Block block : VariantChestsModule.regularChests) {
        }
        for (Block block : VariantChestsModule.trappedChests) {
        }
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)VariantSelectorModule.hammer).pattern("III").pattern("ISI").pattern(" S ").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).save(recipeOutput, "quark:experimental/crafting/hammer");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)AbacusModule.abacus).pattern("WSW").pattern("WIW").pattern("WSW").define(Character.valueOf('W'), ItemTags.PLANKS).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).save(recipeOutput, "quark:tools/crafting/abacus");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)ColorRunesModule.rune).pattern("#S#").pattern("#C#").pattern("###").define(Character.valueOf('#'), TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"quark", (String)"corundum"))).define(Character.valueOf('S'), Tags.Items.COBBLESTONES).define(Character.valueOf('I'), (ItemLike)ColorRunesModule.rune).save(recipeOutput, "quark:tools/crafting/rune_duplication");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)SeedPouchModule.seed_pouch, (int)2).pattern(" S ").pattern("HXH").pattern(" H").define(Character.valueOf('S'), (ItemLike)Items.STRING).define(Character.valueOf('H'), TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"quark", (String)"seed_pouch_holdable"))).define(Character.valueOf('X'), (ItemLike)ColorRunesModule.rune).save(recipeOutput, "quark:tools/crafting/seed_pouch");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)TorchArrowModule.torch_arrow).requires((ItemLike)Items.TORCH).requires((ItemLike)Items.ARROW).save(recipeOutput, "quark:tools/crafting/torch_arrow");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)TrowelModule.trowel).pattern("S  ").pattern(" II").define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).save(recipeOutput, "quark:tools/crafting/trowel");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)TrowelModule.trowel).pattern("S  ").pattern(" II").define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).save(recipeOutput, "quark:tools/crafting/trowel");
    }

    public static ShapedRecipeBuilder chestRecipe(ItemLike output, ItemLike plank) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)output).pattern("###").pattern("# #").pattern("###").define(Character.valueOf('#'), plank);
    }

    public static ShapelessRecipeBuilder trappedChestRecipe(ItemLike output, ItemLike originalChest) {
        return ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)output).requires(originalChest).requires((ItemLike)Items.TRIPWIRE_HOOK);
    }
}

