/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.block.be;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.addons.oddities.block.CrateBlock;
import org.violetmoon.quark.addons.oddities.capability.CrateItemHandler;
import org.violetmoon.quark.addons.oddities.inventory.CrateMenu;
import org.violetmoon.quark.addons.oddities.module.CrateModule;

public class CrateBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    private int numPlayersUsing;
    private int[] visibleSlots = new int[0];
    protected final ContainerData crateData = new ContainerData(){

        public int get(int index) {
            CrateItemHandler handler = CrateBlockEntity.this.itemHandler();
            return index == 0 ? handler.displayTotal : handler.displaySlots;
        }

        public void set(int index, int value) {
        }

        public int getCount() {
            return 2;
        }
    };

    public CrateBlockEntity(BlockPos pos, BlockState state) {
        super(CrateModule.blockEntityType, pos, state);
    }

    public void spillTheTea() {
        this.itemHandler().spill(this.level, this.worldPosition);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CrateBlockEntity be) {
        be.tick();
    }

    public void tick() {
        this.itemHandler().recalculate();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.merge(this.itemHandler().serializeNBT(provider));
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.itemHandler().deserializeNBT(provider, tag);
    }

    public CrateItemHandler itemHandler() {
        IItemHandler iItemHandler;
        Optional<IItemHandler> handler = Optional.ofNullable((IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, this.getBlockPos(), null));
        if (handler.isPresent() && (iItemHandler = handler.orElse((IItemHandler)new ItemStackHandler())) instanceof CrateItemHandler) {
            CrateItemHandler crateHandler = (CrateItemHandler)iItemHandler;
            return crateHandler;
        }
        return new CrateItemHandler();
    }

    @NotNull
    public ItemStack getItem(int slot) {
        return this.itemHandler().getStackInSlot(slot);
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        return this.itemHandler().extractItem(slot, 64, true);
    }

    public void setItem(int slot, @NotNull ItemStack stack) {
        this.itemHandler().setStackInSlot(slot, stack);
    }

    @NotNull
    public ItemStack removeItem(int slot, int count) {
        return this.itemHandler().extractItem(slot, 64, true);
    }

    public int getContainerSize() {
        return this.itemHandler().getSlots();
    }

    public void clearContent() {
        this.itemHandler().clear();
    }

    public boolean isEmpty() {
        return this.itemHandler().isEmpty();
    }

    public boolean canTakeItemThroughFace(int index, @NotNull ItemStack stack, @NotNull Direction dir) {
        return true;
    }

    public boolean canPlaceItemThroughFace(int index, @NotNull ItemStack stack, Direction dir) {
        return this.itemHandler().getSlotLimit(index) > 0;
    }

    public int @NotNull [] getSlotsForFace(@NotNull Direction dir) {
        int slotCount = this.itemHandler().getSlots();
        if (this.visibleSlots.length != slotCount) {
            this.visibleSlots = new int[slotCount];
            for (int i = 0; i < slotCount; ++i) {
                this.visibleSlots[i] = i;
            }
        }
        return this.visibleSlots;
    }

    @NotNull
    protected Component getDefaultName() {
        return Component.translatable((String)CrateModule.crate.getDescriptionId());
    }

    protected NonNullList<ItemStack> getItems() {
        return null;
    }

    protected void setItems(NonNullList<ItemStack> p_332640_) {
    }

    @NotNull
    protected AbstractContainerMenu createMenu(int id, @NotNull Inventory player) {
        return new CrateMenu(id, player, this, this.crateData);
    }

    public boolean stillValid(@NotNull Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    public void startOpen(Player player) {
        if (!player.isSpectator()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            BlockState blockstate = this.getBlockState();
            boolean flag = (Boolean)blockstate.getValue((Property)CrateBlock.PROPERTY_OPEN);
            if (!flag) {
                this.playSound(blockstate, SoundEvents.BARREL_OPEN);
                this.level.gameEvent((Entity)player, (Holder)GameEvent.CONTAINER_OPEN, this.worldPosition);
                this.setOpenProperty(blockstate, true);
            }
            this.scheduleTick();
        }
    }

    private void scheduleTick() {
        this.level.scheduleTick(this.getBlockPos(), this.getBlockState().getBlock(), 5);
    }

    public void crateTick() {
        int i = this.worldPosition.getX();
        int j = this.worldPosition.getY();
        int k = this.worldPosition.getZ();
        this.numPlayersUsing = CrateBlockEntity.calculatePlayersUsing(this.level, this, i, j, k);
        if (this.numPlayersUsing > 0) {
            this.scheduleTick();
        }
    }

    public static int calculatePlayersUsing(Level world, BaseContainerBlockEntity container, int x, int y, int z) {
        int i = 0;
        for (Player playerentity : world.getEntitiesOfClass(Player.class, new AABB((double)((float)x - 5.0f), (double)((float)y - 5.0f), (double)((float)z - 5.0f), (double)((float)(x + 1) + 5.0f), (double)((float)(y + 1) + 5.0f), (double)((float)(z + 1) + 5.0f)))) {
            CrateBlockEntity iinventory;
            if (!(playerentity.containerMenu instanceof CrateMenu) || (iinventory = ((CrateMenu)playerentity.containerMenu).crate) != container) continue;
            ++i;
        }
        return i;
    }

    public void stopOpen(Player player) {
        if (!player.isSpectator()) {
            --this.numPlayersUsing;
        }
        if (this.numPlayersUsing <= 0) {
            BlockState blockstate = this.getBlockState();
            if (!blockstate.is(CrateModule.crate)) {
                this.setRemoved();
                return;
            }
            boolean flag = (Boolean)blockstate.getValue((Property)CrateBlock.PROPERTY_OPEN);
            if (flag) {
                this.playSound(blockstate, SoundEvents.BARREL_CLOSE);
                this.level.gameEvent((Entity)player, (Holder)GameEvent.CONTAINER_OPEN, this.worldPosition);
                this.setOpenProperty(blockstate, false);
            }
        }
    }

    private void setOpenProperty(BlockState state, boolean open) {
        BlockPos pos = this.getBlockPos();
        BlockState prev = this.level.getBlockState(pos);
        if (prev.is(state.getBlock())) {
            this.level.setBlock(pos, (BlockState)state.setValue((Property)CrateBlock.PROPERTY_OPEN, (Comparable)Boolean.valueOf(open)), 3);
        }
    }

    private void playSound(BlockState state, SoundEvent sound) {
        double d0 = (double)this.worldPosition.getX() + 0.5;
        double d1 = (double)this.worldPosition.getY() + 0.5;
        double d2 = (double)this.worldPosition.getZ() + 0.5;
        this.level.playSound(null, d0, d1, d2, sound, SoundSource.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.9f);
    }
}

