/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.mobs.entity;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RodBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.ItemAbilities;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.handler.QuarkSounds;
import org.violetmoon.quark.content.mobs.module.ToretoiseModule;
import org.violetmoon.zeta.util.BlockUtils;
import org.violetmoon.zeta.util.MiscUtil;

public class Toretoise
extends Animal {
    private static final TagKey<Block> BREAKS_TORETOISE_ORE = BlockTags.create((ResourceLocation)Quark.asResource("breaks_toretoise_ore"));
    public static final int ORE_TYPES = 5;
    public static final int ANGERY_TIME = 20;
    private static final String TAG_TAMED = "tamed";
    private static final String TAG_ORE = "oreType";
    private static final String TAG_EAT_COOLDOWN = "eatCooldown";
    private static final String TAG_ANGERY_TICKS = "angeryTicks";
    public int rideTime;
    private boolean isTamed;
    private int eatCooldown;
    public int angeryTicks;
    private Ingredient goodFood;
    private LivingEntity lastAggressor;
    private static final EntityDataAccessor<Integer> ORE_TYPE = SynchedEntityData.defineId(Toretoise.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public Toretoise(EntityType<? extends Toretoise> type, Level world) {
        super(type, world);
        this.setPathfindingMalus(PathType.WATER, 1.0f);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ORE_TYPE, (Object)0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(1, (Goal)new TemptGoal((PathfinderMob)this, 1.25, (Predicate)this.getGoodFood(), false));
        this.goalSelector.addGoal(2, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    private Ingredient getGoodFood() {
        if (this.goodFood == null) {
            this.computeGoodFood();
        }
        return this.goodFood;
    }

    private void computeGoodFood() {
        this.goodFood = Ingredient.of(ToretoiseModule.foods.stream().map(loc -> (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)loc))).filter(i -> i != Items.AIR).map(ItemStack::new));
    }

    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor world, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, SpawnGroupData spawnData) {
        this.popOre(true);
        return spawnData;
    }

    public boolean isPushedByFluid() {
        return false;
    }

    protected int decreaseAirSupply(int air) {
        return air;
    }

    public boolean canBreed() {
        return this.getOreType() == 0 && this.eatCooldown == 0;
    }

    @NotNull
    public SoundEvent getEatingSound(@NotNull ItemStack itemStackIn) {
        return this.eatCooldown == 0 ? QuarkSounds.ENTITY_TORETOISE_EAT : QuarkSounds.ENTITY_TORETOISE_EAT_SATIATED;
    }

    protected AABB makeBoundingBox() {
        AABB aabb = super.makeBoundingBox();
        double rheight = this.getOreType() == 0 ? 0.0 : 0.4;
        return new AABB(aabb.minX, aabb.minY, aabb.minZ, aabb.maxX, aabb.maxY + rheight, aabb.maxZ);
    }

    public void tick() {
        Level x2;
        super.tick();
        Entity riding = this.getVehicle();
        this.rideTime = riding != null ? ++this.rideTime : 0;
        if (this.eatCooldown > 0) {
            --this.eatCooldown;
        }
        if (this.angeryTicks > 0 && this.isAlive()) {
            --this.angeryTicks;
            if (this.onGround()) {
                int dangerRange = 3;
                double x2 = this.getX() + (double)(this.getBbWidth() / 2.0f);
                double y = this.getY();
                double z = this.getZ() + (double)(this.getBbWidth() / 2.0f);
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (this.angeryTicks == 3) {
                        this.playSound(QuarkSounds.ENTITY_TORETOISE_ANGRY, 1.0f, 0.2f);
                    } else if (this.angeryTicks == 0) {
                        serverLevel.sendParticles((ParticleOptions)ParticleTypes.CLOUD, x2, y, z, 200, (double)dangerRange, 0.5, (double)dangerRange, 0.0);
                        this.gameEvent((Holder)GameEvent.ENTITY_ACTION);
                    }
                }
                if (this.angeryTicks == 0) {
                    AABB hurtAabb = new AABB(x2 - (double)dangerRange, y - 1.0, z - (double)dangerRange, x2 + (double)dangerRange, y + 1.0, z + (double)dangerRange);
                    List hurtMeDaddy = this.level().getEntitiesOfClass(LivingEntity.class, hurtAabb, e -> !(e instanceof Toretoise));
                    Toretoise aggressor = this.lastAggressor == null ? this : this.lastAggressor;
                    DamageSource damageSource = this.damageSources().mobAttack((LivingEntity)aggressor);
                    for (LivingEntity e2 : hurtMeDaddy) {
                        DamageSource useSource = damageSource;
                        if (e2 == aggressor) {
                            useSource = this.damageSources().mobAttack((LivingEntity)this);
                        }
                        e2.hurt(useSource, (float)(4 + this.level().getDifficulty().ordinal()));
                    }
                }
            }
        }
        if ((x2 = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)x2;
            int ore = this.getOreType();
            if (ore != 0) {
                AABB ourBoundingBox = this.getBoundingBox();
                BlockPos min = BlockPos.containing((double)Math.round(ourBoundingBox.minX), (double)Math.round(ourBoundingBox.minY), (double)Math.round(ourBoundingBox.minZ));
                BlockPos max = BlockPos.containing((double)Math.round(ourBoundingBox.maxX), (double)Math.round(ourBoundingBox.maxY), (double)Math.round(ourBoundingBox.maxZ));
                block1: for (int ix = min.getX(); ix <= max.getX(); ++ix) {
                    for (int iy = min.getY(); iy <= max.getY(); ++iy) {
                        for (int iz = min.getZ(); iz <= max.getZ(); ++iz) {
                            BlockState pistonState;
                            PistonMovingBlockEntity piston;
                            BlockEntity tile;
                            BlockPos test = new BlockPos(ix, iy, iz);
                            BlockState state = this.level().getBlockState(test);
                            if (state.getBlock() != Blocks.MOVING_PISTON || !((tile = this.level().getBlockEntity(test)) instanceof PistonMovingBlockEntity) || !(piston = (PistonMovingBlockEntity)tile).isExtending() || !(pistonState = piston.getMovedState()).is(BREAKS_TORETOISE_ORE) || pistonState.hasProperty((Property)RodBlock.FACING) && pistonState.getValue((Property)RodBlock.FACING) != piston.getMovementDirection()) continue;
                            this.dropOre(ore, new LootParams.Builder(serverLevel).withParameter(LootContextParams.TOOL, (Object)new ItemStack((ItemLike)Items.IRON_PICKAXE)));
                            break block1;
                        }
                    }
                }
            }
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        Entity e = source.getDirectEntity();
        int ore = this.getOreType();
        if (e instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)e;
            ItemStack held = living.getMainHandItem();
            if (ore != 0 && held.getItem().canPerformAction(held, ItemAbilities.PICKAXE_DIG)) {
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (held.isDamageableItem() && e instanceof Player) {
                        Player player = (Player)e;
                        held.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                    }
                    LootParams.Builder lootBuilder = new LootParams.Builder(serverLevel).withParameter(LootContextParams.TOOL, (Object)held);
                    if (living instanceof Player) {
                        Player player = (Player)living;
                        lootBuilder.withLuck(player.getLuck());
                    }
                    this.dropOre(ore, lootBuilder);
                    if (living instanceof ServerPlayer) {
                        ServerPlayer sp = (ServerPlayer)living;
                        ToretoiseModule.mineToretoiseTrigger.trigger(sp);
                        if (this.isTamed) {
                            ToretoiseModule.mineFedToretoiseTrigger.trigger(sp);
                        }
                    }
                }
                return false;
            }
            if (this.angeryTicks == 0) {
                this.angeryTicks = 20;
                this.lastAggressor = living;
            }
        }
        return super.hurt(source, amount);
    }

    public void dropOre(int ore, LootParams.Builder lootContext) {
        lootContext.withParameter(LootContextParams.ORIGIN, (Object)this.position());
        BlockState dropState = null;
        switch (ore) {
            case 1: {
                dropState = Blocks.DEEPSLATE_COAL_ORE.defaultBlockState();
                break;
            }
            case 2: {
                dropState = Blocks.DEEPSLATE_IRON_ORE.defaultBlockState();
                break;
            }
            case 3: {
                dropState = Blocks.DEEPSLATE_REDSTONE_ORE.defaultBlockState();
                break;
            }
            case 4: {
                dropState = Blocks.DEEPSLATE_LAPIS_ORE.defaultBlockState();
                break;
            }
            case 5: {
                dropState = Blocks.DEEPSLATE_COPPER_ORE.defaultBlockState();
            }
        }
        if (dropState != null) {
            this.playSound(QuarkSounds.ENTITY_TORETOISE_HARVEST, 1.0f, 0.6f);
            this.gameEvent((Holder)GameEvent.ENTITY_INTERACT);
            List drops = dropState.getDrops(lootContext);
            for (ItemStack drop : drops) {
                this.spawnAtLocation(drop, 1.2f);
            }
        }
        this.entityData.set(ORE_TYPE, (Object)0);
        this.setBoundingBox(this.makeBoundingBox());
    }

    public void setInLove(Player player) {
        this.setInLoveTime(0);
    }

    public void setInLoveTime(int ticks) {
        if (this.level().isClientSide) {
            return;
        }
        this.playSound(this.eatCooldown == 0 ? QuarkSounds.ENTITY_TORETOISE_EAT : QuarkSounds.ENTITY_TORETOISE_EAT_SATIATED, 0.5f + 0.5f * (float)this.level().random.nextInt(2), (this.level().random.nextFloat() - this.level().random.nextFloat()) * 0.2f + 1.0f);
        this.heal(8.0f);
        if (!this.isTamed) {
            this.isTamed = true;
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.HEART, this.getX(), this.getY(), this.getZ(), 20, 0.5, 0.5, 0.5, 0.0);
            }
        } else if (this.eatCooldown == 0) {
            this.popOre(false);
        }
    }

    private void popOre(boolean natural) {
        if (!natural && ToretoiseModule.regrowChance == 0) {
            return;
        }
        if (this.getOreType() == 0 && (natural || this.level().random.nextInt(ToretoiseModule.regrowChance) == 0)) {
            int ore = this.random.nextInt(5) + 1;
            this.entityData.set(ORE_TYPE, (Object)ore);
            this.setBoundingBox(this.makeBoundingBox());
            if (!natural) {
                this.eatCooldown = ToretoiseModule.cooldownTicks;
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.CLOUD, this.getX(), this.getY() + 0.5, this.getZ(), 100, 0.6, 0.6, 0.6, 0.0);
                    this.playSound(QuarkSounds.ENTITY_TORETOISE_REGROW, 10.0f, 0.7f);
                }
            }
        }
    }

    public boolean isFood(@NotNull ItemStack stack) {
        return this.getGoodFood().test(stack);
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return !this.isTamed;
    }

    public static boolean spawnPredicate(EntityType<? extends Toretoise> type, ServerLevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource rand) {
        return world.getDifficulty() != Difficulty.PEACEFUL && pos.getY() <= ToretoiseModule.maxYLevel && MiscUtil.validSpawnLight((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)rand) && MiscUtil.validSpawnLocation(type, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos);
    }

    public boolean checkSpawnRules(@NotNull LevelAccessor world, @NotNull MobSpawnType reason) {
        BlockPos pos = BlockPos.containing((Position)this.position()).below();
        BlockState state = world.getBlockState(pos);
        if (!BlockUtils.isStoneBased((BlockState)state, (BlockGetter)world, (BlockPos)pos)) {
            return false;
        }
        return ToretoiseModule.dimensions.canSpawnHere(world);
    }

    public void jumpFromGround() {
    }

    public boolean causeFallDamage(float distance, float damageMultiplier, @NotNull DamageSource source) {
        return false;
    }

    protected float getWaterSlowDown() {
        return 0.9f;
    }

    public boolean canBeLeashed() {
        return false;
    }

    public float getVoicePitch() {
        return (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 0.6f;
    }

    protected SoundEvent getAmbientSound() {
        return QuarkSounds.ENTITY_TORETOISE_IDLE;
    }

    protected SoundEvent getHurtSound(@NotNull DamageSource damageSourceIn) {
        return QuarkSounds.ENTITY_TORETOISE_HURT;
    }

    protected SoundEvent getDeathSound() {
        return QuarkSounds.ENTITY_TORETOISE_DIE;
    }

    public int getOreType() {
        return (Integer)this.entityData.get(ORE_TYPE);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean(TAG_TAMED, this.isTamed);
        compound.putInt(TAG_ORE, this.getOreType());
        compound.putInt(TAG_EAT_COOLDOWN, this.eatCooldown);
        compound.putInt(TAG_ANGERY_TICKS, this.angeryTicks);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.isTamed = compound.getBoolean(TAG_TAMED);
        this.entityData.set(ORE_TYPE, (Object)compound.getInt(TAG_ORE));
        this.eatCooldown = compound.getInt(TAG_EAT_COOLDOWN);
        this.angeryTicks = compound.getInt(TAG_ANGERY_TICKS);
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 60.0).add(Attributes.MOVEMENT_SPEED, 0.08).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.STEP_HEIGHT, 1.0);
    }

    public Toretoise getBreedOffspring(@NotNull ServerLevel sworld, @NotNull AgeableMob otherParent) {
        Toretoise e = new Toretoise(ToretoiseModule.toretoiseType, this.level());
        e.kill();
        return e;
    }
}

