/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.magnetsystem;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.addons.oddities.block.MovingMagnetizedBlock;
import org.violetmoon.quark.addons.oddities.block.be.MagnetBlockEntity;
import org.violetmoon.quark.addons.oddities.capability.MagnetTracker;
import org.violetmoon.quark.addons.oddities.magnetsystem.DefaultMoveActions;
import org.violetmoon.quark.addons.oddities.module.MagnetsModule;
import org.violetmoon.quark.api.IMagnetMoveAction;
import org.violetmoon.quark.api.IMagnetTracker;
import org.violetmoon.zeta.api.ICollateralMover;
import org.violetmoon.zeta.event.play.ZRecipeCrawl;
import org.violetmoon.zeta.util.RegistryUtil;

public class MagnetSystem {
    private static final HashSet<Block> magnetizableBlocks = new HashSet();
    private static final HashSet<Item> magnetizableItems = new HashSet();
    private static final HashMap<Block, IMagnetMoveAction> BLOCK_MOVE_ACTIONS = new HashMap();

    public static IMagnetMoveAction getMoveAction(Block block) {
        if (block instanceof IMagnetMoveAction) {
            IMagnetMoveAction ma = (IMagnetMoveAction)block;
            return ma;
        }
        return BLOCK_MOVE_ACTIONS.get(block);
    }

    @Nullable
    public static IMagnetTracker getTracker(Level level) {
        return new MagnetTracker(level);
    }

    public static void tick(boolean start, Level level) {
        IMagnetTracker tracker = MagnetSystem.getTracker(level);
        if (tracker == null) {
            return;
        }
        if (!start) {
            for (BlockPos pos : tracker.getTrackedPositions()) {
                tracker.actOnForces(pos);
            }
        }
        tracker.clear();
    }

    public static void onRecipeReset() {
        magnetizableBlocks.clear();
    }

    public static void onDigest(ZRecipeCrawl.Digest digest) {
        digest.recursivelyFindCraftedItemsFromStrings(MagnetsModule.magneticDerivationList, MagnetsModule.magneticWhitelist, MagnetsModule.magneticBlacklist, i -> {
            if (i instanceof BlockItem) {
                BlockItem bi = (BlockItem)i;
                magnetizableBlocks.add(bi.getBlock());
            }
            magnetizableItems.add((Item)i);
        });
        List magneticBlockWhitelist = RegistryUtil.massRegistryGet(MagnetsModule.magneticWhitelist, (Registry)BuiltInRegistries.BLOCK);
        List magneticBlockBlacklist = RegistryUtil.massRegistryGet(MagnetsModule.magneticBlacklist, (Registry)BuiltInRegistries.BLOCK);
        magnetizableBlocks.addAll(magneticBlockWhitelist);
        magneticBlockBlacklist.forEach(magnetizableBlocks::remove);
        List magneticItemWhitelist = RegistryUtil.massRegistryGet(MagnetsModule.magneticWhitelist, (Registry)BuiltInRegistries.ITEM);
        List magneticItemBlacklist = RegistryUtil.massRegistryGet(MagnetsModule.magneticBlacklist, (Registry)BuiltInRegistries.ITEM);
        magnetizableItems.addAll(magneticItemWhitelist);
        magneticItemBlacklist.forEach(magnetizableItems::remove);
    }

    public static void applyForce(Level world, BlockPos pos, int magnitude, boolean pushing, Direction dir, int distance, BlockPos origin) {
        IMagnetTracker tracker = MagnetSystem.getTracker(world);
        if (tracker != null) {
            tracker.applyForce(pos, magnitude, pushing, dir, distance, origin);
        }
    }

    public static ICollateralMover.MoveResult getPushAction(MagnetBlockEntity magnet, BlockPos pos, BlockState state, Direction moveDir) {
        if (state.getBlock() instanceof MovingMagnetizedBlock) {
            return ICollateralMover.MoveResult.SKIP;
        }
        Level world = magnet.getLevel();
        if (world != null && MagnetSystem.canBlockBeMagneticallyMoved(state, pos, world, moveDir, magnet)) {
            ICollateralMover cm;
            BlockPos frontPos = pos.relative(moveDir);
            BlockState frontState = world.getBlockState(frontPos);
            Block block = state.getBlock();
            if (block instanceof ICollateralMover && (cm = (ICollateralMover)block).isCollateralMover(world, magnet.getBlockPos(), moveDir, pos)) {
                if (MagnetsModule.usePistonLogic && !PistonBaseBlock.isPushable((BlockState)frontState, (Level)world, (BlockPos)frontPos, (Direction)moveDir, (boolean)true, (Direction)moveDir.getOpposite())) {
                    return ICollateralMover.MoveResult.PREVENT;
                }
                return cm.getCollateralMovement(world, magnet.getBlockPos(), moveDir, moveDir, pos);
            }
            if (frontState.isAir()) {
                return ICollateralMover.MoveResult.MOVE;
            }
            if (frontState.getPistonPushReaction() == PushReaction.DESTROY) {
                return ICollateralMover.MoveResult.BREAK;
            }
        }
        return ICollateralMover.MoveResult.SKIP;
    }

    public static boolean isItemMagnetic(Item item) {
        if (item == Items.AIR) {
            return false;
        }
        return magnetizableItems.contains(item);
    }

    public static boolean isBlockMagnetic(BlockState state) {
        Block block = state.getBlock();
        if (block == MagnetsModule.magnet || state.isAir()) {
            return false;
        }
        return magnetizableBlocks.contains(block) || BLOCK_MOVE_ACTIONS.containsKey(block);
    }

    public static boolean canBlockBeMagneticallyMoved(BlockState state, BlockPos pos, Level level, Direction moveDir, BlockEntity magnet) {
        Block block = state.getBlock();
        if (MagnetsModule.usePistonLogic && !PistonBaseBlock.isPushable((BlockState)state, (Level)level, (BlockPos)pos, (Direction)moveDir, (boolean)true, (Direction)moveDir.getOpposite())) {
            return false;
        }
        if ((block == Blocks.PISTON || block == Blocks.STICKY_PISTON) && ((Boolean)state.getValue((Property)PistonBaseBlock.EXTENDED)).booleanValue()) {
            return false;
        }
        if (block == MagnetsModule.magnet || state.isAir()) {
            return false;
        }
        IMagnetMoveAction action = MagnetSystem.getMoveAction(block);
        if (action != null) {
            return action.canMagnetMove(level, pos, moveDir, state, magnet);
        }
        return magnetizableBlocks.contains(block);
    }

    static {
        DefaultMoveActions.addActions(BLOCK_MOVE_ACTIONS);
    }
}

