/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.datagen;

import java.util.ArrayList;
import java.util.Set;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LimitCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.neoforge.common.Tags;
import org.violetmoon.quark.content.automation.module.ChuteModule;
import org.violetmoon.quark.content.building.module.CelebratoryLampsModule;
import org.violetmoon.quark.content.building.module.CompressedBlocksModule;
import org.violetmoon.quark.content.building.module.FramedGlassModule;
import org.violetmoon.quark.content.building.module.GoldBarsModule;
import org.violetmoon.quark.content.building.module.GrateModule;
import org.violetmoon.quark.content.building.module.HedgesModule;
import org.violetmoon.quark.content.building.module.HollowLogsModule;
import org.violetmoon.quark.content.building.module.JapanesePaletteModule;
import org.violetmoon.quark.content.building.module.LeafCarpetModule;
import org.violetmoon.quark.content.building.module.MidoriModule;
import org.violetmoon.quark.content.building.module.MoreMudBlocksModule;
import org.violetmoon.quark.content.building.module.MorePottedPlantsModule;
import org.violetmoon.quark.content.building.module.NetherBrickFenceGateModule;
import org.violetmoon.quark.content.building.module.RainbowLampsModule;
import org.violetmoon.quark.content.building.module.RawMetalBricksModule;
import org.violetmoon.quark.content.building.module.RopeModule;
import org.violetmoon.quark.content.building.module.ShearVinesModule;
import org.violetmoon.quark.content.building.module.ShinglesModule;
import org.violetmoon.quark.content.building.module.StoolsModule;
import org.violetmoon.quark.content.building.module.SturdyStoneModule;
import org.violetmoon.quark.content.building.module.ThatchModule;
import org.violetmoon.quark.content.building.module.VariantBookshelvesModule;
import org.violetmoon.quark.content.building.module.VariantChestsModule;
import org.violetmoon.quark.content.building.module.VariantFurnacesModule;
import org.violetmoon.quark.content.building.module.VariantLaddersModule;
import org.violetmoon.quark.content.building.module.VerticalPlanksModule;
import org.violetmoon.quark.content.building.module.VerticalSlabsModule;
import org.violetmoon.quark.content.building.module.WoodenPostsModule;
import org.violetmoon.quark.content.tools.module.BottledCloudModule;
import org.violetmoon.quark.content.tweaks.module.GlassShardModule;
import org.violetmoon.quark.content.world.module.AncientWoodModule;
import org.violetmoon.quark.content.world.module.AzaleaWoodModule;
import org.violetmoon.quark.content.world.module.BlossomTreesModule;
import org.violetmoon.quark.content.world.module.ChorusVegetationModule;
import org.violetmoon.quark.content.world.module.CorundumModule;
import org.violetmoon.quark.content.world.module.GlimmeringWealdModule;
import org.violetmoon.quark.content.world.module.MonsterBoxModule;
import org.violetmoon.quark.content.world.module.NewStoneTypesModule;
import org.violetmoon.quark.content.world.module.SpiralSpiresModule;

public class QuarkBlockLootTableProvider
extends BlockLootSubProvider {
    private static final float[] LEAVES_STICK_CHANCES = new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f};
    private static final float[] LEAVES_BONUS_CHANCES = new float[]{0.005f, 0.0055555557f, 0.00625f, 0.008333334f, 0.025f};
    protected static final LootItemCondition.Builder HAS_SHEARS = MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(Tags.Items.TOOLS_SHEAR));

    protected QuarkBlockLootTableProvider(HolderLookup.Provider holderLookupProvider) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), holderLookupProvider);
    }

    protected void generate() {
        this.dropSelf(ChuteModule.chute);
        this.dropSelf(CelebratoryLampsModule.stone_lamp);
        this.dropSelf(CelebratoryLampsModule.stone_brick_lamp);
        for (Block block : CompressedBlocksModule.blocks) {
            this.dropSelf(block);
        }
        for (Block block : FramedGlassModule.glassBlocks) {
            this.dropSelf(block);
        }
        this.dropSelf(GoldBarsModule.gold_bars);
        for (Block block : HedgesModule.hedges) {
            this.dropSelf(block);
        }
        for (Block block : HollowLogsModule.hollowLogs) {
            this.dropSelf(block);
        }
        this.dropSelf(GrateModule.grate);
        for (Block block : JapanesePaletteModule.blocks) {
            this.dropSelf(block);
        }
        for (Block block : LeafCarpetModule.carpets) {
            this.dropSelf(block);
        }
        for (Block block : MidoriModule.blocks) {
            this.dropSelf(block);
        }
        for (Block block : MoreMudBlocksModule.blocks) {
            this.dropSelf(block);
        }
        for (Block block : MorePottedPlantsModule.pottedPlants) {
            this.createPotFlowerItemTable(MorePottedPlantsModule.getItemLikeFromBlock(block));
        }
        this.dropSelf(NetherBrickFenceGateModule.netherBrickFenceGate);
        for (Block block : RainbowLampsModule.lamps) {
            this.dropSelf(block);
        }
        for (Block block : RawMetalBricksModule.blocks) {
            this.dropSelf(block);
        }
        this.dropSelf(RopeModule.rope);
        this.add(ShearVinesModule.cut_vine, QuarkBlockLootTableProvider.noDrop());
        for (Block block : ShinglesModule.blocks) {
            this.dropSelf(block);
        }
        for (Block block : StoolsModule.stools) {
            this.dropSelf(block);
        }
        this.dropSelf(SturdyStoneModule.sturdy_stone);
        this.dropSelf((Block)ThatchModule.thatch);
        for (Block block : VariantBookshelvesModule.variantBookshelves) {
            this.createSingleItemTableWithSilkTouch(block, (ItemLike)Items.BOOK, (NumberProvider)ConstantValue.exactly((float)3.0f));
        }
        for (Block block : VariantChestsModule.regularChests) {
            this.dropSelf(block);
        }
        for (Block block : VariantChestsModule.trappedChests) {
            this.dropSelf(block);
        }
        this.dropSelf(VariantFurnacesModule.deepslateFurnace);
        this.dropSelf(VariantFurnacesModule.blackstoneFurnace);
        for (Block block : VariantLaddersModule.variantLadders) {
            this.dropSelf(block);
        }
        for (Block block : VerticalPlanksModule.blocks) {
            this.dropSelf(block);
        }
        for (Block block : VerticalSlabsModule.blocks) {
            this.createSlabItemTable(block);
        }
        for (Block block : WoodenPostsModule.blocks) {
            this.dropSelf(block);
        }
        this.add(BottledCloudModule.cloud, QuarkBlockLootTableProvider.noDrop());
        this.dropDirtyShards((Block)GlassShardModule.dirtyGlass);
        this.dropWhenSilkTouch((Block)GlassShardModule.dirtyGlassPane);
        for (Block block : AncientWoodModule.woodSet.allBlocks()) {
            this.dropSelf(block);
        }
        this.createLeavesDropWithBonusLikeHowOakLeavesDropApples(AncientWoodModule.ancient_leaves, AncientWoodModule.ancient_sapling, AncientWoodModule.ancient_fruit);
        this.dropSelf(AncientWoodModule.ancient_sapling);
        this.createShearsDrops(ChorusVegetationModule.chorus_weeds);
        this.createShearsDrops(ChorusVegetationModule.chorus_twist);
        for (Block block : CorundumModule.clusters) {
            this.dropSelf(block);
        }
        for (Block block : CorundumModule.waxedCrystals) {
            this.dropSelf(block);
        }
        for (Block block : CorundumModule.clusters) {
            this.dropSelf(block);
        }
        for (Block block : CorundumModule.panes) {
            this.dropSelf(block);
        }
        this.dropSelf(GlimmeringWealdModule.glow_shroom);
        this.dropSelf(GlimmeringWealdModule.glow_lichen_growth);
        this.dropWhenSilkTouch(GlimmeringWealdModule.glow_shroom_stem);
        this.dropSelf(GlimmeringWealdModule.glow_shroom_ring);
        this.add(MonsterBoxModule.monster_box, QuarkBlockLootTableProvider.noDrop());
        this.dropSelf(NewStoneTypesModule.limestoneBlock);
        this.dropSelf(NewStoneTypesModule.jasperBlock);
        this.dropSelf(NewStoneTypesModule.shaleBlock);
        this.dropSelf(NewStoneTypesModule.myaliteBlock);
        for (Block block : NewStoneTypesModule.polishedBlocks.values()) {
            this.dropSelf(block);
        }
        this.dropSelf(SpiralSpiresModule.myalite_crystal);
        this.dropSelf(SpiralSpiresModule.dusky_myalite);
        for (Block block : BlossomTreesModule.woodSet.allBlocks()) {
            this.dropSelf(block);
        }
        for (BlossomTreesModule.BlossomTree blossomTree : BlossomTreesModule.blossomTrees) {
            this.createLeavesDrops((Block)blossomTree.leaves, (Block)blossomTree.sapling, new float[0]);
            this.dropSelf((Block)blossomTree.sapling);
        }
    }

    protected Iterable<Block> getKnownBlocks() {
        ArrayList<Block> ret = new ArrayList<Block>();
        ret.add(ChuteModule.chute);
        ret.add(CelebratoryLampsModule.stone_lamp);
        ret.add(CelebratoryLampsModule.stone_brick_lamp);
        ret.addAll(CompressedBlocksModule.blocks);
        ret.addAll(FramedGlassModule.glassBlocks);
        ret.add(GoldBarsModule.gold_bars);
        ret.addAll(HedgesModule.hedges);
        ret.addAll(HollowLogsModule.hollowLogs);
        ret.add(GrateModule.grate);
        ret.addAll(JapanesePaletteModule.blocks);
        ret.addAll(LeafCarpetModule.carpets);
        ret.addAll(MidoriModule.blocks);
        ret.addAll(MoreMudBlocksModule.blocks);
        ret.addAll(MorePottedPlantsModule.pottedPlants);
        ret.add(NetherBrickFenceGateModule.netherBrickFenceGate);
        ret.addAll(RainbowLampsModule.lamps);
        ret.addAll(RawMetalBricksModule.blocks);
        ret.add(RopeModule.rope);
        ret.add(ShearVinesModule.cut_vine);
        ret.addAll(ShinglesModule.blocks);
        ret.addAll(StoolsModule.stools);
        ret.add(SturdyStoneModule.sturdy_stone);
        ret.add((Block)ThatchModule.thatch);
        ret.addAll(VariantBookshelvesModule.variantBookshelves);
        ret.addAll(VariantChestsModule.regularChests);
        ret.addAll(VariantChestsModule.trappedChests);
        ret.add(VariantFurnacesModule.deepslateFurnace);
        ret.add(VariantFurnacesModule.blackstoneFurnace);
        ret.addAll(VariantLaddersModule.variantLadders);
        ret.addAll(VerticalPlanksModule.blocks);
        ret.addAll(VerticalSlabsModule.blocks);
        ret.addAll(WoodenPostsModule.blocks);
        ret.add(BottledCloudModule.cloud);
        ret.add((Block)GlassShardModule.dirtyGlass);
        ret.add((Block)GlassShardModule.dirtyGlassPane);
        ret.addAll(AncientWoodModule.woodSet.allBlocks());
        ret.add(AncientWoodModule.ancient_leaves);
        ret.addAll(AzaleaWoodModule.woodSet.allBlocks());
        ret.add(ChorusVegetationModule.chorus_weeds);
        ret.add(ChorusVegetationModule.chorus_twist);
        ret.addAll(CorundumModule.crystals);
        ret.addAll(CorundumModule.waxedCrystals);
        ret.addAll(CorundumModule.clusters);
        ret.addAll(CorundumModule.panes);
        ret.add(GlimmeringWealdModule.glow_shroom);
        ret.add(GlimmeringWealdModule.glow_lichen_growth);
        ret.add(GlimmeringWealdModule.glow_shroom_block);
        ret.add(GlimmeringWealdModule.glow_shroom_stem);
        ret.add(GlimmeringWealdModule.glow_shroom_ring);
        ret.add(MonsterBoxModule.monster_box);
        ret.add(NewStoneTypesModule.limestoneBlock);
        ret.add(NewStoneTypesModule.jasperBlock);
        ret.add(NewStoneTypesModule.shaleBlock);
        ret.add(NewStoneTypesModule.myaliteBlock);
        ret.addAll(NewStoneTypesModule.polishedBlocks.values());
        ret.add(SpiralSpiresModule.myalite_crystal);
        ret.add(SpiralSpiresModule.dusky_myalite);
        ret.addAll(BlossomTreesModule.woodSet.allBlocks());
        ret.addAll(BlossomTreesModule.blossomTrees.stream().map(blossomTree -> blossomTree.leaves).toList());
        ret.addAll(BlossomTreesModule.blossomTrees.stream().map(blossomTree -> blossomTree.sapling).toList());
        return ret;
    }

    protected LootTable.Builder createLeavesDrops(Block p_250088_, Block p_250731_, float ... p_248949_) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createSilkTouchOrShearsDispatchTable(p_250088_, ((LootPoolSingletonContainer.Builder)this.applyExplosionCondition((ItemLike)p_250088_, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)p_250731_))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float[])p_248949_))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(this.checkNotShearsOrSilk()).add(((LootPoolSingletonContainer.Builder)this.applyExplosionDecay((ItemLike)p_250088_, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float[])LEAVES_STICK_CHANCES))));
    }

    protected LootTable.Builder createShearsDispatchTable(Block p_252195_, LootPoolEntryContainer.Builder<?> p_250102_) {
        return QuarkBlockLootTableProvider.createSelfDropDispatchTable((Block)p_252195_, (LootItemCondition.Builder)HAS_SHEARS, p_250102_);
    }

    protected LootTable.Builder dropDirtyShards(Block block) {
        System.out.println("GENERATING DIRTY SHARDS");
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createSilkTouchDispatchTable(block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)GlassShardModule.dirtyShard).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE))).apply((LootItemFunction.Builder)LimitCount.limitCount((IntRange)IntRange.range((int)1, (int)4)))));
    }

    protected LootTable.Builder createShearsDrops(Block block) {
        return this.createShearsDispatchTable(block, (LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)block.asItem()));
    }

    protected LootTable.Builder createLeavesDropWithBonusLikeHowOakLeavesDropApples(Block p_249535_, Block p_251505_, Item bonus) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createLeavesDrops(p_249535_, p_251505_, new float[0]).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(this.checkNotShearsOrSilk()).add(((LootPoolSingletonContainer.Builder)this.applyExplosionCondition((ItemLike)p_249535_, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)bonus))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float[])LEAVES_BONUS_CHANCES))));
    }

    private LootItemCondition.Builder checkNotShearsOrSilk() {
        return this.checkShearsOrSilk().invert();
    }

    private LootItemCondition.Builder checkShearsOrSilk() {
        return HAS_SHEARS.or(super.hasSilkTouch());
    }
}

