/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tweaks.module;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.GrowingPlantBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.api.event.SimpleHarvestEvent;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.network.message.HarvestMessage;
import org.violetmoon.quark.content.tweaks.module.HoeHarvestingModule;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZCommonSetup;
import org.violetmoon.zeta.event.load.ZConfigChanged;
import org.violetmoon.zeta.event.play.entity.player.ZRightClickBlock;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.MiscUtil;

@ZetaLoadModule(category="tweaks")
public class SimpleHarvestModule
extends ZetaModule {
    @Config(description="Can players harvest crops with empty hand clicks?")
    public static boolean emptyHandHarvest = true;
    @Config(description="Does harvesting crops with a hoe cost durability?")
    public static boolean harvestingCostsDurability = false;
    @Config(description="Should Quark look for(nonvanilla) crops, and handle them?")
    public static boolean doHarvestingSearch = true;
    @Config(description="Should villagers use simple harvest instead of breaking crops?")
    public static boolean villagersUseSimpleHarvest = true;
    @Config(description="Which crops can be harvested?\nFormat is: \"harvestState[,afterHarvest]\", i.e. \"minecraft:wheat[age=7]\" or \"minecraft:cocoa[age=2,facing=north],minecraft:cocoa[age=0,facing=north]\"")
    public static List<String> harvestableBlocks = Lists.newArrayList((Object[])new String[]{"minecraft:wheat[age=7]", "minecraft:carrots[age=7]", "minecraft:potatoes[age=7]", "minecraft:beetroots[age=3]", "minecraft:nether_wart[age=3]", "minecraft:cocoa[age=2,facing=north],minecraft:cocoa[age=0,facing=north]", "minecraft:cocoa[age=2,facing=south],minecraft:cocoa[age=0,facing=south]", "minecraft:cocoa[age=2,facing=east],minecraft:cocoa[age=0,facing=east]", "minecraft:cocoa[age=2,facing=west],minecraft:cocoa[age=0,facing=west]"});
    @Config(description="Which blocks should right click harvesting simulate a click on instead of breaking?\nThis is for blocks like sweet berry bushes, which have right click harvesting built in.")
    public static List<String> rightClickableBlocks = Lists.newArrayList((Object[])new String[]{"minecraft:sweet_berry_bush", "minecraft:cave_vines"});
    public static final Map<BlockState, BlockState> crops = Maps.newHashMap();
    private static final Set<Block> cropBlocks = Sets.newHashSet();
    public static final Set<Block> rightClickCrops = Sets.newHashSet();
    public static TagKey<Block> simpleHarvestBlacklistedTag;
    public static boolean staticEnabled;
    private boolean isHarvesting = false;

    @LoadEvent
    public void setup(ZCommonSetup event) {
        simpleHarvestBlacklistedTag = Quark.asTagKey(Registries.BLOCK, "simple_harvest_blacklisted");
    }

    @LoadEvent
    public void configChanged(ZConfigChanged event) {
        crops.clear();
        cropBlocks.clear();
        rightClickCrops.clear();
        staticEnabled = this.isEnabled();
        if (doHarvestingSearch) {
            for (Block b : BuiltInRegistries.BLOCK) {
                if (this.isVanilla(b)) continue;
                if (b instanceof CropBlock) {
                    CropBlock c = (CropBlock)b;
                    crops.put(c.getStateForAge(c.getMaxAge()), c.defaultBlockState());
                    continue;
                }
                if (!(b instanceof BushBlock) && !(b instanceof GrowingPlantBlock) || !(b instanceof BonemealableBlock)) continue;
                rightClickCrops.add(b);
            }
        }
        for (String harvestKey : harvestableBlocks) {
            String[] split = this.tokenize(harvestKey);
            BlockState initial = MiscUtil.fromString((String)split[0]);
            BlockState result = split.length > 1 ? MiscUtil.fromString((String)split[1]) : initial.getBlock().defaultBlockState();
            if (initial.getBlock() == Blocks.AIR) continue;
            crops.put(initial, result);
        }
        for (String blockName : rightClickableBlocks) {
            Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)blockName));
            if (block == Blocks.AIR) continue;
            rightClickCrops.add(block);
        }
        crops.values().forEach(bl -> cropBlocks.add(bl.getBlock()));
    }

    private String[] tokenize(String harvestKey) {
        boolean inBracket = false;
        for (int i = 0; i < harvestKey.length(); ++i) {
            char charAt = harvestKey.charAt(i);
            if (charAt == '[') {
                inBracket = true;
                continue;
            }
            if (charAt == ']') {
                inBracket = false;
                continue;
            }
            if (charAt != ',' || inBracket) continue;
            return new String[]{harvestKey.substring(0, i), harvestKey.substring(i + 1)};
        }
        return new String[]{harvestKey};
    }

    private boolean isVanilla(Block entry) {
        ResourceLocation loc = BuiltInRegistries.BLOCK.getKey((Object)entry);
        return loc.getNamespace().equals("minecraft");
    }

    private static boolean harvestAndReplant(Level level, BlockPos pos, BlockState inWorld, @Nullable LivingEntity entity, @Nullable InteractionHand hand) {
        BlockState newBlock = crops.get(inWorld);
        if (newBlock == null) {
            return false;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ItemStack copy = entity == null || hand == null ? new ItemStack((ItemLike)Items.STICK) : entity.getItemInHand(hand).copy();
            MutableBoolean hasTaken = new MutableBoolean(false);
            Item blockItem = inWorld.getBlock().asItem();
            Block.getDrops((BlockState)inWorld, (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)level.getBlockEntity(pos), (Entity)entity, (ItemStack)copy).forEach(stack -> {
                if (stack.getItem() == blockItem && !hasTaken.getValue().booleanValue()) {
                    stack.shrink(1);
                    hasTaken.setValue(true);
                }
                if (!stack.isEmpty()) {
                    Block.popResource((Level)level, (BlockPos)pos, (ItemStack)stack);
                }
            });
            boolean dropXp = entity instanceof Player;
            inWorld.spawnAfterBreak(serverLevel, pos, copy, dropXp);
            level.levelEvent(2001, pos, Block.getId((BlockState)newBlock));
            level.setBlockAndUpdate(pos, newBlock);
            level.gameEvent((Holder)GameEvent.BLOCK_DESTROY, pos, GameEvent.Context.of((Entity)entity, (BlockState)inWorld));
        }
        return true;
    }

    @PlayEvent
    public void onClick(ZRightClickBlock event) {
        if (this.isHarvesting) {
            return;
        }
        this.isHarvesting = true;
        if (SimpleHarvestModule.click(event.getPlayer(), event.getHand(), event.getPos(), event.getHitVec())) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.sidedSuccess((boolean)event.getLevel().isClientSide));
        }
        this.isHarvesting = false;
    }

    public static boolean tryHarvestOrClickCrop(Level level, BlockPos pos, @Nullable LivingEntity entity, @Nullable InteractionHand hand, boolean canRightClick) {
        Player p;
        if (entity instanceof Player && !level.mayInteract(p = (Player)entity, pos)) {
            return false;
        }
        BlockState worldBlock = level.getBlockState(pos);
        SimpleHarvestEvent.ActionType action = SimpleHarvestModule.getActionForBlock(worldBlock, canRightClick);
        if (action != SimpleHarvestEvent.ActionType.NONE) {
            SimpleHarvestEvent event = new SimpleHarvestEvent(worldBlock, pos, level, hand, (Entity)entity, action);
            NeoForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                return false;
            }
            BlockPos newPos = event.getTargetPos();
            if (newPos != pos) {
                worldBlock = level.getBlockState(newPos);
            }
            if ((action = event.getAction()) == SimpleHarvestEvent.ActionType.HARVEST) {
                if (entity instanceof Player) {
                    Player p2 = (Player)entity;
                    return false;
                }
                return SimpleHarvestModule.harvestAndReplant(level, pos, worldBlock, entity, hand);
            }
            if (action == SimpleHarvestEvent.ActionType.CLICK && entity instanceof Player) {
                Player p3 = (Player)entity;
                BlockHitResult hitResult = new BlockHitResult(Vec3.atCenterOf((Vec3i)pos), Direction.UP, pos, true);
                if (hand == null) {
                    hand = InteractionHand.MAIN_HAND;
                }
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    return player.gameMode.useItemOn(player, player.level(), player.getItemInHand(hand), hand, hitResult).consumesAction();
                }
                return Quark.proxy.clientUseItem(p3, level, hand, hitResult).consumesAction();
            }
        }
        return false;
    }

    private static SimpleHarvestEvent.ActionType getActionForBlock(BlockState state, boolean closeEnoughToRightClick) {
        if (state.is(simpleHarvestBlacklistedTag)) {
            return SimpleHarvestEvent.ActionType.NONE;
        }
        if (closeEnoughToRightClick && rightClickCrops.contains(state.getBlock())) {
            return SimpleHarvestEvent.ActionType.CLICK;
        }
        if (crops.containsKey(state)) {
            return SimpleHarvestEvent.ActionType.HARVEST;
        }
        return SimpleHarvestEvent.ActionType.NONE;
    }

    public static boolean click(Player player, InteractionHand hand, BlockPos pos, BlockHitResult pick) {
        if (player == null || hand == null || player.isSpectator()) {
            return false;
        }
        if (pick.getType() != HitResult.Type.BLOCK || !pick.getBlockPos().equals((Object)pos)) {
            return false;
        }
        Level level = player.level();
        BlockState stateAt = level.getBlockState(pos);
        BlockState modifiedState = Quark.ZETA.blockExtensions.get(stateAt).getToolModifiedStateZeta(stateAt, new UseOnContext(player, hand, pick), ItemAbility.get((String)"hoe_till"), true);
        if (modifiedState != null) {
            return false;
        }
        ItemStack inHand = player.getItemInHand(hand);
        boolean isHoe = HoeHarvestingModule.isHoe(inHand);
        if (!emptyHandHarvest && !isHoe) {
            return false;
        }
        BlockState stateAbove = level.getBlockState(pos.above());
        if (isHoe && SimpleHarvestModule.getActionForBlock(stateAt, true) == SimpleHarvestEvent.ActionType.NONE && SimpleHarvestModule.getActionForBlock(stateAbove, true) == SimpleHarvestEvent.ActionType.NONE) {
            return false;
        }
        int range = HoeHarvestingModule.getRange(inHand);
        boolean hasHarvested = false;
        for (int x = 1 - range; x < range; ++x) {
            for (int z = 1 - range; z < range; ++z) {
                BlockPos shiftPos = pos.offset(x, 0, z);
                if (!SimpleHarvestModule.tryHarvestOrClickCrop(level, shiftPos, (LivingEntity)player, hand, range > 1)) {
                    if (!SimpleHarvestModule.tryHarvestOrClickCrop(level, shiftPos = shiftPos.above(), (LivingEntity)player, hand, range > 1)) continue;
                    hasHarvested = true;
                    continue;
                }
                hasHarvested = true;
            }
        }
        if (!hasHarvested) {
            return false;
        }
        if (level.isClientSide) {
            if (inHand.isEmpty()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new HarvestMessage(pos, hand), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        } else if (harvestingCostsDurability && isHoe) {
            inHand.hurtAndBreak(1, (LivingEntity)player, Player.getSlotForHand((InteractionHand)InteractionHand.MAIN_HAND));
        }
        return true;
    }
}

