/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.addons.oddities.block.be.MatrixEnchantingTableBlockEntity;
import org.violetmoon.quark.addons.oddities.client.screen.MatrixEnchantingPieceList;
import org.violetmoon.quark.addons.oddities.client.screen.MatrixEnchantingPlusButton;
import org.violetmoon.quark.addons.oddities.inventory.EnchantmentMatrix;
import org.violetmoon.quark.addons.oddities.inventory.MatrixEnchantingMenu;
import org.violetmoon.quark.addons.oddities.module.MatrixEnchantingModule;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.client.handler.ClientUtil;
import org.violetmoon.quark.base.network.message.oddities.MatrixEnchanterOperationMessage;
import org.violetmoon.quark.catnip.animation.AnimationTickHolder;

public class MatrixEnchantingScreen
extends AbstractContainerScreen<MatrixEnchantingMenu> {
    public static final ResourceLocation BACKGROUND = Quark.asResource("textures/misc/matrix_enchanting.png");
    protected final Inventory playerInv;
    protected final MatrixEnchantingTableBlockEntity enchanter;
    protected Button plusButton;
    protected MatrixEnchantingPieceList pieceList;
    protected EnchantmentMatrix.Piece hoveredPiece;
    protected int selectedPiece = -1;
    protected int gridHoverX;
    protected int gridHoverY;
    protected List<Integer> listPieces = null;

    public MatrixEnchantingScreen(MatrixEnchantingMenu container, Inventory inventory, Component component) {
        super((AbstractContainerMenu)container, inventory, component);
        this.playerInv = inventory;
        this.enchanter = container.enchanter;
    }

    public void init() {
        super.init();
        this.selectedPiece = -1;
        this.plusButton = new MatrixEnchantingPlusButton(this.leftPos + 86, this.topPos + 63, this::add);
        this.addRenderableWidget((GuiEventListener)this.plusButton);
        this.pieceList = new MatrixEnchantingPieceList(this, 28, 64, this.topPos + 11, this.topPos + 75, 22);
        this.pieceList.setX(this.leftPos + 139);
        this.addRenderableWidget((GuiEventListener)this.pieceList);
        this.updateButtonStatus();
        this.pieceList.refresh();
        this.enchanter.updateEnchantPower();
    }

    public void containerTick() {
        super.containerTick();
        this.updateButtonStatus();
        if (this.enchanter.matrix == null) {
            this.selectedPiece = -1;
            this.pieceList.refresh();
        }
        if (this.enchanter.clientMatrixDirty) {
            this.pieceList.refresh();
            this.enchanter.clientMatrixDirty = false;
        }
    }

    protected void renderBg(@NotNull GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        Minecraft mc = this.getMinecraft();
        PoseStack pose = guiGraphics.pose();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = this.leftPos;
        int j = this.topPos;
        guiGraphics.blit(BACKGROUND, i, j, 0, 0, this.imageWidth, this.imageHeight);
        if (this.enchanter.charge > 0 && MatrixEnchantingModule.chargePerLapis > 0) {
            int maxHeight = 18;
            int barHeight = (int)((float)this.enchanter.charge / (float)MatrixEnchantingModule.chargePerLapis * (float)maxHeight);
            guiGraphics.blit(BACKGROUND, i + 7, j + 32 + maxHeight - barHeight, 50, 176 + maxHeight - barHeight, 4, barHeight);
        }
        this.pieceList.render(guiGraphics, mouseX, mouseY, partialTicks);
        boolean showCost = this.enchanter.matrix != null && this.enchanter.matrix.canGeneratePiece(this.enchanter.influences, this.enchanter.bookshelfPower, this.enchanter.enchantability) && !mc.player.getAbilities().instabuild;
        Object text = "" + this.enchanter.bookshelfPower;
        int x = i + 50;
        int y = j + 55;
        if (this.enchanter.bookshelfPower > 0) {
            pose.pushPose();
            guiGraphics.renderItem(new ItemStack((ItemLike)Items.BOOK), x, y);
            pose.translate(0.0f, 0.0f, 1000.0f);
            this.drawBorderedText(guiGraphics, (String)text, (x -= this.font.width((String)text) / 2) + 3, y + 6, 0xC8FF8F);
            pose.popPose();
        }
        if (showCost) {
            int xpCost = this.enchanter.matrix.getNewPiecePrice();
            int xpMin = this.enchanter.matrix.getMinXpLevel(this.enchanter.bookshelfPower);
            boolean has = this.enchanter.matrix.validateXp((Player)mc.player, this.enchanter.bookshelfPower);
            x = i + 71;
            y = j + 56;
            text = String.valueOf(xpCost);
            guiGraphics.blit(BACKGROUND, x, y, 0, this.imageHeight, 10, 10);
            if (!has && mc.player.experienceLevel < xpMin) {
                text = I18n.get((String)"quark.gui.enchanting.min", (Object[])new Object[]{xpMin});
                x += 4;
            }
            this.drawBorderedText(guiGraphics, (String)text, (x -= this.font.width((String)text) / 2) + 2, y + 5, has ? 0xC8FF8F : 0xFF8F8F);
        }
    }

    private void drawBorderedText(GuiGraphics guiGraphics, String text, int x, int y, int color) {
        guiGraphics.drawString(this.font, text, x - 1, y, 0, false);
        guiGraphics.drawString(this.font, text, x + 1, y, 0, false);
        guiGraphics.drawString(this.font, text, x, y + 1, 0, false);
        guiGraphics.drawString(this.font, text, x, y - 1, 0, false);
        guiGraphics.drawString(this.font, text, x, y, color, false);
    }

    protected void renderLabels(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int color = ClientUtil.getGuiTextColor("matrix_enchanting");
        guiGraphics.drawString(this.font, this.enchanter.getDisplayName().getString(), 12, 5, color, false);
        guiGraphics.drawString(this.font, this.playerInv.getDisplayName().getString(), 8, this.imageHeight - 96 + 2, color, false);
        if (this.enchanter.matrix != null) {
            boolean needsRefresh = this.listPieces == null;
            this.listPieces = this.enchanter.matrix.benchedPieces;
            if (needsRefresh) {
                this.pieceList.refresh();
            }
            this.renderMatrixGrid(guiGraphics, this.enchanter.matrix);
        }
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.hoveredPiece != null) {
            EnchantmentMatrix.Piece p;
            LinkedList<MutableComponent> tooltip = new LinkedList<MutableComponent>();
            tooltip.add(Component.translatable((String)Enchantment.getFullname(this.hoveredPiece.enchant, (int)this.hoveredPiece.level).getString().replaceAll("\\u00A7.", "")).withStyle(ChatFormatting.GOLD));
            if (this.hoveredPiece.influence > 0) {
                tooltip.add(Component.translatable((String)"quark.gui.enchanting.influence", (Object[])new Object[]{(int)((double)this.hoveredPiece.influence * MatrixEnchantingModule.influencePower * 100.0)}).withStyle(ChatFormatting.GRAY));
            } else if (this.hoveredPiece.influence < 0) {
                tooltip.add(Component.translatable((String)"quark.gui.enchanting.dampen", (Object[])new Object[]{(int)((double)this.hoveredPiece.influence * MatrixEnchantingModule.influencePower * 100.0)}).withStyle(ChatFormatting.GRAY));
            }
            int max = this.hoveredPiece.getMaxXP();
            if (max > 0) {
                tooltip.add(Component.translatable((String)"quark.gui.enchanting.upgrade", (Object[])new Object[]{this.hoveredPiece.xp, max}).withStyle(ChatFormatting.GRAY));
            }
            if (this.gridHoverX == -1) {
                tooltip.add(Component.literal((String)""));
                tooltip.add(Component.translatable((String)"quark.gui.enchanting.left_click").withStyle(ChatFormatting.GRAY));
                tooltip.add(Component.translatable((String)"quark.gui.enchanting.right_click").withStyle(ChatFormatting.GRAY));
            } else if (this.selectedPiece != -1 && (p = this.getPiece(this.selectedPiece)) != null && p.enchant == this.hoveredPiece.enchant && this.hoveredPiece.level < ((Enchantment)this.hoveredPiece.enchant.value()).getMaxLevel()) {
                tooltip.add(Component.literal((String)""));
                tooltip.add(Component.translatable((String)"quark.gui.enchanting.merge").withStyle(ChatFormatting.GRAY));
            }
            guiGraphics.renderComponentTooltip(this.font, tooltip, mouseX, mouseY);
        } else {
            this.renderTooltip(guiGraphics, mouseX, mouseY);
        }
    }

    public void mouseMoved(double mouseX, double mouseY) {
        int gridMouseX = (int)(mouseX - (double)this.leftPos - 86.0);
        int gridMouseY = (int)(mouseY - (double)this.topPos - 11.0);
        this.gridHoverX = gridMouseX < 0 ? -1 : gridMouseX / 10;
        int n = this.gridHoverY = gridMouseY < 0 ? -1 : gridMouseY / 10;
        if (this.gridHoverX < 0 || this.gridHoverX > 4 || this.gridHoverY < 0 || this.gridHoverY > 4) {
            this.gridHoverX = -1;
            this.gridHoverY = -1;
            this.hoveredPiece = null;
        } else if (this.enchanter.matrix != null) {
            int hover = this.enchanter.matrix.matrix[this.gridHoverX][this.gridHoverY];
            this.hoveredPiece = this.getPiece(hover);
        }
        this.pieceList.mouseMoved(gridMouseX, gridMouseY);
        super.mouseMoved(mouseX, mouseY);
    }

    public boolean mouseDragged(double p_97752_, double p_97753_, int p_97754_, double p_97755_, double p_97756_) {
        this.pieceList.mouseDragged(p_97752_, p_97753_, p_97754_, p_97755_, p_97756_);
        return super.mouseDragged(p_97752_, p_97753_, p_97754_, p_97755_, p_97756_);
    }

    public boolean mouseReleased(double p_97812_, double p_97813_, int p_97814_) {
        this.pieceList.mouseReleased(p_97812_, p_97813_, p_97814_);
        return super.mouseReleased(p_97812_, p_97813_, p_97814_);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        this.pieceList.mouseClicked(mouseX, mouseY, mouseButton);
        if (this.enchanter.matrix == null) {
            return true;
        }
        if (mouseButton == 0 && this.gridHoverX != -1) {
            int hover = this.enchanter.matrix.matrix[this.gridHoverX][this.gridHoverY];
            if (this.selectedPiece != -1) {
                if (hover == -1) {
                    this.place(this.selectedPiece, this.gridHoverX, this.gridHoverY);
                } else {
                    this.merge(this.selectedPiece);
                }
            } else {
                this.remove(hover);
                if (!MatrixEnchantingScreen.hasShiftDown()) {
                    this.selectedPiece = hover;
                }
            }
        } else if (mouseButton == 1 && this.selectedPiece != -1) {
            this.rotate(this.selectedPiece);
        }
        return true;
    }

    private void renderMatrixGrid(GuiGraphics guiGraphics, EnchantmentMatrix matrix) {
        EnchantmentMatrix.Piece piece;
        PoseStack stack = guiGraphics.pose();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND);
        stack.pushPose();
        stack.translate(86.0f, 11.0f, 0.0f);
        for (int i : matrix.placedPieces) {
            EnchantmentMatrix.Piece piece2 = this.getPiece(i);
            if (piece2 == null) continue;
            stack.pushPose();
            stack.translate((float)(piece2.x * 10), (float)(piece2.y * 10), 0.0f);
            this.renderPiece(guiGraphics, piece2, 1.0f);
            stack.popPose();
        }
        if (this.selectedPiece != -1 && this.gridHoverX != -1 && (piece = this.getPiece(this.selectedPiece)) != null && (this.hoveredPiece == null || piece.enchant != this.hoveredPiece.enchant || this.hoveredPiece.level >= ((Enchantment)this.hoveredPiece.enchant.value()).getMaxLevel())) {
            stack.pushPose();
            stack.translate((float)(this.gridHoverX * 10), (float)(this.gridHoverY * 10), 0.0f);
            float a = 0.2f;
            if (matrix.canPlace(piece, this.gridHoverX, this.gridHoverY)) {
                a = (float)((Math.sin((double)AnimationTickHolder.getTicks() + (double)Minecraft.getInstance().getTimer().getGameTimeDeltaTicks() * 0.2) + 1.0) * 0.4 + 0.4);
            }
            this.renderPiece(guiGraphics, piece, a);
            stack.popPose();
        }
        if (this.hoveredPiece == null && this.gridHoverX != -1) {
            this.renderHover(guiGraphics, this.gridHoverX, this.gridHoverY);
        }
        stack.popPose();
    }

    protected void renderPiece(GuiGraphics guiGraphics, EnchantmentMatrix.Piece piece, float a) {
        float r = (float)(piece.color >> 16 & 0xFF) / 255.0f;
        float g = (float)(piece.color >> 8 & 0xFF) / 255.0f;
        float b = (float)(piece.color & 0xFF) / 255.0f;
        boolean hovered = this.hoveredPiece == piece;
        for (int[] block : piece.blocks) {
            this.renderBlock(guiGraphics, block[0], block[1], piece.type, r, g, b, a, hovered);
        }
    }

    private void renderBlock(GuiGraphics guiGraphics, int x, int y, int type, float r, float g, float b, float a, boolean hovered) {
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
        guiGraphics.blit(BACKGROUND, x * 10, y * 10, 11 + type * 10, this.imageHeight, 10, 10);
        if (hovered) {
            this.renderHover(guiGraphics, x, y);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderHover(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.fill(x * 10, y * 10, x * 10 + 10, y * 10 + 10, 0x66FFFFFF);
    }

    public void add(Button button) {
        this.send(0, 0, 0, 0);
    }

    public void place(int id, int x, int y) {
        this.send(1, id, x, y);
        this.selectedPiece = -1;
        this.click();
    }

    public void remove(int id) {
        this.send(2, id, 0, 0);
    }

    public void rotate(int id) {
        this.send(3, id, 0, 0);
    }

    public void merge(int id) {
        int hover = this.enchanter.matrix.matrix[this.gridHoverX][this.gridHoverY];
        EnchantmentMatrix.Piece p = this.getPiece(hover);
        EnchantmentMatrix.Piece p1 = this.getPiece(this.selectedPiece);
        if (p != null && p1 != null && p.enchant == p1.enchant && p.level < ((Enchantment)p.enchant.value()).getMaxLevel()) {
            this.send(4, hover, id, 0);
            this.selectedPiece = -1;
            this.click();
        }
    }

    private void send(int operation, int arg0, int arg1, int arg2) {
        MatrixEnchanterOperationMessage message = new MatrixEnchanterOperationMessage(operation, arg0, arg1, arg2);
        PacketDistributor.sendToServer((CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void click() {
        this.getMinecraft().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
    }

    private void updateButtonStatus() {
        this.plusButton.active = this.enchanter.matrix != null && (this.getMinecraft().player.getAbilities().instabuild || this.enchanter.charge > 0) && this.enchanter.matrix.validateXp((Player)this.getMinecraft().player, this.enchanter.bookshelfPower) && this.enchanter.matrix.canGeneratePiece(this.enchanter.influences, this.enchanter.bookshelfPower, this.enchanter.enchantability);
    }

    protected EnchantmentMatrix.Piece getPiece(int id) {
        EnchantmentMatrix matrix = this.enchanter.matrix;
        if (matrix != null) {
            return matrix.pieces.get(id);
        }
        return null;
    }
}

