/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tweaks.client.emote;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.tweaks.module.EmotesModule;

public class CustomEmoteIconResourcePack
extends AbstractPackResources {
    private final List<String> verifiedNames = new ArrayList<String>();
    private final List<String> existingNames = new ArrayList<String>();

    public CustomEmoteIconResourcePack() {
        super("quark-emote-pack", true);
    }

    @Nullable
    public IoSupplier<InputStream> m_8017_(String ... file) {
        return null;
    }

    @Nullable
    public IoSupplier<InputStream> m_214146_(@NotNull PackType packType, ResourceLocation name) {
        if (name.m_135815_().equals("pack.mcmeta")) {
            try {
                return IoSupplier.m_246697_((Path)Path.of(Quark.class.getResource("/proxypack.mcmeta").toURI()));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.m_135815_().equals("pack.png")) {
            try {
                return IoSupplier.m_246697_((Path)Path.of(Quark.class.getResource("/proxypack.png").toURI()));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        File file = this.getFile(name.m_135815_());
        if (!file.exists()) {
            try {
                throw new FileNotFoundException(name.m_135815_());
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return IoSupplier.m_246697_((Path)file.toPath());
    }

    public void m_8031_(@NotNull PackType packType, @NotNull String thing, @NotNull String ugh, @NotNull PackResources.ResourceOutput resourceOutput) {
    }

    @NotNull
    public Set<String> m_5698_(@NotNull PackType type) {
        if (type == PackType.CLIENT_RESOURCES) {
            return ImmutableSet.of((Object)"quark_custom");
        }
        return ImmutableSet.of();
    }

    @NotNull
    public Collection<ResourceLocation> getResources(@NotNull PackType type, @NotNull String pathIn, @NotNull String idk, @NotNull Predicate<ResourceLocation> filter) {
        File rootPath = new File(this.getFile(idk), type.m_10305_());
        ArrayList allResources = Lists.newArrayList();
        for (String namespace : this.m_5698_(type)) {
            this.crawl(new File(new File(rootPath, namespace), pathIn), 32, namespace, allResources, pathIn + "/", filter);
        }
        return allResources;
    }

    private void crawl(File rootPath, int maxDepth, String namespace, List<ResourceLocation> allResources, String path, Predicate<ResourceLocation> filter) {
        File[] files = rootPath.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    if (maxDepth <= 0) continue;
                    this.crawl(file, maxDepth - 1, namespace, allResources, path + file.getName() + "/", filter);
                    continue;
                }
                if (file.getName().endsWith(".mcmeta") || !filter.test(new ResourceLocation(namespace, path + file.getName()))) continue;
                try {
                    allResources.add(new ResourceLocation(namespace, path + file.getName()));
                }
                catch (ResourceLocationException e) {
                    Quark.LOG.error(e.getMessage());
                }
            }
        }
    }

    public void close() {
    }

    protected boolean hasResource(@NotNull String name) {
        if (!this.verifiedNames.contains(name)) {
            File file = this.getFile(name);
            if (file.exists()) {
                this.existingNames.add(name);
            }
            this.verifiedNames.add(name);
        }
        return this.existingNames.contains(name);
    }

    private File getFile(String name) {
        Object filename = name.substring(name.indexOf(":") + 1) + ".png";
        filename = ((String)filename).replaceAll("(.+/)+", "");
        return new File(EmotesModule.emotesDir, (String)filename);
    }

    public boolean isHidden() {
        return true;
    }
}

