/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.mobs.module;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluids;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.handler.QuarkSounds;
import org.violetmoon.quark.content.mobs.client.render.entity.CrabRenderer;
import org.violetmoon.quark.content.mobs.entity.Crab;
import org.violetmoon.zeta.advancement.modifier.BalancedDietModifier;
import org.violetmoon.zeta.advancement.modifier.FuriousCocktailModifier;
import org.violetmoon.zeta.advancement.modifier.TwoByTwoModifier;
import org.violetmoon.zeta.api.IAdvancementModifier;
import org.violetmoon.zeta.client.event.load.ZClientSetup;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.config.type.CompoundBiomeConfig;
import org.violetmoon.zeta.config.type.EntitySpawnConfig;
import org.violetmoon.zeta.config.type.IBiomeConfig;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZCommonSetup;
import org.violetmoon.zeta.event.load.ZEntityAttributeCreation;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.event.play.loading.ZVillagerTrades;
import org.violetmoon.zeta.item.ZetaItem;
import org.violetmoon.zeta.item.ZetaMobBucketItem;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.CreativeTabManager;
import org.violetmoon.zeta.util.Hint;
import org.violetmoon.zeta.util.ZetaEffect;

@ZetaLoadModule(category="mobs")
public class CrabsModule
extends ZetaModule {
    public static EntityType<Crab> crabType;
    @Config
    public static EntitySpawnConfig spawnConfig;
    public static TagKey<Block> crabSpawnableTag;
    public static MobEffect resilience;
    @Config(flag="crab_brewing")
    public static boolean enableBrewing;
    @Config(description="Whether Resilience should be required for 'How Did We Get Here?' and (if brewing is enabled) 'A Furious Cocktail'.\nKeep this on when brewing is disabled if your pack adds an alternative source for the effect.")
    public static boolean resilienceRequiredForAllEffects;
    @Config
    public static boolean addCrabLegToFishermanTrades;
    @Hint(key="crab_info")
    Item crab_leg;
    @Hint(key="crab_info")
    Item crab_shell;
    @Hint(key="crab_info")
    public static Item crab_bucket;

    @LoadEvent
    public final void register(ZRegister event) {
        CreativeTabManager.daisyChain();
        this.crab_leg = new ZetaItem("crab_leg", (ZetaModule)this, new Item.Properties().m_41489_(new FoodProperties.Builder().m_38757_().m_38760_(1).m_38758_(0.3f).m_38767_())).setCreativeTab(CreativeModeTabs.f_256839_, (ItemLike)Items.f_42529_, false);
        Item cookedCrabLeg = new ZetaItem("cooked_crab_leg", (ZetaModule)this, new Item.Properties().m_41489_(new FoodProperties.Builder().m_38757_().m_38760_(8).m_38758_(0.8f).m_38767_())).setCreativeTab(CreativeModeTabs.f_256839_);
        CreativeTabManager.endDaisyChain();
        this.crab_shell = new ZetaItem("crab_shell", (ZetaModule)this, new Item.Properties()).setCondition(() -> enableBrewing).setCreativeTab(CreativeModeTabs.f_256968_, (ItemLike)Items.f_42648_, false);
        crab_bucket = new ZetaMobBucketItem(() -> crabType, () -> Fluids.f_76193_, () -> QuarkSounds.BUCKET_EMPTY_CRAB, "crab_bucket", (ZetaModule)this);
        resilience = new ZetaEffect(Quark.ZETA, "resilience", MobEffectCategory.BENEFICIAL, 5970436);
        resilience.m_19472_(Attributes.f_22278_, "2ddf3f0a-f386-47b6-aeb0-6bd32851f215", 0.5, AttributeModifier.Operation.ADDITION);
        event.getBrewingRegistry().addPotionMix("crab_brewing", () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{this.crab_shell}), resilience);
        crabType = EntityType.Builder.m_20704_(Crab::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 0.5f).m_20702_(8).setCustomClientFactory((spawnEntity, world) -> new Crab((EntityType<? extends Crab>)crabType, (Level)world)).m_20712_("crab");
        Quark.ZETA.registry.register(crabType, "crab", Registries.f_256939_);
        Quark.ZETA.entitySpawn.registerSpawn(crabType, MobCategory.CREATURE, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Crab::spawnPredicate, spawnConfig);
        Quark.ZETA.entitySpawn.addEgg((ZetaModule)this, crabType, 8993826, 9528648, spawnConfig);
        event.getAdvancementModifierRegistry().addModifier((IAdvancementModifier)new FuriousCocktailModifier((ZetaModule)this, () -> enableBrewing, (Set)ImmutableSet.of((Object)resilience)).setCondition(() -> resilienceRequiredForAllEffects));
        event.getAdvancementModifierRegistry().addModifier((IAdvancementModifier)new TwoByTwoModifier((ZetaModule)this, (Set)ImmutableSet.of(crabType)));
        event.getAdvancementModifierRegistry().addModifier((IAdvancementModifier)new BalancedDietModifier((ZetaModule)this, (Set)ImmutableSet.of((Object)this.crab_leg, (Object)cookedCrabLeg)));
    }

    @PlayEvent
    public void onTradesLoaded(ZVillagerTrades event) {
        if (event.getType() == VillagerProfession.f_35591_ && addCrabLegToFishermanTrades) {
            List journeymanListing = (List)event.getTrades().get(4);
            journeymanListing.add(new VillagerTrades.EmeraldForItems((ItemLike)this.crab_leg, 4, 12, 30));
        }
    }

    @LoadEvent
    public final void entityAttrs(ZEntityAttributeCreation e) {
        e.put(crabType, Crab.prepareAttributes().m_22265_());
    }

    @LoadEvent
    public final void setup(ZCommonSetup event) {
        crabSpawnableTag = BlockTags.create((ResourceLocation)new ResourceLocation("quark", "crab_spawnable"));
    }

    static {
        spawnConfig = new EntitySpawnConfig(5, 1, 3, (IBiomeConfig)CompoundBiomeConfig.fromBiomeTags((boolean)false, (TagKey[])new TagKey[]{BiomeTags.f_207604_}));
        enableBrewing = true;
        resilienceRequiredForAllEffects = true;
        addCrabLegToFishermanTrades = true;
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends CrabsModule {
        @LoadEvent
        public final void clientSetup(ZClientSetup event) {
            EntityRenderers.m_174036_((EntityType)crabType, CrabRenderer::new);
        }
    }
}

