/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tweaks.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.content.tweaks.entity.DyedItemFrame;

public class DyedItemFrameRenderer
extends EntityRenderer<DyedItemFrame> {
    private static final ModelResourceLocation FRAME_LOCATION = new ModelResourceLocation("quark", "extra/dyed_item_frame", "inventory");
    private static final ModelResourceLocation MAP_FRAME_LOCATION = new ModelResourceLocation("quark", "extra/dyed_item_frame_map", "inventory");
    public static final int GLOW_FRAME_BRIGHTNESS = 5;
    public static final int BRIGHT_MAP_LIGHT_ADJUSTMENT = 30;
    private final ItemRenderer itemRenderer;
    private final BlockRenderDispatcher blockRenderer;

    public DyedItemFrameRenderer(EntityRendererProvider.Context p_174204_) {
        super(p_174204_);
        this.itemRenderer = p_174204_.m_174025_();
        this.blockRenderer = p_174204_.m_234597_();
    }

    protected int getBlockLightLevel(DyedItemFrame p_174216_, BlockPos p_174217_) {
        return p_174216_.isGlow() ? Math.max(5, super.m_6086_((Entity)p_174216_, p_174217_)) : super.m_6086_((Entity)p_174216_, p_174217_);
    }

    public void render(@NotNull DyedItemFrame dyedItemFrame, float p_115077_, float p_115078_, @NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int p_115081_) {
        super.m_7392_((Entity)dyedItemFrame, p_115077_, p_115078_, poseStack, multiBufferSource, p_115081_);
        poseStack.m_85836_();
        Direction direction = dyedItemFrame.m_6350_();
        Vec3 vec3 = this.getRenderOffset(dyedItemFrame, p_115078_);
        poseStack.m_85837_(-vec3.m_7096_(), -vec3.m_7098_(), -vec3.m_7094_());
        poseStack.m_85837_((double)direction.m_122429_() * 0.46875, (double)direction.m_122430_() * 0.46875, (double)direction.m_122431_() * 0.46875);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(dyedItemFrame.m_146909_()));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - dyedItemFrame.m_146908_()));
        boolean flag = dyedItemFrame.m_20145_();
        ItemStack itemstack = dyedItemFrame.m_31822_();
        if (!flag) {
            ModelManager modelmanager = this.blockRenderer.m_110907_().m_110881_();
            boolean map = dyedItemFrame.m_31822_().m_41720_() instanceof MapItem;
            ModelResourceLocation modelresourcelocation = map ? MAP_FRAME_LOCATION : FRAME_LOCATION;
            poseStack.m_85836_();
            poseStack.m_85837_(-0.5, -0.5, -0.5);
            int color = dyedItemFrame.getColor();
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            this.blockRenderer.m_110937_().m_111067_(poseStack.m_85850_(), multiBufferSource.m_6299_(Sheets.m_110789_()), (BlockState)null, modelmanager.m_119422_(modelresourcelocation), r, g, b, p_115081_, OverlayTexture.f_118083_);
            poseStack.m_85849_();
        }
        if (!itemstack.m_41619_()) {
            MapItemSavedData mapitemsaveddata = MapItem.m_42853_((ItemStack)itemstack, (Level)dyedItemFrame.m_9236_());
            if (flag) {
                poseStack.m_85837_(0.0, 0.0, 0.5);
            } else {
                poseStack.m_85837_(0.0, 0.0, 0.4375);
            }
            int j = mapitemsaveddata != null ? dyedItemFrame.m_31823_() % 4 * 2 : dyedItemFrame.m_31823_();
            poseStack.m_252781_(Axis.f_252403_.m_252977_((float)j * 360.0f / 8.0f));
            if (mapitemsaveddata != null) {
                poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                poseStack.m_85841_(0.0078125f, 0.0078125f, 0.0078125f);
                poseStack.m_85837_(-64.0, -64.0, 0.0);
                poseStack.m_85837_(0.0, 0.0, -1.0);
                if (mapitemsaveddata != null) {
                    int i = this.getLightVal(dyedItemFrame, 15728850, p_115081_);
                    Minecraft.m_91087_().f_91063_.m_109151_().m_168771_(poseStack, multiBufferSource, dyedItemFrame.m_218868_().getAsInt(), mapitemsaveddata, true, i);
                }
            } else {
                int k = this.getLightVal(dyedItemFrame, 0xF000F0, p_115081_);
                poseStack.m_85841_(0.5f, 0.5f, 0.5f);
                this.itemRenderer.m_269128_(itemstack, ItemDisplayContext.FIXED, k, OverlayTexture.f_118083_, poseStack, multiBufferSource, (Level)Minecraft.m_91087_().f_91073_, dyedItemFrame.m_19879_());
            }
        }
        poseStack.m_85849_();
    }

    private int getLightVal(DyedItemFrame p_174209_, int p_174210_, int p_174211_) {
        return p_174209_.isGlow() ? p_174210_ : p_174211_;
    }

    public Vec3 getRenderOffset(DyedItemFrame p_115073_, float p_115074_) {
        return new Vec3((double)((float)p_115073_.m_6350_().m_122429_() * 0.3f), -0.25, (double)((float)p_115073_.m_6350_().m_122431_() * 0.3f));
    }

    public ResourceLocation getTextureLocation(DyedItemFrame p_115071_) {
        return InventoryMenu.f_39692_;
    }

    protected boolean shouldShowName(DyedItemFrame p_115091_) {
        if (Minecraft.m_91404_() && !p_115091_.m_31822_().m_41619_() && p_115091_.m_31822_().m_41788_() && this.f_114476_.f_114359_ == p_115091_) {
            double d0 = this.f_114476_.m_114471_((Entity)p_115091_);
            float f = p_115091_.m_20163_() ? 32.0f : 64.0f;
            return d0 < (double)(f * f);
        }
        return false;
    }

    protected void renderNameTag(DyedItemFrame p_115083_, Component p_115084_, PoseStack p_115085_, MultiBufferSource p_115086_, int p_115087_) {
        super.m_7649_((Entity)p_115083_, p_115083_.m_31822_().m_41786_(), p_115085_, p_115086_, p_115087_);
    }
}

