/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.world.feature;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.MapCodec;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import org.violetmoon.quark.content.world.module.AncientWoodModule;

public class AncientTreeTopperDecorator
extends TreeDecorator {
    public static final MapCodec<AncientTreeTopperDecorator> CODEC = MapCodec.unit(AncientTreeTopperDecorator::new);
    public static final TreeDecoratorType<AncientTreeTopperDecorator> TYPE = new TreeDecoratorType(CODEC);

    protected TreeDecoratorType<?> type() {
        return TYPE;
    }

    public void place(TreeDecorator.Context ctx) {
        Optional<BlockPos> highestLog = ctx.logs().stream().max(Comparator.comparingInt(Vec3i::getY));
        if (highestLog.isPresent()) {
            BlockPos top = highestLog.get();
            ImmutableSet leafPos = ImmutableSet.of((Object)top.above(), (Object)top.east(), (Object)top.west(), (Object)top.north(), (Object)top.south());
            BlockState state = AncientWoodModule.ancient_leaves.defaultBlockState();
            leafPos.forEach(p -> {
                if (ctx.isAir(p)) {
                    ctx.setBlock(p, state);
                }
            });
        }
    }
}

