/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.building.module;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.violetmoon.quark.api.ICrawlSpaceBlock;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.building.block.HollowLogBlock;
import org.violetmoon.zeta.advancement.ManualTrigger;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZCommonSetup;
import org.violetmoon.zeta.event.load.ZConfigChanged;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.event.play.entity.player.ZPlayerTick;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.Hint;
import org.violetmoon.zeta.util.VanillaWoods;

@ZetaLoadModule(category="building")
public class HollowLogsModule
extends ZetaModule {
    public static List<Block> hollowLogs = new ArrayList<Block>();
    private static final String TAG_TRYING_TO_CRAWL = "quark:trying_crawl";
    public static ManualTrigger crawlTrigger;
    @Config(flag="hollow_log_auto_crawl")
    public static boolean enableAutoCrawl;
    @Hint(key="hollow_logs", value="hollow_log_auto_crawl")
    public static TagKey<Block> hollowLogsTag;
    public static boolean staticEnabled;
    public static Map<Block, Block> logMap;

    @LoadEvent
    public final void configChanged(ZConfigChanged event) {
        staticEnabled = this.isEnabled();
    }

    @LoadEvent
    public final void register(ZRegister event) {
        for (VanillaWoods.Wood wood : VanillaWoods.ALL_WITH_LOGS) {
            HollowLogBlock block = new HollowLogBlock(wood.log(), (ZetaModule)this, !wood.nether());
            hollowLogs.add((Block)block);
        }
        crawlTrigger = event.getAdvancementModifierRegistry().registerManualTrigger("hollow_log_crawl");
    }

    @LoadEvent
    public final void setup(ZCommonSetup event) {
        hollowLogsTag = Quark.asTagKey(Registries.BLOCK, "hollow_logs");
    }

    @PlayEvent
    public void playerTick(ZPlayerTick.Start event) {
        if (enableAutoCrawl) {
            Player player = event.getPlayer();
            BlockPos playerPos = player.blockPosition();
            boolean isTrying = player.isVisuallyCrawling() || player.isCrouching() && !player.isColliding(playerPos, player.level().getBlockState(playerPos));
            boolean wasTrying = player.getPersistentData().getBoolean(TAG_TRYING_TO_CRAWL);
            if (!player.isVisuallyCrawling() && isTrying && !wasTrying) {
                Direction dir = player.getDirection();
                Direction opp = dir.getOpposite();
                if (dir.getAxis() != Direction.Axis.Y) {
                    BlockPos pos = playerPos.relative(dir);
                    if (!(this.tryClimb(player, opp, playerPos) || this.tryClimb(player, opp, playerPos.above()) || this.tryClimb(player, dir, pos))) {
                        this.tryClimb(player, dir, pos.above());
                    }
                }
            }
            if (isTrying != wasTrying) {
                player.getPersistentData().putBoolean(TAG_TRYING_TO_CRAWL, isTrying);
            }
        }
    }

    private boolean tryClimb(Player player, Direction dir, BlockPos pos) {
        ICrawlSpaceBlock crawlSpace;
        BlockState state = player.level().getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof ICrawlSpaceBlock && (crawlSpace = (ICrawlSpaceBlock)block).canCrawl(player.level(), state, pos, dir)) {
            ServerPlayer sp;
            player.setPose(Pose.SWIMMING);
            player.setSwimming(true);
            double x = (double)pos.getX() + 0.5 - (double)dir.getStepX() * 0.3;
            double y = (double)pos.getY() + crawlSpace.crawlHeight(player.level(), state, pos, dir);
            double z = (double)pos.getZ() + 0.5 - (double)dir.getStepZ() * 0.3;
            player.setPos(x, y, z);
            if (player instanceof ServerPlayer && crawlSpace.isLog(sp = (ServerPlayer)player, state, pos, dir)) {
                crawlTrigger.trigger(sp);
            }
            return true;
        }
        return false;
    }

    static {
        enableAutoCrawl = true;
        logMap = new HashMap<Block, Block>();
    }
}

