/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.datagen;

import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.handler.WoodSetHandler;
import org.violetmoon.quark.base.util.CorundumColor;
import org.violetmoon.quark.content.world.module.AncientWoodModule;
import org.violetmoon.quark.content.world.module.AzaleaWoodModule;
import org.violetmoon.quark.content.world.module.BlossomTreesModule;

public class DataUtil {
    static List<WoodSetHandler.WoodSet> QuarkWoodSets = List.of(AzaleaWoodModule.woodSet, AncientWoodModule.woodSet, BlossomTreesModule.woodSet);

    public static Block axeStrip(Block block) {
        if (block == Blocks.OAK_WOOD) {
            return Blocks.STRIPPED_OAK_WOOD;
        }
        if (block == Blocks.SPRUCE_WOOD) {
            return Blocks.STRIPPED_SPRUCE_WOOD;
        }
        if (block == Blocks.BIRCH_WOOD) {
            return Blocks.STRIPPED_BIRCH_WOOD;
        }
        if (block == Blocks.JUNGLE_WOOD) {
            return Blocks.STRIPPED_JUNGLE_WOOD;
        }
        if (block == Blocks.ACACIA_WOOD) {
            return Blocks.STRIPPED_ACACIA_WOOD;
        }
        if (block == Blocks.DARK_OAK_WOOD) {
            return Blocks.STRIPPED_DARK_OAK_WOOD;
        }
        if (block == Blocks.MANGROVE_WOOD) {
            return Blocks.STRIPPED_MANGROVE_WOOD;
        }
        if (block == Blocks.CHERRY_WOOD) {
            return Blocks.STRIPPED_CHERRY_WOOD;
        }
        if (block == Blocks.CRIMSON_HYPHAE) {
            return Blocks.STRIPPED_CRIMSON_HYPHAE;
        }
        if (block == Blocks.WARPED_HYPHAE) {
            return Blocks.STRIPPED_WARPED_HYPHAE;
        }
        if (block == AncientWoodModule.woodSet.wood) {
            return AncientWoodModule.woodSet.strippedWood;
        }
        if (block == AzaleaWoodModule.woodSet.wood) {
            return AzaleaWoodModule.woodSet.strippedWood;
        }
        if (block == BlossomTreesModule.woodSet.wood) {
            return BlossomTreesModule.woodSet.strippedWood;
        }
        return null;
    }

    public static Item getDyeItemFromCorondumColor(CorundumColor corundumColor) {
        return switch (corundumColor) {
            default -> throw new MatchException(null, null);
            case CorundumColor.RED -> Items.RED_DYE;
            case CorundumColor.ORANGE -> Items.ORANGE_DYE;
            case CorundumColor.YELLOW -> Items.YELLOW_DYE;
            case CorundumColor.GREEN -> Items.GREEN_DYE;
            case CorundumColor.BLUE -> Items.LIGHT_BLUE_DYE;
            case CorundumColor.INDIGO -> Items.BLUE_DYE;
            case CorundumColor.VIOLET -> Items.PINK_DYE;
            case CorundumColor.WHITE -> Items.WHITE_DYE;
            case CorundumColor.BLACK -> Items.BLACK_DYE;
        };
    }

    public static Block getWoolFromDyeColor(DyeColor dyeColor) {
        return switch (dyeColor) {
            default -> throw new MatchException(null, null);
            case DyeColor.BLACK -> Blocks.BLACK_WOOL;
            case DyeColor.BLUE -> Blocks.BLUE_WOOL;
            case DyeColor.BROWN -> Blocks.BROWN_WOOL;
            case DyeColor.YELLOW -> Blocks.YELLOW_WOOL;
            case DyeColor.CYAN -> Blocks.CYAN_WOOL;
            case DyeColor.GRAY -> Blocks.GRAY_WOOL;
            case DyeColor.GREEN -> Blocks.GREEN_WOOL;
            case DyeColor.WHITE -> Blocks.WHITE_WOOL;
            case DyeColor.ORANGE -> Blocks.ORANGE_WOOL;
            case DyeColor.MAGENTA -> Blocks.MAGENTA_WOOL;
            case DyeColor.LIGHT_BLUE -> Blocks.LIGHT_BLUE_WOOL;
            case DyeColor.LIME -> Blocks.LIME_WOOL;
            case DyeColor.PINK -> Blocks.PINK_WOOL;
            case DyeColor.LIGHT_GRAY -> Blocks.LIGHT_GRAY_WOOL;
            case DyeColor.PURPLE -> Blocks.PURPLE_WOOL;
            case DyeColor.RED -> Blocks.RED_WOOL;
        };
    }

    public static Block getTerrracottaFromDyeColor(DyeColor dyeColor) {
        return switch (dyeColor) {
            default -> throw new MatchException(null, null);
            case DyeColor.BLACK -> Blocks.BLACK_TERRACOTTA;
            case DyeColor.BLUE -> Blocks.BLUE_TERRACOTTA;
            case DyeColor.BROWN -> Blocks.BROWN_TERRACOTTA;
            case DyeColor.YELLOW -> Blocks.YELLOW_TERRACOTTA;
            case DyeColor.CYAN -> Blocks.CYAN_TERRACOTTA;
            case DyeColor.GRAY -> Blocks.GRAY_TERRACOTTA;
            case DyeColor.GREEN -> Blocks.GREEN_TERRACOTTA;
            case DyeColor.WHITE -> Blocks.WHITE_TERRACOTTA;
            case DyeColor.ORANGE -> Blocks.ORANGE_TERRACOTTA;
            case DyeColor.MAGENTA -> Blocks.MAGENTA_TERRACOTTA;
            case DyeColor.LIGHT_BLUE -> Blocks.LIGHT_BLUE_TERRACOTTA;
            case DyeColor.LIME -> Blocks.LIME_TERRACOTTA;
            case DyeColor.PINK -> Blocks.PINK_TERRACOTTA;
            case DyeColor.LIGHT_GRAY -> Blocks.LIGHT_GRAY_TERRACOTTA;
            case DyeColor.PURPLE -> Blocks.PURPLE_TERRACOTTA;
            case DyeColor.RED -> Blocks.RED_TERRACOTTA;
        };
    }

    public static TagKey<Item> getLogTagFromLog(Block standardLog) {
        if (standardLog == Blocks.OAK_LOG) {
            return ItemTags.OAK_LOGS;
        }
        if (standardLog == Blocks.SPRUCE_LOG) {
            return ItemTags.SPRUCE_LOGS;
        }
        if (standardLog == Blocks.BIRCH_LOG) {
            return ItemTags.BIRCH_LOGS;
        }
        if (standardLog == Blocks.JUNGLE_LOG) {
            return ItemTags.JUNGLE_LOGS;
        }
        if (standardLog == Blocks.ACACIA_LOG) {
            return ItemTags.ACACIA_LOGS;
        }
        if (standardLog == Blocks.DARK_OAK_LOG) {
            return ItemTags.DARK_OAK_LOGS;
        }
        if (standardLog == Blocks.MANGROVE_LOG) {
            return ItemTags.MANGROVE_LOGS;
        }
        if (standardLog == Blocks.CHERRY_LOG) {
            return ItemTags.CHERRY_LOGS;
        }
        if (standardLog == AncientWoodModule.woodSet.wood) {
            return Quark.asTagKey(Registries.ITEM, "ancient_logs");
        }
        if (standardLog == AzaleaWoodModule.woodSet.wood) {
            return Quark.asTagKey(Registries.ITEM, "azalea_logs");
        }
        if (standardLog == BlossomTreesModule.woodSet.wood) {
            return Quark.asTagKey(Registries.ITEM, "blossom_logs");
        }
        return null;
    }
}

