/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.building.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class MixedExclusionRecipe
implements CraftingRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    private NonNullList<Ingredient> ingredients;
    private final String group;
    private final ItemStack output;
    private final TagKey<Item> tag;
    private final ItemStack placeholder;

    public MixedExclusionRecipe(String group, ItemStack output, TagKey<Item> tag, ItemStack placeholder) {
        this.group = group;
        this.output = output;
        this.tag = tag;
        this.placeholder = placeholder;
    }

    public boolean canCraftInDimensions(int x, int y) {
        return x == 3 && y == 3;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return this.output.copy();
    }

    @NotNull
    public String getGroup() {
        return this.group;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return this.output.copy();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @NotNull
    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }

    public boolean matches(CraftingInput input, @NotNull Level level) {
        if (input.getItem(4).isEmpty()) {
            ItemStack first = null;
            boolean foundDifference = false;
            for (int i = 0; i < 9; ++i) {
                if (i == 4) continue;
                ItemStack stack = input.getItem(i);
                if (!stack.isEmpty() && stack.is(this.tag)) {
                    if (first == null) {
                        first = stack;
                        continue;
                    }
                    if (ItemStack.isSameItem((ItemStack)first, (ItemStack)stack)) continue;
                    foundDifference = true;
                    continue;
                }
                return false;
            }
            return foundDifference;
        }
        return false;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        if (this.ingredients == null) {
            NonNullList list = NonNullList.withSize((int)9, (Object)Ingredient.EMPTY);
            Ingredient ingr = Ingredient.of((ItemStack[])new ItemStack[]{this.placeholder});
            for (int i = 0; i < 8; ++i) {
                list.set(i < 4 ? i : i + 1, (Object)ingr);
            }
            this.ingredients = list;
        }
        return this.ingredients;
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<MixedExclusionRecipe> {
        public static final MapCodec<MixedExclusionRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)ItemStack.STRICT_CODEC.fieldOf("output").forGetter(recipe -> recipe.output), (App)TagKey.codec((ResourceKey)Registries.ITEM).fieldOf("tag").forGetter(recipe -> recipe.tag), (App)ItemStack.CODEC.optionalFieldOf("placeholder", (Object)ItemStack.EMPTY).forGetter(recipe -> recipe.placeholder)).apply((Applicative)inst, MixedExclusionRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, MixedExclusionRecipe> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, MixedExclusionRecipe>(){

            @NotNull
            public MixedExclusionRecipe decode(RegistryFriendlyByteBuf buf) {
                String group = buf.readUtf();
                ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
                TagKey tagKey = (TagKey)Serializer.evilBackportedTagKeyStreamCodec(Registries.ITEM).decode((Object)buf);
                ItemStack placeholder = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
                return new MixedExclusionRecipe(group, output, (TagKey<Item>)tagKey, placeholder);
            }

            public void encode(RegistryFriendlyByteBuf buf, MixedExclusionRecipe recipe) {
                buf.writeUtf(recipe.group);
                ItemStack.STREAM_CODEC.encode((Object)buf, (Object)recipe.output);
                Serializer.evilBackportedTagKeyStreamCodec(Registries.ITEM).encode((Object)buf, recipe.tag);
                ItemStack.STREAM_CODEC.encode((Object)buf, (Object)recipe.placeholder);
            }
        };

        public static <T> StreamCodec<ByteBuf, TagKey<T>> evilBackportedTagKeyStreamCodec(ResourceKey<? extends Registry<T>> registry) {
            return ResourceLocation.STREAM_CODEC.map(resourceLocation -> TagKey.create((ResourceKey)registry, (ResourceLocation)resourceLocation), TagKey::location);
        }

        @NotNull
        public MapCodec<MixedExclusionRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, MixedExclusionRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

