/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.datagen;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.addons.oddities.module.BackpackModule;
import org.violetmoon.quark.addons.oddities.module.CrateModule;
import org.violetmoon.quark.addons.oddities.module.MagnetsModule;
import org.violetmoon.quark.addons.oddities.module.PipesModule;
import org.violetmoon.quark.addons.oddities.module.TinyPotatoModule;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.util.CorundumColor;
import org.violetmoon.quark.content.automation.module.ChuteModule;
import org.violetmoon.quark.content.automation.module.EnderWatcherModule;
import org.violetmoon.quark.content.automation.module.FeedingTroughModule;
import org.violetmoon.quark.content.automation.module.GravisandModule;
import org.violetmoon.quark.content.automation.module.IronRodModule;
import org.violetmoon.quark.content.automation.module.MetalButtonsModule;
import org.violetmoon.quark.content.automation.module.ObsidianPlateModule;
import org.violetmoon.quark.content.automation.module.RedstoneRandomizerModule;
import org.violetmoon.quark.content.building.block.RainbowLampBlock;
import org.violetmoon.quark.content.building.module.CompressedBlocksModule;
import org.violetmoon.quark.content.building.module.DuskboundBlocksModule;
import org.violetmoon.quark.content.building.module.FramedGlassModule;
import org.violetmoon.quark.content.building.module.GrateModule;
import org.violetmoon.quark.content.building.module.HollowLogsModule;
import org.violetmoon.quark.content.building.module.JapanesePaletteModule;
import org.violetmoon.quark.content.building.module.MoreBrickTypesModule;
import org.violetmoon.quark.content.building.module.MoreMudBlocksModule;
import org.violetmoon.quark.content.building.module.MoreStoneVariantsModule;
import org.violetmoon.quark.content.building.module.NetherBrickFenceGateModule;
import org.violetmoon.quark.content.building.module.RainbowLampsModule;
import org.violetmoon.quark.content.building.module.ShinglesModule;
import org.violetmoon.quark.content.building.module.SoulSandstoneModule;
import org.violetmoon.quark.content.building.module.SturdyStoneModule;
import org.violetmoon.quark.content.building.module.VariantBookshelvesModule;
import org.violetmoon.quark.content.building.module.VariantChestsModule;
import org.violetmoon.quark.content.building.module.VariantFurnacesModule;
import org.violetmoon.quark.content.building.module.VerticalSlabsModule;
import org.violetmoon.quark.content.experimental.module.VariantSelectorModule;
import org.violetmoon.quark.content.mobs.module.StonelingsModule;
import org.violetmoon.quark.content.tools.module.AbacusModule;
import org.violetmoon.quark.content.tools.module.ColorRunesModule;
import org.violetmoon.quark.content.tools.module.PickarangModule;
import org.violetmoon.quark.content.tools.module.SeedPouchModule;
import org.violetmoon.quark.content.tools.module.TorchArrowModule;
import org.violetmoon.quark.content.tools.module.TrowelModule;
import org.violetmoon.quark.content.tweaks.module.GlassShardModule;
import org.violetmoon.quark.content.world.module.AncientWoodModule;
import org.violetmoon.quark.content.world.module.AzaleaWoodModule;
import org.violetmoon.quark.content.world.module.BlossomTreesModule;
import org.violetmoon.quark.content.world.module.CorundumModule;
import org.violetmoon.quark.content.world.module.SpiralSpiresModule;
import org.violetmoon.quark.datagen.QuarkTags;
import org.violetmoon.zeta.block.IZetaBlock;
import org.violetmoon.zeta.config.FlagCondition;
import org.violetmoon.zeta.util.VanillaWoods;

public class QuarkRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public QuarkRecipeProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> holderLookupProvider) {
        super(packOutput, holderLookupProvider);
    }

    public static FlagCondition zCond(String name) {
        return new FlagCondition(name, Optional.empty());
    }

    protected void buildRecipes(@NotNull RecipeOutput recipeOutput) {
        FlagCondition condition;
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)ChuteModule.chute).pattern("WWW").pattern("SWS").pattern(" S ").define(Character.valueOf('W'), ItemTags.PLANKS).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("chute")}), "quark:automation/crafting/chute");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)EnderWatcherModule.ender_watcher).pattern("BRB").pattern("RER").pattern("BRB").define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('B'), (ItemLike)Blocks.OBSIDIAN.asItem()).define(Character.valueOf('E'), (ItemLike)Items.ENDER_EYE).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("ender_watcher")}), "quark:automation/crafting/ender_watcher");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)FeedingTroughModule.feeding_trough).pattern("#W#").pattern("###").define(Character.valueOf('#'), ItemTags.PLANKS).define(Character.valueOf('W'), (ItemLike)Items.WHEAT).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("feeding_trough")}), "quark:automation/crafting/feeding_trough");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)MetalButtonsModule.gold_button).requires(ItemTags.WOODEN_BUTTONS).requires(Tags.Items.INGOTS_GOLD).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("gold_metal_button")}), "quark:automation/crafting/gold_button");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)GravisandModule.gravisand).pattern("SSS").pattern("SES").pattern("SSS").define(Character.valueOf('S'), Tags.Items.SANDS_COLORLESS).define(Character.valueOf('E'), Tags.Items.ENDER_PEARLS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("gravisand")}), "quark:automation/crafting/gravisand");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)MetalButtonsModule.iron_button).requires(ItemTags.WOODEN_BUTTONS).requires(Tags.Items.INGOTS_IRON).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("iron_metal_button")}), "quark:automation/crafting/iron_button");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)IronRodModule.iron_rod).pattern("I").pattern("I").pattern("R").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('R'), (ItemLike)Blocks.END_ROD).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("iron_rod"), this.not((ICondition)QuarkRecipeProvider.zCond("iron_rod_pre_end"))}), "quark:automation/crafting/iron_rod");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)IronRodModule.iron_rod).pattern("I").pattern("I").pattern("I").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("iron_rod"), QuarkRecipeProvider.zCond("iron_rod_pre_end")}), "quark:automation/crafting/iron_rod_pre_end");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)NetherBrickFenceGateModule.netherBrickFenceGate).pattern("#W#").pattern("#W#").define(Character.valueOf('#'), Tags.Items.BRICKS_NETHER).define(Character.valueOf('W'), (ItemLike)Blocks.NETHER_BRICKS.asItem()).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("nether_brick_fence_gate")}), "quark:automation/crafting/nether_brick_fence_gate");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)ObsidianPlateModule.obsidian_plate).pattern("OO").define(Character.valueOf('O'), Tags.Items.OBSIDIANS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("obsidian_plate")}), "quark:automation/crafting/obsidian_plate");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)RedstoneRandomizerModule.redstone_randomizer).pattern(" X ").pattern("XBX").pattern("III").define(Character.valueOf('X'), (ItemLike)Items.REDSTONE_TORCH).define(Character.valueOf('I'), (ItemLike)Items.STONE).define(Character.valueOf('B'), (ItemLike)Items.PRISMARINE_CRYSTALS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("redstone_randomizer")}), "quark:automation/crafting/redstone_randomizer");
        for (Map.Entry<Block, Block> chestEntry : VariantChestsModule.regularChests.entrySet()) {
            QuarkRecipeProvider.chestRecipe((ItemLike)chestEntry.getValue().asItem(), (ItemLike)chestEntry.getKey()).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput, "quark:building/chests/" + BuiltInRegistries.BLOCK.getKey((Object)chestEntry.getValue()).getPath());
        }
        for (Map.Entry<Block, Block> chestEntry : VariantChestsModule.trappedChests.entrySet()) {
            QuarkRecipeProvider.trappedChestRecipe((ItemLike)chestEntry.getValue().asItem(), (ItemLike)chestEntry.getKey()).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput, "quark:building/chests/" + BuiltInRegistries.BLOCK.getKey((Object)chestEntry.getValue()).getPath());
        }
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.APPLE, (ItemLike)CompressedBlocksModule.apple, recipeOutput, null, "apple_crate");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.BEETROOT, (ItemLike)CompressedBlocksModule.beetroot, recipeOutput, null, "beetroot_crate");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.SWEET_BERRIES, (ItemLike)CompressedBlocksModule.berry, recipeOutput, null, "berry_sack");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.LEATHER, (ItemLike)CompressedBlocksModule.leather, recipeOutput, null, "bonded_leather");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.RABBIT_HIDE, (ItemLike)CompressedBlocksModule.hide, recipeOutput, null, "bonded_rabbit_hide");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.CACTUS, (ItemLike)CompressedBlocksModule.cactus, recipeOutput, null, "cactus_block");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.CARROT, (ItemLike)CompressedBlocksModule.carrot, recipeOutput, null, "carrot_crate");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.CHARCOAL, (ItemLike)CompressedBlocksModule.charcoal_block, recipeOutput, null, "charcoal_block");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.CHORUS_FRUIT, (ItemLike)CompressedBlocksModule.chorus, recipeOutput, null, "chorus_fruit_block");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.COCOA_BEANS, (ItemLike)CompressedBlocksModule.cocoa, recipeOutput, null, "cocoa_beans_sack");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.GLOW_BERRIES, (ItemLike)CompressedBlocksModule.glowberry, recipeOutput, null, "glowberry_sack");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.GOLDEN_APPLE, (ItemLike)CompressedBlocksModule.golden_apple_crate, recipeOutput, null, "golden_apple_crate");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.GOLDEN_CARROT, (ItemLike)CompressedBlocksModule.golden_carrot, recipeOutput, null, "golden_carrot_crate");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.GUNPOWDER, (ItemLike)CompressedBlocksModule.gunpowder, recipeOutput, null, "gunpowder_sack");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.NETHER_WART_BLOCK).requires((ItemLike)Items.NETHER_WART).requires((ItemLike)Items.NETHER_WART).requires((ItemLike)Items.NETHER_WART).requires((ItemLike)Items.NETHER_WART).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("nether_wart_sack")}), "quark:building/crafting/compressed/vanilla_nether_wart_block_4x4");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.NETHER_WART, (ItemLike)CompressedBlocksModule.wart, recipeOutput, null, "nether_wart_sack");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.POTATO, (ItemLike)CompressedBlocksModule.potato, recipeOutput, null, "potato_crate");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.STICK, (ItemLike)CompressedBlocksModule.stick_block, recipeOutput, null, "stick_block");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.SUGAR_CANE, (ItemLike)CompressedBlocksModule.sugarCane, recipeOutput, null, "sugar_cane_block");
        QuarkRecipeProvider.variantFurnace((ItemLike)Blocks.BLACKSTONE, VariantFurnacesModule.blackstoneFurnace, recipeOutput, "blackstone");
        QuarkRecipeProvider.variantFurnace((ItemLike)Blocks.DEEPSLATE, VariantFurnacesModule.deepslateFurnace, recipeOutput, "deepslate");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)FramedGlassModule.framed_glass, (int)8).pattern("IGI").pattern("G G").pattern("IGI").define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS_COLORLESS).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("framed_glass")}), "quark:building/crafting/glass/framed_glass");
        for (DyeColor dyeColor : FramedGlassModule.blockMap.keySet()) {
            QuarkRecipeProvider.dyedFramedGlassRecipe((ItemLike)FramedGlassModule.blockMap.get(dyeColor).getBlock(), dyeColor).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("framed_glass")}), "quark:building/glass/" + dyeColor.getName() + "_framed_glass");
        }
        for (Block sourceLog : HollowLogsModule.logMap.keySet()) {
            condition = QuarkRecipeProvider.zCond("hollow_logs");
            if (sourceLog.getDescriptionId().contains("ancient")) {
                condition = this.and(new ICondition[]{QuarkRecipeProvider.zCond("hollow_logs"), QuarkRecipeProvider.zCond("ancient_wood")});
            } else if (sourceLog.getDescriptionId().contains("azalea")) {
                condition = this.and(new ICondition[]{QuarkRecipeProvider.zCond("hollow_logs"), QuarkRecipeProvider.zCond("azalea_wood")});
            }
            QuarkRecipeProvider.hollowLogRecipe((ItemLike)HollowLogsModule.logMap.get(sourceLog), (ItemLike)sourceLog).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{condition}), "quark:building/crafting/hollowlogs/hollow_" + sourceLog.getDescriptionId().replaceAll("block..*.[.]", ""));
        }
        for (RainbowLampBlock rbl : RainbowLampsModule.lamps) {
            CorundumColor color = RainbowLampsModule.lampMap.get((Object)rbl);
            QuarkRecipeProvider.corundomLampRecipe((ItemLike)rbl, color).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("rainbow_lamps"), QuarkRecipeProvider.zCond("corundum"), QuarkRecipeProvider.zCond("rainbow_lamp_corundum")}), "quark:building/crafting/lamps/" + color.name + "_corundum_lamp");
            QuarkRecipeProvider.crystalLampRecipe((ItemLike)rbl, color).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("rainbow_lamps"), this.or(new ICondition[]{this.not((ICondition)QuarkRecipeProvider.zCond("corundum")), this.not((ICondition)QuarkRecipeProvider.zCond("rainbow_lamp_corundum"))})}), "quark:building/crafting/lamps/" + color.name + "_crsytal_lamp");
        }
        for (DyeColor dyeColor : FramedGlassModule.paneMap.keySet()) {
            QuarkRecipeProvider.paneRecipe((ItemLike)FramedGlassModule.blockMap.get(dyeColor).getBlock(), (ItemLike)FramedGlassModule.blockMap.get(dyeColor).getBlock()).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("framed_glass")}), "quark:building/panes/" + dyeColor.getName() + "_framed_glass_pane");
        }
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)JapanesePaletteModule.paperWall, (int)6).pattern("###").pattern("PPP").pattern("###").define(Character.valueOf('#'), (ItemLike)Items.BAMBOO).define(Character.valueOf('P'), (ItemLike)Items.PAPER).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("paper_decor")}), "quark:building/crafting/panes/paper_wall");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)JapanesePaletteModule.paperWallBig, (int)4).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)JapanesePaletteModule.paperWall).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("paper_decor")}), "quark:tweaks/crafting/panes/paper_wall_big");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ShinglesModule.blocks.getFirst()), (int)2).pattern("##").define(Character.valueOf('#'), (ItemLike)Blocks.TERRACOTTA).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("shingles")}), "quark:building/crafting/shingles/shingles");
        for (DyeColor dyeColor : ShinglesModule.blockMap.keySet()) {
            QuarkRecipeProvider.colorShingles((ItemLike)ShinglesModule.blockMap.get(dyeColor).getBlock(), dyeColor, recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("shingles")}));
        }
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Quark.ZETA.variantRegistry.slabs.get(DuskboundBlocksModule.blocks.get(0))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)DuskboundBlocksModule.blocks.get(0)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)DuskboundBlocksModule.blocks.get(0))), QuarkRecipeProvider.has((ItemLike)((ItemLike)DuskboundBlocksModule.blocks.get(0)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("duskbound_blocks")}), "quark:building/crafting/slabs/duskbound_slab");
        QuarkRecipeProvider.stairBuilder((ItemLike)((ItemLike)Quark.ZETA.variantRegistry.stairs.get(DuskboundBlocksModule.blocks.get(0))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)DuskboundBlocksModule.blocks.get(0)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)DuskboundBlocksModule.blocks.get(0))), QuarkRecipeProvider.has((ItemLike)((ItemLike)DuskboundBlocksModule.blocks.get(0)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("duskbound_blocks")}), "quark:building/crafting/stairs/duskbound_stairs");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)MoreStoneVariantsModule.polishedCalcite).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)Blocks.CALCITE).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("calcite")}), "quark:building/crafting/stonevariants/polished_calcite");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)MoreStoneVariantsModule.polishedDripstone).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)Blocks.DRIPSTONE_BLOCK).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("dripstone")}), "quark:building/crafting/stonevariants/polished_dripstone");
        for (Block slab : VerticalSlabsModule.blocks.keySet()) {
            condition = QuarkRecipeProvider.zCond("vertical_slabs");
            if (slab.getDescriptionId().contains("ancient")) {
                condition = this.and(new ICondition[]{QuarkRecipeProvider.zCond("vertical_slabs"), QuarkRecipeProvider.zCond("ancient_wood")});
            } else if (slab.getDescriptionId().contains("azalea")) {
                condition = this.and(new ICondition[]{QuarkRecipeProvider.zCond("vertical_slabs"), QuarkRecipeProvider.zCond("azalea_wood")});
            }
            String slabName = BuiltInRegistries.BLOCK.getKey((Object)slab).getPath().replace("_slab", "");
            QuarkRecipeProvider.vertslabRecipe(RecipeCategory.BUILDING_BLOCKS, (ItemLike)VerticalSlabsModule.blocks.get(slab), Ingredient.of((ItemLike[])new ItemLike[]{slab})).unlockedBy("obtained_slab", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{slab.asItem()})).save(recipeOutput.withConditions(new ICondition[]{condition}), "quark:building/crafting/vertslabs/" + slabName + "_vertical_slab");
        }
        for (IZetaBlock baseBlock : Quark.ZETA.variantRegistry.walls.keySet()) {
            Block base = baseBlock.getBlock();
            FlagCondition condition2 = QuarkRecipeProvider.zCond("");
            Block wallBlock = (Block)Quark.ZETA.variantRegistry.walls.get(baseBlock);
            String dir = "quark:building/crafting/walls/";
            if (base.getDescriptionId().contains("limestone") || base.getDescriptionId().contains("jasper") || base.getDescriptionId().contains("shale") || base.getDescriptionId().contains("myalite") || base.getDescriptionId().contains("myalite") || base.getDescriptionId().contains("permafrost") || base.getDescriptionId().contains("andesite") || base.getDescriptionId().contains("diorite") || base.getDescriptionId().contains("granite")) {
                dir = "quark:world/crafting/walls/";
                if (base.getDescriptionId().contains("andesite") || base.getDescriptionId().contains("diorite") || base.getDescriptionId().contains("granite")) {
                    condition2 = QuarkRecipeProvider.zCond("more_stone_variants");
                } else if (base.getDescriptionId().contains("jasper")) {
                    condition2 = QuarkRecipeProvider.zCond("limestone");
                } else if (base.getDescriptionId().contains("limestone")) {
                    condition2 = QuarkRecipeProvider.zCond("limestone");
                } else if (base.getDescriptionId().contains("myalite")) {
                    condition2 = QuarkRecipeProvider.zCond("myalite");
                } else if (base.getDescriptionId().contains("permafrost")) {
                    condition2 = QuarkRecipeProvider.zCond("permafrost");
                }
            } else {
                dir = "quark:building/crafting/walls/";
                if (base.getDescriptionId().contains("blackstone_bricks")) {
                    condition2 = QuarkRecipeProvider.zCond("blackstone_bricks");
                } else if (base.getDescriptionId().contains("blue_nether_bricks")) {
                    condition2 = QuarkRecipeProvider.zCond("blue_nether_bricks");
                } else if (base.getDescriptionId().contains("calcite_bricks")) {
                    condition2 = QuarkRecipeProvider.zCond("more_stone_variants");
                } else if (base.getDescriptionId().equals("block.minecraft.calcite")) {
                    condition2 = QuarkRecipeProvider.zCond("calcite");
                } else if (base.getDescriptionId().contains("cobblestone_bricks")) {
                    condition2 = QuarkRecipeProvider.zCond("cobblestone_bricks");
                } else if (base.getDescriptionId().contains("dirt_bricks")) {
                    condition2 = QuarkRecipeProvider.zCond("dirt_bricks");
                } else if (base.getDescriptionId().equals("block.minecraft.dripstone_block")) {
                    condition2 = QuarkRecipeProvider.zCond("dripstone");
                } else if (base.getDescriptionId().contains("dripstone_bricks")) {
                    condition2 = QuarkRecipeProvider.zCond("dripstone");
                } else if (base.getDescriptionId().contains("mossy_cobblestone_bricks")) {
                    condition2 = QuarkRecipeProvider.zCond("cobblestone_bricks");
                } else if (base.getDescriptionId().contains("netherrack_bricks")) {
                    condition2 = QuarkRecipeProvider.zCond("netherrack_bricks");
                } else if (base.getDescriptionId().contains("raw")) {
                    condition2 = QuarkRecipeProvider.zCond("raw_metal_bricks");
                } else if (base.getDescriptionId().contains("sandstone_bricks")) {
                    condition2 = QuarkRecipeProvider.zCond("sandstone_bricks");
                } else if (base.getDescriptionId().contains("soul_sandstone")) {
                    condition2 = QuarkRecipeProvider.zCond("soul_sandstone");
                } else if (base.getDescriptionId().contains("tuff")) {
                    condition2 = QuarkRecipeProvider.zCond("tuff");
                } else if (base.getDescriptionId().contains("tuff")) {
                    condition2 = QuarkRecipeProvider.zCond("tuff");
                }
            }
            if (Objects.equals(condition2, QuarkRecipeProvider.zCond(""))) {
                System.out.println("Wall is missing a condition:" + String.valueOf(wallBlock));
            }
            QuarkRecipeProvider.wallBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)wallBlock, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{base})).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{condition2}), dir + BuiltInRegistries.BLOCK.getKey((Object)base).getPath() + "_wall");
        }
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Blocks.BOOKSHELF).pattern("###").pattern("XXX").pattern("###").define(Character.valueOf('#'), (ItemLike)Blocks.OAK_PLANKS).define(Character.valueOf('X'), (ItemLike)Items.BOOK).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("variant_bookshelves")}), "quark:building/crafting/bookshelves/oak_bookshelf");
        int i = 0;
        for (VanillaWoods.Wood type : VanillaWoods.NON_OAK) {
            String name = type.name();
            Block plank = type.planks();
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)VariantBookshelvesModule.variantBookshelves.get(i))).pattern("###").pattern("XXX").pattern("###").define(Character.valueOf('#'), (ItemLike)plank).define(Character.valueOf('X'), (ItemLike)Items.BOOK).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("variant_bookshelves")}), "quark:building/crafting/bookshelves/" + name + "_bookshelf");
            ++i;
        }
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AncientWoodModule.woodSet.bookshelf).pattern("###").pattern("XXX").pattern("###").define(Character.valueOf('#'), (ItemLike)AncientWoodModule.woodSet.planks).define(Character.valueOf('X'), (ItemLike)Items.BOOK).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("variant_bookshelves"), QuarkRecipeProvider.zCond("ancient_wood")})}), "quark:building/crafting/bookshelves/ancient_bookshelf");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AzaleaWoodModule.woodSet.bookshelf).pattern("###").pattern("XXX").pattern("###").define(Character.valueOf('#'), (ItemLike)AncientWoodModule.woodSet.planks).define(Character.valueOf('X'), (ItemLike)Items.BOOK).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("variant_bookshelves"), QuarkRecipeProvider.zCond("azalea_wood")})}), "quark:building/crafting/bookshelves/azalea_bookshelf");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)BlossomTreesModule.woodSet.bookshelf).pattern("###").pattern("XXX").pattern("###").define(Character.valueOf('#'), (ItemLike)BlossomTreesModule.woodSet.planks).define(Character.valueOf('X'), (ItemLike)Items.BOOK).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("variant_bookshelves"), QuarkRecipeProvider.zCond("blossom_trees")})}), "quark:building/crafting/bookshelves/blossom_bookshelf");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Blocks.LECTERN).pattern("SSS").pattern(" B ").pattern(" S ").define(Character.valueOf('S'), ItemTags.WOODEN_SLABS).define(Character.valueOf('B'), Tags.Items.BOOKSHELVES).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("variant_bookshelves")}), "quark:building/crafting/bookshelves/lectern_with_variant_bookshelves");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(6)), (int)4).pattern("C#").pattern("##").define(Character.valueOf('C'), (ItemLike)MoreBrickTypesModule.blocks.get(4)).define(Character.valueOf('#'), (ItemLike)Blocks.BLACKSTONE).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("blackstone_bricks")}), "quark:building/crafting/blackstone_bricks");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)CompressedBlocksModule.blaze_lantern).pattern("BPB").pattern("PPP").pattern("BPB").define(Character.valueOf('B'), (ItemLike)Items.BLAZE_ROD).define(Character.valueOf('P'), (ItemLike)Items.BLAZE_POWDER).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("blaze_lantern")}), "quark:building/crafting/blaze_lantern");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(0)), (int)2).requires((ItemLike)Blocks.NETHER_BRICKS).requires((ItemLike)Blocks.WARPED_WART_BLOCK).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("blue_nether_bricks")}), "quark:building/crafting/blue_nether_bricks");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MoreMudBlocksModule.blocks.get(0)), (int)2).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)Blocks.MUD_BRICK_SLAB).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("more_mud_blocks")}), "quark:building/crafting/carved_mud_bricks");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)SoulSandstoneModule.blocks.get(1))).pattern("#").pattern("#").define(Character.valueOf('#'), (ItemLike)Quark.ZETA.variantRegistry.slabs.get(SoulSandstoneModule.blocks.get(0))).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("soul_sandstone")}), "quark:building/crafting/chiseled_soul_sandstone");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)DuskboundBlocksModule.blocks.get(0)), (int)16).pattern("PPP").pattern("POP").pattern("PPP").define(Character.valueOf('P'), (ItemLike)Blocks.PURPUR_BLOCK).define(Character.valueOf('O'), (ItemLike)SpiralSpiresModule.dusky_myalite).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("duskbound_blocks"), QuarkRecipeProvider.zCond("spiral_spires")})}), "quark:building/crafting/duskbound_block");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)DuskboundBlocksModule.blocks.get(0)), (int)16).pattern("PPP").pattern("POP").pattern("PPP").define(Character.valueOf('P'), (ItemLike)Blocks.PURPUR_BLOCK).define(Character.valueOf('O'), (ItemLike)Blocks.OBSIDIAN).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("duskbound_blocks"), this.not((ICondition)QuarkRecipeProvider.zCond("spiral_spires"))})}), "quark:building/crafting/duskbound_block_without_myalite");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)DuskboundBlocksModule.blocks.get(1)), (int)4).pattern("DDD").pattern("DED").pattern("DDD").define(Character.valueOf('D'), (ItemLike)DuskboundBlocksModule.blocks.get(0)).define(Character.valueOf('E'), (ItemLike)Items.ENDER_PEARL).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("duskbound_blocks")}), "quark:building/crafting/duskbound_lantern");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)SoulSandstoneModule.blocks.get(0))).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)Blocks.SOUL_SAND).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("soul_sandstone")}), "quark:building/crafting/soul_sandstone");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)SoulSandstoneModule.blocks.get(1))).pattern("#").pattern("#").define(Character.valueOf('#'), (ItemLike)SoulSandstoneModule.blocks.get(0)).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("soul_sandstone")}), "quark:building/crafting/chiseled_soul_sandstone");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)SoulSandstoneModule.blocks.get(3))).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)SoulSandstoneModule.blocks.get(0)).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("soul_sandstone")}), "quark:building/crafting/cut_soul_sandstone");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)GrateModule.grate).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)Blocks.IRON_BARS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("grate")}), "quark:building/crafting/grate");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)SturdyStoneModule.sturdy_stone).pattern("CCC").pattern("CCC").pattern("CCC").define(Character.valueOf('C'), (ItemLike)Blocks.COBBLESTONE).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{this.not(this.modLoaded("cyclic")), QuarkRecipeProvider.zCond("sturdy_stone")})}), "quark:building/crafting/sturdy_stone");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)SturdyStoneModule.sturdy_stone).pattern("SCS").pattern("CCC").pattern("SCS").define(Character.valueOf('C'), (ItemLike)Blocks.COBBLESTONE).define(Character.valueOf('S'), (ItemLike)Blocks.STONE).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{this.modLoaded("cyclic"), QuarkRecipeProvider.zCond("sturdy_stone")})}), "quark:building/crafting/sturdy_stone_cyclic");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.COBBLESTONE, (int)9).requires((ItemLike)SturdyStoneModule.sturdy_stone).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{this.not(this.modLoaded("cyclic")), QuarkRecipeProvider.zCond("sturdy_stone")})}), "quark:building/crafting/sturdy_stone_uncompress");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)VariantSelectorModule.hammer).pattern("III").pattern("ISI").pattern(" S ").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("hammer")}), "quark:experimental/crafting/hammer");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)BackpackModule.backpack).pattern("LRL").pattern("LCL").pattern("LIL").define(Character.valueOf('L'), Tags.Items.LEATHERS).define(Character.valueOf('R'), (ItemLike)BackpackModule.ravager_hide).define(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("backpack"), QuarkRecipeProvider.zCond("ravager_hide")})}), "quark:oddities/crafting/backpack");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)BackpackModule.backpack).pattern("LIL").pattern("LCL").pattern("LIL").define(Character.valueOf('L'), Tags.Items.LEATHERS).define(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("backpack"), this.not((ICondition)QuarkRecipeProvider.zCond("ravager_hide"))})}), "quark:oddities/crafting/backpack_no_hide");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)BackpackModule.ravager_hide, (int)9).requires((ItemLike)BackpackModule.bonded_ravager_hide).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("ravager_hide")}), "quark:oddities/crafting/bonded_ravager_hide_uncompress");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)BackpackModule.bonded_ravager_hide).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)BackpackModule.ravager_hide).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("ravager_hide")}), "quark:oddities/crafting/bonded_ravager_hide");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)CrateModule.crate).pattern("IWI").pattern("WCW").pattern("IWI").define(Character.valueOf('W'), ItemTags.PLANKS).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("crate")}), "quark:oddities/crafting/crate");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)PipesModule.encasedPipe).requires((ItemLike)PipesModule.pipe).requires(Tags.Items.GLASS_BLOCKS_COLORLESS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("encased_pipes")}), "quark:oddities/crafting/encased_pipe");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)PipesModule.pipe).requires((ItemLike)PipesModule.encasedPipe).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("encased_pipes")}), "quark:oddities/crafting/encased_pipe_revert");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)MagnetsModule.magnet).pattern("CIC").pattern("BFR").pattern("CIC").define(Character.valueOf('C'), Tags.Items.COBBLESTONES).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('B'), Tags.Items.DYES_BLUE).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('F'), (ItemLike)Items.CHORUS_FRUIT).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("magnet"), this.not((ICondition)QuarkRecipeProvider.zCond("magnet_pre_end"))})}), "quark:oddities/crafting/magnet");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)MagnetsModule.magnet).pattern("CIC").pattern("BPR").pattern("CIC").define(Character.valueOf('C'), Tags.Items.COBBLESTONES).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('B'), Tags.Items.DYES_BLUE).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('P'), Tags.Items.INGOTS_COPPER).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("magnet"), QuarkRecipeProvider.zCond("magnet_pre_end")})}), "quark:oddities/crafting/magnet_pre_end");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)PipesModule.pipe).pattern("I").pattern("G").pattern("I").define(Character.valueOf('I'), Tags.Items.INGOTS_COPPER).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("pipes")}), "quark:oddities/crafting/pipe");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)TinyPotatoModule.tiny_potato).pattern("H").pattern("P").define(Character.valueOf('H'), (ItemLike)StonelingsModule.diamondHeart).define(Character.valueOf('P'), (ItemLike)Items.POTATO).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("tiny_potato"), QuarkRecipeProvider.zCond("stonelings"), this.not((ICondition)QuarkRecipeProvider.zCond("tiny_potato_never_uses_heart"))})}), "quark:oddities/crafting/tiny_potato_heart");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)TinyPotatoModule.tiny_potato).pattern("D").pattern("P").define(Character.valueOf('D'), Ingredient.of((ItemLike[])new ItemLike[]{Items.DIAMOND, Items.EMERALD})).define(Character.valueOf('P'), (ItemLike)Items.POTATO).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("tiny_potato"), this.or(new ICondition[]{QuarkRecipeProvider.zCond("tiny_potato_never_uses_heart"), this.not((ICondition)QuarkRecipeProvider.zCond("stonelings"))})})}), "quark:oddities/crafting/tiny_potato_no_heart");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)AbacusModule.abacus).pattern("WSW").pattern("WIW").pattern("WSW").define(Character.valueOf('W'), ItemTags.PLANKS).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("abacus")}), "quark:tools/crafting/abacus");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)PickarangModule.pickarang).pattern("DWH").pattern("  W").pattern("  D").define(Character.valueOf('W'), ItemTags.PLANKS).define(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).define(Character.valueOf('H'), (ItemLike)StonelingsModule.diamondHeart).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("pickarang"), QuarkRecipeProvider.zCond("stonelings"), QuarkRecipeProvider.zCond("pickarang_never_uses_heart")})}), "quark:tools/crafting/pickarang_heart");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)PickarangModule.pickarang).pattern("DWD").pattern("  W").pattern("  D").define(Character.valueOf('W'), ItemTags.PLANKS).define(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("pickarang"), this.or(new ICondition[]{QuarkRecipeProvider.zCond("pickarang_never_uses_heart"), this.not((ICondition)QuarkRecipeProvider.zCond("stonelings"))})})}), "quark:tools/crafting/pickarang_no_heart");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)ColorRunesModule.rune).pattern("#S#").pattern("#C#").pattern("###").define(Character.valueOf('#'), TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"quark", (String)"corundum"))).define(Character.valueOf('S'), Tags.Items.COBBLESTONES).define(Character.valueOf('C'), (ItemLike)ColorRunesModule.rune).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("color_runes")}), "quark:tools/crafting/rune_duplication");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)SeedPouchModule.seed_pouch, (int)1).pattern(" S ").pattern("HXH").pattern(" H ").define(Character.valueOf('S'), (ItemLike)Items.STRING).define(Character.valueOf('H'), TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"quark", (String)"seed_pouch_holdable"))).define(Character.valueOf('X'), (ItemLike)ColorRunesModule.rune).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("seed_pouch")}), "quark:tools/crafting/seed_pouch");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)TorchArrowModule.torch_arrow).requires((ItemLike)Items.TORCH).requires((ItemLike)Items.ARROW).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("torch_arrow")}), "quark:tools/crafting/torch_arrow");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)TrowelModule.trowel).pattern("S  ").pattern(" II").define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("trowel")}), "quark:tools/crafting/trowel");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)GlassShardModule.dirtyGlassPane, (int)16).pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)GlassShardModule.dirtyGlass).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("glass_shard")}), "quark:tweaks/crafting/panes/dirty_glass_pane");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)Items.BREAD).pattern("##").pattern("# ").define(Character.valueOf('#'), (ItemLike)Items.WHEAT).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("bent_recipes")}), "quark:tweaks/crafting/utility/bent/bread");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)Items.COOKIE).pattern("X#").pattern("# ").define(Character.valueOf('#'), (ItemLike)Items.WHEAT).define(Character.valueOf('X'), (ItemLike)Items.COCOA_BEANS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("bent_recipes")}), "quark:tweaks/crafting/utility/bent/cookie");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.PAPER, (int)3).pattern("##").pattern("# ").define(Character.valueOf('#'), (ItemLike)Items.SUGAR_CANE).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("bent_recipes")}), "quark:tweaks/crafting/utility/bent/paper");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.PINK_DYE).requires(Ingredient.of((ItemLike[])new ItemLike[]{Items.BRAIN_CORAL, Items.BRAIN_CORAL_FAN})).group("pink_dye").unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("coral_to_dye")}), "quark:tweaks/crafting/utility/coral/brain_to_pink");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.MAGENTA_DYE).requires(Ingredient.of((ItemLike[])new ItemLike[]{Items.BUBBLE_CORAL, Items.BUBBLE_CORAL_FAN})).group("magenta_dye").unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("coral_to_dye")}), "quark:tweaks/crafting/utility/coral/bubble_to_magenta");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.RED_DYE).requires(Ingredient.of((ItemLike[])new ItemLike[]{Items.FIRE_CORAL, Items.FIRE_CORAL_FAN})).group("red_dye").unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("coral_to_dye")}), "quark:tweaks/crafting/utility/coral/fire_to_red");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.YELLOW_DYE).requires(Ingredient.of((ItemLike[])new ItemLike[]{Items.HORN_CORAL, Items.HORN_CORAL_FAN})).group("yellow_dye").unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("coral_to_dye")}), "quark:tweaks/crafting/utility/coral/horn_to_yellow");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.BLUE_DYE).requires(Ingredient.of((ItemLike[])new ItemLike[]{Items.TUBE_CORAL, Items.TUBE_CORAL_FAN})).group("blue_dye").unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("coral_to_dye")}), "quark:tweaks/crafting/utility/coral/tube_to_blue");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.STONE_SWORD).pattern("#").pattern("#").pattern("S").define(Character.valueOf('#'), QuarkTags.Items.STONE_TOOL_MATERIALS).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("better_stone_tools")}), "quark:tweaks/crafting/utility/better_stone_tools/sword");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.STONE_SHOVEL).pattern("#").pattern("S").pattern("S").define(Character.valueOf('#'), QuarkTags.Items.STONE_TOOL_MATERIALS).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("better_stone_tools")}), "quark:tweaks/crafting/utility/better_stone_tools/shovel");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.STONE_PICKAXE).pattern("###").pattern(" S ").pattern(" S ").define(Character.valueOf('#'), QuarkTags.Items.STONE_TOOL_MATERIALS).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("better_stone_tools")}), "quark:tweaks/crafting/utility/better_stone_tools/pickaxe");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.STONE_AXE).pattern("##").pattern("#S").pattern(" S").define(Character.valueOf('#'), QuarkTags.Items.STONE_TOOL_MATERIALS).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("better_stone_tools")}), "quark:tweaks/crafting/utility/better_stone_tools/axe");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.STONE_AXE).pattern("##").pattern(" S").pattern(" S").define(Character.valueOf('#'), QuarkTags.Items.STONE_TOOL_MATERIALS).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("better_stone_tools")}), "quark:tweaks/crafting/utility/better_stone_tools/hoe");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.BLACK_DYE).requires((ItemLike)Items.CHARCOAL).group("black_dye").unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("charcoal_to_dye")}), "quark:tweaks/crafting/utility/misc/charcoal_to_black_dye");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.CHEST_MINECART).pattern("#C#").pattern("###").define(Character.valueOf('#'), Tags.Items.INGOTS_IRON).define(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("minecart_upgrade")}), "quark:tweaks/crafting/utility/misc/chest_minecart");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.DISPENSER).requires((ItemLike)Items.BOW).requires((ItemLike)Items.DROPPER).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("dropper_upgrade")}), "quark:tweaks/crafting/utility/misc/dispenser_bow");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.DISPENSER).pattern(" #X").pattern("#DX").pattern(" #X").define(Character.valueOf('#'), Tags.Items.RODS_WOODEN).define(Character.valueOf('X'), (ItemLike)Items.STRING).define(Character.valueOf('D'), (ItemLike)Items.DROPPER).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("dropper_upgrade")}), "quark:tweaks/crafting/utility/misc/dispenser_no_bow");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.HOPPER).pattern("IWI").pattern("IWI").pattern(" I ").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('W'), ItemTags.LOGS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("easy_hopper")}), "quark:tweaks/crafting/utility/misc/easy_hopper");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.STICK, (int)16).pattern("#").pattern("#").define(Character.valueOf('#'), ItemTags.LOGS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("easy_sticks")}), "quark:tweaks/crafting/utility/misc/easy_sticks");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.STICK, (int)8).pattern("#").pattern("#").define(Character.valueOf('#'), ItemTags.BAMBOO_BLOCKS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("easy_sticks")}), "quark:tweaks/crafting/utility/misc/easy_sticks_bamboo");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.FURNACE_MINECART).pattern("#X#").pattern("###").define(Character.valueOf('#'), Tags.Items.INGOTS_IRON).define(Character.valueOf('X'), (ItemLike)Items.FURNACE).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("minecart_upgrade")}), "quark:tweaks/crafting/utility/misc/furnace_minecart");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.HOPPER_MINECART).pattern("#X#").pattern("###").define(Character.valueOf('#'), Tags.Items.INGOTS_IRON).define(Character.valueOf('X'), (ItemLike)Items.HOPPER).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("minecart_upgrade")}), "quark:tweaks/crafting/utility/misc/hopper_minecart");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.HOPPER_MINECART).pattern("X X").pattern("#X#").pattern("III").define(Character.valueOf('#'), Tags.Items.RODS_WOODEN).define(Character.valueOf('X'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('I'), (ItemLike)Items.STONE).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("repeater_and_torches")}), "quark:tweaks/crafting/utility/misc/repeater");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.TNT_MINECART).pattern("#X#").pattern("###").define(Character.valueOf('#'), Tags.Items.INGOTS_IRON).define(Character.valueOf('X'), (ItemLike)Items.TNT).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("minecart_upgrade")}), "quark:tweaks/crafting/utility/misc/tnt_minecart");
        QuarkRecipeProvider.shardGlassRecipe(Items.BLACK_STAINED_GLASS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("glass_shard")}), "quark:tweaks/crafting/utility/glass/black_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.BLUE_STAINED_GLASS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("glass_shard")}), "quark:tweaks/crafting/utility/glass/blue_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.BROWN_STAINED_GLASS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("glass_shard")}), "quark:tweaks/crafting/utility/glass/brown_glass");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.GLASS).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)GlassShardModule.clearShard).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("glass_shard")}), "quark:tweaks/crafting/utility/glass/clear_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.CYAN_STAINED_GLASS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("glass_shard")}), "quark:tweaks/crafting/utility/glass/cyan_glass");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)GlassShardModule.dirtyGlass).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)GlassShardModule.dirtyShard).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("glass_shard")}), "quark:tweaks/crafting/utility/glass/dirty_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.GRAY_STAINED_GLASS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("glass_shard")}), "quark:tweaks/crafting/utility/glass/gray_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.GREEN_STAINED_GLASS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("glass_shard")}), "quark:tweaks/crafting/utility/glass/green_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.LIGHT_BLUE_STAINED_GLASS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("glass_shard")}), "quark:tweaks/crafting/utility/glass/light_blue_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.LIGHT_GRAY_STAINED_GLASS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("glass_shard")}), "quark:tweaks/crafting/utility/glass/light_gray_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.LIME_STAINED_GLASS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("glass_shard")}), "quark:tweaks/crafting/utility/glass/lime_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.MAGENTA_STAINED_GLASS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("glass_shard")}), "quark:tweaks/crafting/utility/glass/magenta_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.ORANGE_STAINED_GLASS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("glass_shard")}), "quark:tweaks/crafting/utility/glass/orange_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.PINK_STAINED_GLASS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("glass_shard")}), "quark:tweaks/crafting/utility/glass/pink_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.PURPLE_STAINED_GLASS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("glass_shard")}), "quark:tweaks/crafting/utility/glass/purple_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.RED_STAINED_GLASS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("glass_shard")}), "quark:tweaks/crafting/utility/glass/red_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.WHITE_STAINED_GLASS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("glass_shard")}), "quark:tweaks/crafting/utility/glass/white_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.YELLOW_STAINED_GLASS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("glass_shard")}), "quark:tweaks/crafting/utility/glass/yellow_glass");
    }

    public static ShapedRecipeBuilder chestRecipe(ItemLike output, ItemLike plank) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)output).pattern("###").pattern("# #").pattern("###").define(Character.valueOf('#'), plank);
    }

    public static ShapelessRecipeBuilder trappedChestRecipe(ItemLike output, ItemLike originalChest) {
        return ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)output).requires(originalChest).requires((ItemLike)Items.TRIPWIRE_HOOK);
    }

    public static ShapedRecipeBuilder shardGlassRecipe(Item output) {
        StainedGlassBlock glass = (StainedGlassBlock)Block.byItem((Item)output);
        DyeColor shardColor = glass.getColor();
        Item shard = GlassShardModule.shardColors.get(shardColor);
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)shard);
    }

    public static ShapelessRecipeBuilder dyedFramedGlassRecipe(ItemLike output, DyeColor dye) {
        return ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)8).requires((ItemLike)FramedGlassModule.framed_glass).requires((ItemLike)FramedGlassModule.framed_glass).requires((ItemLike)FramedGlassModule.framed_glass).requires((ItemLike)FramedGlassModule.framed_glass).requires((ItemLike)FramedGlassModule.framed_glass).requires((ItemLike)FramedGlassModule.framed_glass).requires((ItemLike)FramedGlassModule.framed_glass).requires((ItemLike)FramedGlassModule.framed_glass).requires((ItemLike)DyeItem.byColor((DyeColor)dye));
    }

    public static ShapedRecipeBuilder paneRecipe(ItemLike output, ItemLike glass) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)16).pattern("###").pattern("###").define(Character.valueOf('#'), glass);
    }

    public static ShapedRecipeBuilder corundomLampRecipe(ItemLike output, CorundumColor corundumColor) {
        Block corundum = CorundumModule.getCrystal(corundumColor);
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)output).pattern(" R ").pattern("RCR").pattern(" R ").define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('C'), (ItemLike)corundum);
    }

    public static ShapedRecipeBuilder crystalLampRecipe(ItemLike output, CorundumColor corundumColor) {
        Item dye = switch (corundumColor) {
            default -> throw new MatchException(null, null);
            case CorundumColor.RED -> Items.RED_DYE;
            case CorundumColor.ORANGE -> Items.ORANGE_DYE;
            case CorundumColor.YELLOW -> Items.YELLOW_DYE;
            case CorundumColor.GREEN -> Items.GREEN_DYE;
            case CorundumColor.BLUE -> Items.LIGHT_BLUE_DYE;
            case CorundumColor.INDIGO -> Items.BLUE_DYE;
            case CorundumColor.VIOLET -> Items.PINK_DYE;
            case CorundumColor.WHITE -> Items.WHITE_DYE;
            case CorundumColor.BLACK -> Items.BLACK_DYE;
        };
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)output).pattern(" D ").pattern("RAR").pattern(" G ").define(Character.valueOf('D'), (ItemLike)dye).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('A'), (ItemLike)Blocks.AMETHYST_BLOCK).define(Character.valueOf('G'), Tags.Items.DUSTS_GLOWSTONE);
    }

    public static ShapedRecipeBuilder hollowLogRecipe(ItemLike output, ItemLike solidLog) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)4).pattern(" L ").pattern("L L").pattern(" L ").define(Character.valueOf('L'), solidLog).unlockedBy("test", PlayerTrigger.TriggerInstance.tick());
    }

    public static RecipeBuilder vertslabRecipe(RecipeCategory category, ItemLike output, Ingredient input) {
        if (output == null || input == null) {
            System.out.println("Missing vertical/horizontal slab pair!!!");
        }
        return ShapedRecipeBuilder.shaped((RecipeCategory)category, (ItemLike)output, (int)3).define(Character.valueOf('#'), input).pattern("#").pattern("#").pattern("#");
    }

    public static void compressUncompress(ItemLike item, ItemLike block, RecipeOutput recipeOutput, String configFlag, String blockName) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)block).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), item).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond(blockName)}), "quark:building/crafting/compressed/" + blockName);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)item, (int)9).requires(block).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput, "quark:building/crafting/compressed/" + blockName + "uncompress");
    }

    public static void variantFurnace(ItemLike baseBlock, Block furnaceBlock, RecipeOutput recipeOutput, String blockName) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)furnaceBlock).pattern("###").pattern("# #").pattern("###").define(Character.valueOf('#'), baseBlock).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("variant_furnaces")}), "quark:building/crafting/furnaces/" + blockName + "_furnace");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Blocks.SMOKER).pattern(" # ").pattern("#X#").pattern(" # ").define(Character.valueOf('#'), ItemTags.LOGS).define(Character.valueOf('X'), (ItemLike)furnaceBlock).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("variant_furnaces")}), "quark:building/crafting/furnaces/" + blockName + "_smoker");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)furnaceBlock).pattern("III").pattern("IXI").pattern("###").define(Character.valueOf('#'), (ItemLike)Blocks.SMOOTH_STONE).define(Character.valueOf('X'), (ItemLike)furnaceBlock).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("variant_furnaces")}), "quark:building/crafting/furnaces/" + blockName + "_blast_furnace");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.FURNACE_MINECART).requires((ItemLike)furnaceBlock).requires((ItemLike)Items.MINECART).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("variant_furnaces")}), "quark:building/crafting/furnaces/" + blockName + "minecart");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)furnaceBlock).pattern("#X#").pattern("###").define(Character.valueOf('#'), Tags.Items.INGOTS_IRON).define(Character.valueOf('X'), (ItemLike)furnaceBlock).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("variant_furnaces"), QuarkRecipeProvider.zCond("minecart_upgrade")}), "quark:building/crafting/furnaces/" + blockName + "_minecarft_tweaked");
    }

    public static void colorShingles(ItemLike output, DyeColor color, RecipeOutput recipeOutput) {
        Block terracotta = switch (color) {
            default -> throw new MatchException(null, null);
            case DyeColor.BLACK -> Blocks.BLACK_TERRACOTTA;
            case DyeColor.BLUE -> Blocks.BLUE_TERRACOTTA;
            case DyeColor.BROWN -> Blocks.BROWN_TERRACOTTA;
            case DyeColor.YELLOW -> Blocks.YELLOW_TERRACOTTA;
            case DyeColor.CYAN -> Blocks.CYAN_TERRACOTTA;
            case DyeColor.GRAY -> Blocks.GRAY_TERRACOTTA;
            case DyeColor.GREEN -> Blocks.GREEN_TERRACOTTA;
            case DyeColor.WHITE -> Blocks.WHITE_TERRACOTTA;
            case DyeColor.ORANGE -> Blocks.ORANGE_TERRACOTTA;
            case DyeColor.MAGENTA -> Blocks.MAGENTA_TERRACOTTA;
            case DyeColor.LIGHT_BLUE -> Blocks.LIGHT_BLUE_TERRACOTTA;
            case DyeColor.LIME -> Blocks.LIME_TERRACOTTA;
            case DyeColor.PINK -> Blocks.PINK_TERRACOTTA;
            case DyeColor.LIGHT_GRAY -> Blocks.LIGHT_GRAY_TERRACOTTA;
            case DyeColor.PURPLE -> Blocks.PURPLE_TERRACOTTA;
            case DyeColor.RED -> Blocks.RED_TERRACOTTA;
        };
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)2).pattern("##").define(Character.valueOf('#'), (ItemLike)terracotta).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput, "quark:building/crafting/shingles/" + color.getName() + "_shingles");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)8).pattern("SSS").pattern("SDS").pattern("SSS").define(Character.valueOf('S'), (ItemLike)ShinglesModule.blocks.getFirst()).define(Character.valueOf('D'), (ItemLike)DyeItem.byColor((DyeColor)color)).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput, "quark:building/crafting/shingles/" + color.getName() + "_shingles_dye");
    }
}

