/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.building.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemFrameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.client.event.RenderItemInFrameEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.building.entity.GlassItemFrame;
import org.violetmoon.quark.content.building.module.GlassItemFrameModule;
import org.violetmoon.quark.mixin.mixins.client.accessor.AccessorEntityRenderDispatcher;

public class GlassItemFrameRenderer
extends EntityRenderer<GlassItemFrame> {
    private static final ModelResourceLocation LOCATION_MODEL = new ModelResourceLocation(Quark.asResource("extra/glass_item_frame"), "standalone");
    private static final List<Direction> SIGN_DIRECTIONS = List.of(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST);
    private static final BannerBlockEntity banner = new BannerBlockEntity(BlockPos.ZERO, Blocks.WHITE_BANNER.defaultBlockState());
    private final ModelPart bannerModel;
    private final Minecraft mc = Minecraft.getInstance();
    private final ItemRenderer itemRenderer;
    private final ItemFrameRenderer<?> defaultRenderer;

    public GlassItemFrameRenderer(EntityRendererProvider.Context context) {
        super(context);
        ModelPart part = context.bakeLayer(ModelLayers.BANNER);
        this.bannerModel = part.getChild("flag");
        Minecraft mc = Minecraft.getInstance();
        this.itemRenderer = mc.getItemRenderer();
        this.defaultRenderer = (ItemFrameRenderer)((AccessorEntityRenderDispatcher)mc.getEntityRenderDispatcher()).getRenderers().get(EntityType.ITEM_FRAME);
    }

    public void render(@NotNull GlassItemFrame frame, float yaw, float partialTicks, @NotNull PoseStack matrix, @NotNull MultiBufferSource buffer, int light) {
        super.render((Entity)frame, yaw, partialTicks, matrix, buffer, light);
        matrix.pushPose();
        Direction direction = frame.getDirection();
        Vec3 Vector3d = this.getRenderOffset(frame, partialTicks);
        matrix.translate(-Vector3d.x(), -Vector3d.y(), -Vector3d.z());
        matrix.translate((double)direction.getStepX() * 0.46875, (double)direction.getStepY() * 0.46875, (double)direction.getStepZ() * 0.46875);
        matrix.mulPose(Axis.XP.rotationDegrees(frame.getXRot()));
        matrix.mulPose(Axis.YP.rotationDegrees(180.0f - frame.getYRot()));
        BlockRenderDispatcher blockrendererdispatcher = this.mc.getBlockRenderer();
        ModelManager modelmanager = blockrendererdispatcher.getBlockModelShaper().getModelManager();
        ItemStack itemstack = frame.getItem();
        if (((Boolean)frame.getEntityData().get(GlassItemFrame.IS_SHINY)).booleanValue()) {
            light = 0xF000F0;
        }
        if (itemstack.isEmpty()) {
            matrix.pushPose();
            matrix.translate(-0.5, -0.5, -0.5);
            blockrendererdispatcher.getModelRenderer().renderModel(matrix.last(), buffer.getBuffer(Sheets.cutoutBlockSheet()), null, modelmanager.getModel(LOCATION_MODEL), 1.0f, 1.0f, 1.0f, light, OverlayTexture.NO_OVERLAY);
            matrix.popPose();
        } else {
            this.renderItemStack(frame, matrix, buffer, light, itemstack);
        }
        matrix.popPose();
    }

    @NotNull
    public Vec3 getRenderOffset(GlassItemFrame frame, float partialTicks) {
        return new Vec3((double)((float)frame.getDirection().getStepX() * 0.3f), -0.25, (double)((float)frame.getDirection().getStepZ() * 0.3f));
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull GlassItemFrame frame) {
        return InventoryMenu.BLOCK_ATLAS;
    }

    protected boolean shouldShowName(@NotNull GlassItemFrame frame) {
        if (Minecraft.renderNames() && !frame.getItem().isEmpty() && frame.getItem().has(DataComponents.CUSTOM_NAME) && this.entityRenderDispatcher.crosshairPickEntity == frame) {
            double d0 = this.entityRenderDispatcher.distanceToSqr((Entity)frame);
            float f = frame.isDiscrete() ? 32.0f : 64.0f;
            return d0 < (double)(f * f);
        }
        return false;
    }

    protected void renderNameTag(GlassItemFrame frame, Component text, PoseStack matrix, MultiBufferSource buffer, int light, float partialTick) {
        super.renderNameTag((Entity)frame, frame.getItem().getHoverName(), matrix, buffer, light, partialTick);
    }

    protected void renderItemStack(GlassItemFrame itemFrame, PoseStack matrix, MultiBufferSource buff, int light, ItemStack stack) {
        if (!stack.isEmpty()) {
            matrix.pushPose();
            MapItemSavedData mapdata = MapItem.getSavedData((ItemStack)stack, (Level)itemFrame.level());
            if (itemFrame.isOnSign()) {
                GlassItemFrame.SignAttachment attach = itemFrame.getSignAttachment();
                Direction ourDirection = itemFrame.getDirection().getOpposite();
                int signRotation = itemFrame.getOnSignRotation();
                int ourRotation = SIGN_DIRECTIONS.indexOf(ourDirection) * 4;
                int rotation = signRotation - ourRotation;
                float angle = (float)(-rotation) * 22.5f;
                float scale = 0.32f;
                switch (attach) {
                    case STANDING_BEHIND: {
                        angle += 180.0f;
                        break;
                    }
                    case WALL_SIGN: {
                        angle = 0.0f;
                        matrix.translate(0.0, -0.3, 0.45);
                        break;
                    }
                    case HANGING_FROM_WALL: {
                        angle = 0.0f;
                        matrix.translate(0.0, -0.52, -0.01);
                    }
                }
                matrix.translate(0.0, 0.35, 0.98);
                matrix.scale(scale, scale, scale);
                matrix.mulPose(Axis.YP.rotationDegrees(angle));
                switch (attach) {
                    case HANGING_IN_FRONT: {
                        matrix.translate(0.0, -0.52 / (double)scale, -0.075);
                        break;
                    }
                    case HANGING_BEHIND: {
                        matrix.translate(0.0, -0.52 / (double)scale, 0.3);
                    }
                }
                matrix.translate(0.0, 0.0, -0.5);
                matrix.translate(0.0, 0.0, -0.085);
            }
            int rotation = mapdata != null ? itemFrame.getRotation() % 4 * 2 : itemFrame.getRotation();
            matrix.mulPose(Axis.ZP.rotationDegrees((float)rotation * 360.0f / 8.0f));
            if (!((RenderItemInFrameEvent)NeoForge.EVENT_BUS.post((Event)new RenderItemInFrameEvent((ItemFrame)itemFrame, this.defaultRenderer, matrix, buff, light))).isCanceled()) {
                if (mapdata != null) {
                    matrix.mulPose(Axis.ZP.rotationDegrees(180.0f));
                    matrix.scale(0.0078125f, 0.0078125f, 0.0078125f);
                    matrix.translate(-64.0f, -64.0f, 62.5f);
                    MapId mapID = (MapId)stack.get(DataComponents.MAP_ID);
                    this.mc.gameRenderer.getMapRenderer().render(matrix, buff, mapID, mapdata, true, light);
                } else {
                    float s = (float)GlassItemFrameModule.itemRenderScale;
                    Item ourRotation = stack.getItem();
                    if (ourRotation instanceof BannerItem) {
                        BannerItem bannerItem = (BannerItem)ourRotation;
                        banner.fromItem(stack, bannerItem.getColor());
                        BannerPatternLayers patterns = banner.getPatterns();
                        matrix.pushPose();
                        matrix.translate(1.0E-4f, -0.5001f, 0.55f);
                        matrix.scale(0.799999f, 0.399999f, 0.5f);
                        BannerRenderer.renderPatterns((PoseStack)matrix, (MultiBufferSource)buff, (int)light, (int)OverlayTexture.NO_OVERLAY, (ModelPart)this.bannerModel, (Material)ModelBakery.BANNER_BASE, (boolean)true, (DyeColor)DyeColor.WHITE, (BannerPatternLayers)patterns);
                        matrix.popPose();
                    } else {
                        if (stack.getItem() instanceof ShieldItem) {
                            matrix.translate(-0.25f, 0.0f, 0.5f);
                            matrix.scale(s *= 2.6666667f, s, s);
                        } else {
                            matrix.translate(0.0f, 0.0f, 0.475f);
                            matrix.scale(s, s, s);
                        }
                        matrix.scale(0.5f, 0.5f, 0.5f);
                        this.itemRenderer.renderStatic(stack, ItemDisplayContext.FIXED, light, OverlayTexture.NO_OVERLAY, matrix, buff, (Level)this.mc.level, 0);
                    }
                }
            }
            matrix.popPose();
        }
    }
}

