/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tweaks.module;

import com.mojang.serialization.DynamicOps;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.event.EventHooks;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.play.entity.living.ZLivingConversion;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;

@ZetaLoadModule(category="tweaks")
public class ZombieVillagersOnNormalModule
extends ZetaModule {
    @PlayEvent
    public void onConversion(ZLivingConversion.Pre event) {
        Villager villager;
        Level level;
        if (event.getEntity().getType() == EntityType.VILLAGER && event.getOutcome() == EntityType.ZOMBIE_VILLAGER && (level = (villager = (Villager)event.getEntity()).level()) instanceof ServerLevelAccessor) {
            ServerLevelAccessor serverLevel = (ServerLevelAccessor)level;
            ZombieVillager zombievillager = (ZombieVillager)villager.convertTo(EntityType.ZOMBIE_VILLAGER, false);
            if (zombievillager == null) {
                return;
            }
            zombievillager.finalizeSpawn(serverLevel, level.getCurrentDifficultyAt(zombievillager.blockPosition()), MobSpawnType.CONVERSION, (SpawnGroupData)new Zombie.ZombieGroupData(false, true));
            zombievillager.setVillagerData(villager.getVillagerData());
            zombievillager.setGossips((Tag)villager.getGossips().store((DynamicOps)NbtOps.INSTANCE));
            zombievillager.setTradeOffers(villager.getOffers().copy());
            zombievillager.setVillagerXp(villager.getVillagerXp());
            EventHooks.onLivingConvert((LivingEntity)villager, (LivingEntity)zombievillager);
            level.levelEvent(null, 1026, villager.blockPosition(), 0);
            event.setCanceled(true);
        }
    }
}

