/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.mobs.module;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.loot.LootTable;
import net.neoforged.neoforge.common.Tags;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.mobs.client.render.entity.ToretoiseRenderer;
import org.violetmoon.quark.content.mobs.entity.Toretoise;
import org.violetmoon.zeta.advancement.ManualTrigger;
import org.violetmoon.zeta.client.event.load.ZClientSetup;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.config.type.CompoundBiomeConfig;
import org.violetmoon.zeta.config.type.DimensionConfig;
import org.violetmoon.zeta.config.type.EntitySpawnConfig;
import org.violetmoon.zeta.config.type.IBiomeConfig;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.load.ZEntityAttributeCreation;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;

@ZetaLoadModule(category="mobs")
public class ToretoiseModule
extends ZetaModule {
    public static EntityType<Toretoise> toretoiseType;
    public static final ResourceKey<LootTable> COAL_LOOT;
    public static final ResourceKey<LootTable> IRON_LOOT;
    public static final ResourceKey<LootTable> REDSTONE_LOOT;
    public static final ResourceKey<LootTable> LAPIS_LOOT;
    public static final ResourceKey<LootTable> COPPER_LOOT;
    @Config
    public static int maxYLevel;
    @Config(description="The number of ticks from mining a tortoise until feeding it could cause it to regrow.")
    public static int cooldownTicks;
    @Config(description="The items that can be fed to toretoises to make them regrow ores.")
    public static List<String> foods;
    @Config(flag="toretoise_regrow")
    public static boolean allowToretoiseToRegrow;
    @Config(description="Feeding a toretoise after cooldown will regrow them with a one-in-this-number chance. Set to 1 to always regrow, higher = lower chance.")
    public static int regrowChance;
    @Config
    public static DimensionConfig dimensions;
    @Config
    public static EntitySpawnConfig spawnConfig;
    public static ManualTrigger mineToretoiseTrigger;
    public static ManualTrigger mineFedToretoiseTrigger;
    public static final TagKey<EntityType<?>> toretoiseWhitelist;

    @LoadEvent
    public final void register(ZRegister event) {
        toretoiseType = EntityType.Builder.of(Toretoise::new, (MobCategory)MobCategory.CREATURE).sized(2.0f, 1.0f).clientTrackingRange(8).fireImmune().build("toretoise");
        Quark.ZETA.registry.register(toretoiseType, "toretoise", Registries.ENTITY_TYPE);
        Quark.ZETA.entitySpawn.registerSpawn(toretoiseType, MobCategory.MONSTER, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Toretoise::spawnPredicate, spawnConfig);
        Quark.ZETA.entitySpawn.addEgg((ZetaModule)this, toretoiseType, 5587259, 3682871, spawnConfig);
        mineToretoiseTrigger = event.getAdvancementModifierRegistry().registerManualTrigger("mine_toretoise");
        mineFedToretoiseTrigger = event.getAdvancementModifierRegistry().registerManualTrigger("mine_fed_toretoise");
    }

    @LoadEvent
    public final void entityAttrs(ZEntityAttributeCreation e) {
        e.put(toretoiseType, Toretoise.prepareAttributes().build());
    }

    static {
        COAL_LOOT = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)Quark.asResource("toretoise/coal"));
        IRON_LOOT = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)Quark.asResource("toretoise/iron"));
        REDSTONE_LOOT = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)Quark.asResource("toretoise/redstone"));
        LAPIS_LOOT = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)Quark.asResource("toretoise/lapis"));
        COPPER_LOOT = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)Quark.asResource("toretoise/copper"));
        maxYLevel = 0;
        cooldownTicks = 1200;
        foods = Lists.newArrayList((Object[])new String[]{"minecraft:glow_berries"});
        allowToretoiseToRegrow = true;
        regrowChance = 3;
        dimensions = DimensionConfig.overworld((boolean)false);
        spawnConfig = new EntitySpawnConfig(120, 2, 4, (IBiomeConfig)CompoundBiomeConfig.fromBiomeTags((boolean)true, (TagKey[])new TagKey[]{Tags.Biomes.IS_VOID, BiomeTags.IS_NETHER, BiomeTags.IS_END}));
        toretoiseWhitelist = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)Quark.asResource("toretoise_whitelist"));
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends ToretoiseModule {
        @LoadEvent
        public final void clientSetup(ZClientSetup event) {
            EntityRenderers.register((EntityType)toretoiseType, ToretoiseRenderer::new);
        }
    }
}

