/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.base.item.boat;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.base.handler.WoodSetHandler;
import org.violetmoon.quark.base.item.boat.IQuarkBoat;
import org.violetmoon.quark.base.item.boat.QuarkBoat;
import org.violetmoon.quark.base.item.boat.QuarkChestBoat;

public class QuarkBoatDispenseItemBehavior
extends DefaultDispenseItemBehavior {
    private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();
    private final String type;
    private final boolean chest;

    public QuarkBoatDispenseItemBehavior(String type, boolean chest) {
        this.type = type;
        this.chest = chest;
    }

    @NotNull
    public ItemStack execute(BlockSource world, @NotNull ItemStack stack) {
        double offset;
        Direction direction = (Direction)world.state().getValue((Property)DispenserBlock.FACING);
        ServerLevel level = world.level();
        double boatX = (double)world.pos().getX() + (double)((float)direction.getStepX() * 1.125f);
        double boatY = (double)world.pos().getY() + (double)((float)direction.getStepY() * 1.125f);
        double boatZ = (double)world.pos().getZ() + (double)((float)direction.getStepZ() * 1.125f);
        BlockPos pos = world.pos().relative(direction);
        if (level.getFluidState(pos).is(FluidTags.WATER)) {
            offset = 1.0;
        } else {
            if (!level.getBlockState(pos).isAir() || !level.getFluidState(pos.below()).is(FluidTags.WATER)) {
                return this.defaultDispenseItemBehavior.dispense(world, stack);
            }
            offset = 0.0;
        }
        IQuarkBoat boat = this.chest ? new QuarkChestBoat((Level)level, boatX, boatY + offset, boatZ) : new QuarkBoat((Level)level, boatX, boatY + offset, boatZ);
        ((IQuarkBoat)boat).setQuarkBoatTypeObj(WoodSetHandler.getQuarkBoatType(this.type));
        boat.setYRot(direction.toYRot());
        level.addFreshEntity((Entity)boat);
        stack.shrink(1);
        return stack;
    }

    protected void playSound(BlockSource world) {
        world.level().levelEvent(1000, world.pos(), 0);
    }
}

