/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.building.module;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import org.apache.commons.lang3.tuple.Pair;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.building.block.QuarkVerticalSlabBlock;
import org.violetmoon.quark.content.building.block.WeatheringCopperVerticalSlabBlock;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.load.ZCommonSetup;
import org.violetmoon.zeta.event.load.ZConfigChanged;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.handler.ToolInteractionHandler;

@ZetaLoadModule(category="building")
public class VerticalSlabsModule
extends ZetaModule {
    public static Map<Block, QuarkVerticalSlabBlock> blocks = new HashMap<Block, QuarkVerticalSlabBlock>();
    @Config(description="Should Walls and Panes attempt to connect to the side of Vertical Slabs?")
    public static boolean allowSideConnections = true;
    public static boolean staticEnabled;
    public static TagKey<Block> verticalSlabTag;

    @LoadEvent
    public void postRegister(ZRegister.Post e) {
        ImmutableSet.of((Object)Blocks.ACACIA_SLAB, (Object)Blocks.ANDESITE_SLAB, (Object)Blocks.BIRCH_SLAB, (Object)Blocks.BRICK_SLAB, (Object)Blocks.COBBLESTONE_SLAB, (Object)Blocks.CUT_RED_SANDSTONE_SLAB, (Object[])new Block[]{Blocks.CUT_SANDSTONE_SLAB, Blocks.DARK_OAK_SLAB, Blocks.DARK_PRISMARINE_SLAB, Blocks.DIORITE_SLAB, Blocks.END_STONE_BRICK_SLAB, Blocks.GRANITE_SLAB, Blocks.JUNGLE_SLAB, Blocks.MOSSY_COBBLESTONE_SLAB, Blocks.MOSSY_STONE_BRICK_SLAB, Blocks.NETHER_BRICK_SLAB, Blocks.OAK_SLAB, Blocks.POLISHED_ANDESITE_SLAB, Blocks.POLISHED_DIORITE_SLAB, Blocks.POLISHED_GRANITE_SLAB, Blocks.PRISMARINE_SLAB, Blocks.PRISMARINE_BRICK_SLAB, Blocks.PURPUR_SLAB, Blocks.QUARTZ_SLAB, Blocks.RED_NETHER_BRICK_SLAB, Blocks.RED_SANDSTONE_SLAB, Blocks.SANDSTONE_SLAB, Blocks.SMOOTH_QUARTZ_SLAB, Blocks.SMOOTH_RED_SANDSTONE_SLAB, Blocks.SMOOTH_SANDSTONE_SLAB, Blocks.SMOOTH_STONE_SLAB, Blocks.SPRUCE_SLAB, Blocks.STONE_SLAB, Blocks.STONE_BRICK_SLAB, Blocks.BLACKSTONE_SLAB, Blocks.POLISHED_BLACKSTONE_SLAB, Blocks.POLISHED_BLACKSTONE_BRICK_SLAB, Blocks.CRIMSON_SLAB, Blocks.WARPED_SLAB, Blocks.COBBLED_DEEPSLATE_SLAB, Blocks.POLISHED_DEEPSLATE_SLAB, Blocks.DEEPSLATE_BRICK_SLAB, Blocks.DEEPSLATE_TILE_SLAB, Blocks.MANGROVE_SLAB, Blocks.MUD_BRICK_SLAB, Blocks.CHERRY_SLAB, Blocks.BAMBOO_SLAB, Blocks.BAMBOO_MOSAIC_SLAB, Blocks.TUFF_SLAB, Blocks.POLISHED_TUFF_SLAB, Blocks.TUFF_BRICK_SLAB}).forEach(b -> new QuarkVerticalSlabBlock((Block)b, this));
        ArrayList copperVerticalSlabs = new ArrayList();
        ImmutableSet.of((Object)Pair.of((Object)Blocks.CUT_COPPER_SLAB, (Object)Blocks.WAXED_CUT_COPPER_SLAB), (Object)Pair.of((Object)Blocks.EXPOSED_CUT_COPPER_SLAB, (Object)Blocks.WAXED_EXPOSED_CUT_COPPER_SLAB), (Object)Pair.of((Object)Blocks.WEATHERED_CUT_COPPER_SLAB, (Object)Blocks.WAXED_WEATHERED_CUT_COPPER_SLAB), (Object)Pair.of((Object)Blocks.OXIDIZED_CUT_COPPER_SLAB, (Object)Blocks.WAXED_OXIDIZED_CUT_COPPER_SLAB)).forEach(p -> {
            WeatheringCopperVerticalSlabBlock cleanSlab = new WeatheringCopperVerticalSlabBlock((Block)p.getLeft(), this);
            QuarkVerticalSlabBlock waxedSlab = new QuarkVerticalSlabBlock((Block)p.getRight(), this);
            copperVerticalSlabs.add(cleanSlab);
            ToolInteractionHandler.registerWaxedBlock((ZetaModule)this, (Block)cleanSlab, (Block)waxedSlab);
        });
        WeatheringCopperVerticalSlabBlock first = (WeatheringCopperVerticalSlabBlock)((Object)copperVerticalSlabs.get(0));
        int max = copperVerticalSlabs.size();
        for (int i = 0; i < max; ++i) {
            WeatheringCopperVerticalSlabBlock next;
            WeatheringCopperVerticalSlabBlock prev = i > 0 ? (WeatheringCopperVerticalSlabBlock)((Object)copperVerticalSlabs.get(i - 1)) : null;
            WeatheringCopperVerticalSlabBlock current = (WeatheringCopperVerticalSlabBlock)((Object)copperVerticalSlabs.get(i));
            WeatheringCopperVerticalSlabBlock weatheringCopperVerticalSlabBlock = next = i < max - 1 ? (WeatheringCopperVerticalSlabBlock)((Object)copperVerticalSlabs.get(i + 1)) : null;
            if (prev != null) {
                ToolInteractionHandler.registerInteraction((ItemAbility)ItemAbilities.AXE_SCRAPE, (Block)current, (Block)prev);
                current.prev = prev;
            }
            if (next != null) {
                current.next = next;
            }
            current.first = first;
        }
        Quark.ZETA.variantRegistry.slabs.values().forEach(b -> {
            if (b instanceof IVerticalSlabProvider) {
                IVerticalSlabProvider provider = (IVerticalSlabProvider)b;
                provider.getVerticalSlab((Block)b, this);
            } else {
                new QuarkVerticalSlabBlock((Block)b, this);
            }
        });
    }

    @LoadEvent
    public final void setup(ZCommonSetup event) {
        verticalSlabTag = Quark.asTagKey(Registries.BLOCK, "vertical_slabs");
    }

    @LoadEvent
    public final void configChanged(ZConfigChanged event) {
        staticEnabled = this.isEnabled();
    }

    public static BlockState messWithPaneState(LevelAccessor level, BlockPos ourPos, BlockState state) {
        if (!staticEnabled || !allowSideConnections) {
            return state;
        }
        for (Direction dir : PipeBlock.PROPERTY_BY_DIRECTION.keySet()) {
            BlockState adjState;
            boolean should;
            BooleanProperty prop;
            boolean val;
            if (!dir.getAxis().isHorizontal() || (val = ((Boolean)state.getValue((Property)(prop = (BooleanProperty)PipeBlock.PROPERTY_BY_DIRECTION.get(dir)))).booleanValue()) || !(should = VerticalSlabsModule.shouldWallConnect(adjState = level.getBlockState(ourPos.relative(dir)), dir, false))) continue;
            state = (BlockState)state.setValue((Property)prop, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public static boolean shouldWallConnect(BlockState state, Direction dir, boolean prev) {
        Property prop;
        Optional<Property> opt;
        if (prev || !staticEnabled || !allowSideConnections) {
            return prev;
        }
        if (state.is(verticalSlabTag) && (opt = state.getProperties().stream().filter(p -> p.getName() == "type").findFirst()).isPresent() && (prop = opt.get()) instanceof EnumProperty) {
            EnumProperty ep = (EnumProperty)prop;
            Enum val = (Enum)((Object)state.getValue(prop));
            String name = val.name().toLowerCase(Locale.ROOT);
            Direction vsDir = Direction.byName((String)name);
            return vsDir != null && vsDir.getAxis() != dir.getAxis();
        }
        return false;
    }

    public static interface IVerticalSlabProvider {
        public QuarkVerticalSlabBlock getVerticalSlab(Block var1, ZetaModule var2);
    }
}

