/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.mobs.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.handler.QuarkSounds;
import org.violetmoon.quark.base.util.IfFlagGoal;
import org.violetmoon.quark.content.mobs.ai.ActWaryGoal;
import org.violetmoon.quark.content.mobs.ai.FavorBlockGoal;
import org.violetmoon.quark.content.mobs.ai.RunAndPoofGoal;
import org.violetmoon.quark.content.mobs.module.StonelingsModule;
import org.violetmoon.quark.content.tools.entity.rang.Pickarang;
import org.violetmoon.quark.content.world.module.GlimmeringWealdModule;
import org.violetmoon.quark.content.world.module.NewStoneTypesModule;
import org.violetmoon.zeta.util.BlockUtils;
import org.violetmoon.zeta.util.MiscUtil;

public class Stoneling
extends PathfinderMob {
    public static final ResourceKey<LootTable> CARRY_LOOT_TABLE = Quark.asResourceKey(Registries.LOOT_TABLE, "entities/stoneling_carry");
    private static final EntityDataAccessor<ItemStack> CARRYING_ITEM = SynchedEntityData.defineId(Stoneling.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Byte> VARIANT = SynchedEntityData.defineId(Stoneling.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Float> HOLD_ANGLE = SynchedEntityData.defineId(Stoneling.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Boolean> HAS_LICHEN = SynchedEntityData.defineId(Stoneling.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final String TAG_CARRYING_ITEM = "carryingItem";
    private static final String TAG_VARIANT = "variant";
    private static final String TAG_HAS_LICHEN = "has_lichen";
    private static final String TAG_HOLD_ANGLE = "itemAngle";
    public static final String TAG_PLAYER_MADE = "playerMade";
    private final Vec3 PASSENGER_ATTACH_POINT = new Vec3(0.0, (double)this.getBbHeight(), 0.0);
    private ActWaryGoal waryGoal;
    private boolean isTame;

    public Stoneling(EntityType<? extends Stoneling> type, Level worldIn) {
        super(type, worldIn);
        this.setPathfindingMalus(PathType.DAMAGE_OTHER, 1.0f);
        this.setPathfindingMalus(PathType.DANGER_OTHER, 1.0f);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(CARRYING_ITEM, (Object)ItemStack.EMPTY);
        builder.define(VARIANT, (Object)0);
        builder.define(HOLD_ANGLE, (Object)Float.valueOf(0.0f));
        builder.define(HAS_LICHEN, (Object)false);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.2, 0.98f));
        this.goalSelector.addGoal(4, (Goal)new FavorBlockGoal((PathfinderMob)this, 0.2, s -> s.is(Tags.Blocks.ORES_DIAMOND)));
        this.goalSelector.addGoal(3, (Goal)new IfFlagGoal((Goal)new TemptGoal((PathfinderMob)this, 0.6, (Predicate)Ingredient.of(this.temptTag()), false), () -> StonelingsModule.enableDiamondHeart && !StonelingsModule.tamableStonelings));
        this.goalSelector.addGoal(2, new RunAndPoofGoal<Player>(this, Player.class, 4.0f, 0.5, 0.5));
        this.waryGoal = new ActWaryGoal(this, 0.1, 6.0, () -> StonelingsModule.cautiousStonelings);
        this.goalSelector.addGoal(1, (Goal)this.waryGoal);
        this.goalSelector.addGoal(0, (Goal)new IfFlagGoal((Goal)new TemptGoal((PathfinderMob)this, 0.6, (Predicate)Ingredient.of(this.temptTag()), false), () -> StonelingsModule.tamableStonelings));
    }

    private TagKey<Item> temptTag() {
        return Quark.ZETA.modules.isEnabled(GlimmeringWealdModule.class) ? GlimmeringWealdModule.glowShroomFeedablesTag : Tags.Items.GEMS_DIAMOND;
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 8.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.STEP_HEIGHT, 1.0);
    }

    public void tick() {
        super.tick();
        this.yBodyRotO = this.yRotO;
        this.yBodyRot = this.getYRot();
    }

    public MobCategory getClassification(boolean forSpawnCount) {
        if (this.isTame) {
            return MobCategory.CREATURE;
        }
        return MobCategory.MONSTER;
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return !this.isTame;
    }

    public void checkDespawn() {
        boolean wasAlive = this.isAlive();
        super.checkDespawn();
        if (!this.isAlive() && wasAlive) {
            for (Entity passenger : this.getIndirectPassengers()) {
                if (passenger instanceof Player) continue;
                passenger.discard();
            }
        }
    }

    @NotNull
    public InteractionResult mobInteract(Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!stack.isEmpty() && stack.getItem() == Items.NAME_TAG) {
            return stack.getItem().interactLivingEntity(stack, player, (LivingEntity)this, hand);
        }
        return super.mobInteract(player, hand);
    }

    @NotNull
    public InteractionResult interactAt(@NotNull Player player, @NotNull Vec3 vec, @NotNull InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND && this.isAlive()) {
            ItemStack playerItem = player.getItemInHand(hand);
            Vec3 pos = this.position();
            Level level = this.level();
            if (this.isPlayerMade()) {
                if (!player.isDiscrete() && !playerItem.isEmpty()) {
                    StonelingVariant currentVariant = this.getVariant();
                    StonelingVariant targetVariant = null;
                    Block targetBlock = null;
                    block0: for (StonelingVariant variant : StonelingVariant.values()) {
                        for (Block block : variant.getBlocks()) {
                            if (block.asItem() != playerItem.getItem()) continue;
                            targetVariant = variant;
                            targetBlock = block;
                            break block0;
                        }
                    }
                    if (targetVariant != null) {
                        if (level instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level;
                            serverLevel.sendParticles((ParticleOptions)ParticleTypes.HEART, pos.x, pos.y + (double)this.getBbHeight(), pos.z, 1, 0.1, 0.1, 0.1, 0.1);
                            if (targetVariant != currentVariant) {
                                serverLevel.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, targetBlock.defaultBlockState()), pos.x, pos.y + (double)(this.getBbHeight() / 2.0f), pos.z, 16, 0.1, 0.1, 0.1, 0.25);
                            }
                        }
                        if (targetVariant != currentVariant) {
                            this.playSound(QuarkSounds.ENTITY_STONELING_EAT, 1.0f, 1.0f);
                            this.entityData.set(VARIANT, (Object)targetVariant.getIndex());
                        }
                        this.playSound(QuarkSounds.ENTITY_STONELING_PURR, 1.0f, 1.0f + level.random.nextFloat());
                        this.heal(1.0f);
                        if (!player.getAbilities().instabuild) {
                            playerItem.shrink(1);
                        }
                        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
                    }
                    return InteractionResult.PASS;
                }
                ItemStack stonelingItem = (ItemStack)this.entityData.get(CARRYING_ITEM);
                if (!stonelingItem.isEmpty() || !playerItem.isEmpty()) {
                    player.setItemInHand(hand, stonelingItem.copy());
                    this.entityData.set(CARRYING_ITEM, (Object)playerItem.copy());
                    if (playerItem.isEmpty()) {
                        this.playSound(QuarkSounds.ENTITY_STONELING_GIVE, 1.0f, 1.0f);
                    } else {
                        this.playSound(QuarkSounds.ENTITY_STONELING_TAKE, 1.0f, 1.0f);
                    }
                    return InteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
            } else if (StonelingsModule.tamableStonelings && playerItem.is(this.temptTag())) {
                this.heal(8.0f);
                this.setPlayerMade(true);
                this.playSound(QuarkSounds.ENTITY_STONELING_PURR, 1.0f, 1.0f + level.random.nextFloat());
                if (!player.getAbilities().instabuild) {
                    playerItem.shrink(1);
                }
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.HEART, pos.x, pos.y + (double)this.getBbHeight(), pos.z, 4, 0.1, 0.1, 0.1, 0.1);
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor accessor, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnReason, @Nullable SpawnGroupData data) {
        ObjectArrayList items;
        byte variant;
        RandomSource rand = accessor.getRandom();
        if (data instanceof StonelingVariant) {
            StonelingVariant stonelingVariant = (StonelingVariant)data;
            variant = stonelingVariant.getIndex();
        } else {
            variant = (byte)rand.nextInt(StonelingVariant.values().length);
        }
        this.entityData.set(VARIANT, (Object)variant);
        this.entityData.set(HAS_LICHEN, (Object)(accessor.getBiome(this.getOnPos()).is(GlimmeringWealdModule.BIOME_NAME) && rand.nextInt(5) < 3 ? 1 : 0));
        this.entityData.set(HOLD_ANGLE, (Object)Float.valueOf(accessor.getRandom().nextFloat() * 90.0f - 45.0f));
        if (!(this.isTame || accessor.isClientSide() || (items = accessor.getServer().reloadableRegistries().getLootTable(CARRY_LOOT_TABLE).getRandomItems(new LootParams.Builder(accessor.getLevel()).withParameter(LootContextParams.ORIGIN, (Object)this.position()).create(LootContextParamSets.CHEST))).isEmpty())) {
            this.entityData.set(CARRYING_ITEM, (Object)((ItemStack)items.get(0)));
        }
        return super.finalizeSpawn(accessor, difficulty, spawnReason, data);
    }

    public boolean isInvulnerableTo(@NotNull DamageSource source) {
        return this.damageSources().cactus().equals(source) || Stoneling.isProjectileWithoutPiercing(source) || super.isInvulnerableTo(source);
    }

    private static boolean isProjectileWithoutPiercing(DamageSource source) {
        if (source.isDirect()) {
            return false;
        }
        Entity sourceEntity = source.getDirectEntity();
        if (sourceEntity instanceof Pickarang) {
            Pickarang pickarang = (Pickarang)sourceEntity;
            return pickarang.getPiercingModifier() <= 0;
        }
        if (sourceEntity instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)sourceEntity;
            return arrow.getPierceLevel() <= 0;
        }
        return true;
    }

    public boolean checkSpawnObstruction(LevelReader worldReader) {
        return worldReader.isUnobstructed((Entity)this, Shapes.create((AABB)this.getBoundingBox()));
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        return this.PASSENGER_ATTACH_POINT;
    }

    public boolean isPushedByFluid() {
        return false;
    }

    protected int decreaseAirSupply(int air) {
        return air;
    }

    public boolean causeFallDamage(float distance, float damageMultiplier, @NotNull DamageSource source) {
        return false;
    }

    protected void actuallyHurt(@NotNull DamageSource damageSrc, float damageAmount) {
        super.actuallyHurt(damageSrc, damageAmount);
        if (!this.isPlayerMade() && damageSrc.getEntity() instanceof Player) {
            this.startle();
            for (Entity entity : this.level().getEntities((Entity)this, this.getBoundingBox().inflate(16.0))) {
                Stoneling stoneling;
                if (!(entity instanceof Stoneling) || (stoneling = (Stoneling)entity).isPlayerMade() || !stoneling.getSensing().hasLineOfSight((Entity)this)) continue;
                this.startle();
            }
        }
    }

    public boolean isStartled() {
        return this.waryGoal.isStartled();
    }

    public void startle() {
        this.waryGoal.startle();
        HashSet entries = Sets.newHashSet((Iterable)this.goalSelector.getAvailableGoals());
        for (WrappedGoal task : entries) {
            if (!(task.getGoal() instanceof TemptGoal)) continue;
            this.goalSelector.removeGoal(task.getGoal());
        }
    }

    protected void dropCustomDeathLoot(@NotNull ServerLevel level, @NotNull DamageSource damage, boolean wasRecentlyHit) {
        super.dropCustomDeathLoot(level, damage, wasRecentlyHit);
        ItemStack stack = this.getCarryingItem();
        if (!stack.isEmpty()) {
            this.spawnAtLocation(stack, 0.0f);
        }
    }

    public void setPlayerMade(boolean value) {
        this.isTame = value;
    }

    public ItemStack getCarryingItem() {
        return (ItemStack)this.entityData.get(CARRYING_ITEM);
    }

    public StonelingVariant getVariant() {
        return StonelingVariant.byIndex((Byte)this.entityData.get(VARIANT));
    }

    public float getItemAngle() {
        return ((Float)this.entityData.get(HOLD_ANGLE)).floatValue();
    }

    public boolean isPlayerMade() {
        return this.isTame;
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains(TAG_CARRYING_ITEM, 10)) {
            CompoundTag itemCmp = compound.getCompound(TAG_CARRYING_ITEM);
            ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)this.level().registryAccess(), (CompoundTag)itemCmp);
            this.entityData.set(CARRYING_ITEM, (Object)stack);
        }
        this.entityData.set(VARIANT, (Object)compound.getByte(TAG_VARIANT));
        this.entityData.set(HOLD_ANGLE, (Object)Float.valueOf(compound.getFloat(TAG_HOLD_ANGLE)));
        this.entityData.set(HAS_LICHEN, (Object)compound.getBoolean(TAG_HAS_LICHEN));
        this.setPlayerMade(compound.getBoolean(TAG_PLAYER_MADE));
    }

    public boolean hasLineOfSight(Entity entityIn) {
        Vec3 pos = this.position();
        Vec3 epos = entityIn.position();
        Vec3 origin = new Vec3(pos.x, pos.y + (double)this.getEyeHeight(), pos.z);
        float otherEyes = entityIn.getEyeHeight();
        for (float height = 0.0f; height <= otherEyes; height += otherEyes / 8.0f) {
            if (this.level().clip(new ClipContext(origin, epos.add(0.0, (double)height, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).getType() != HitResult.Type.MISS) continue;
            return true;
        }
        return false;
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (!this.getCarryingItem().is(Items.AIR)) {
            compound.put(TAG_CARRYING_ITEM, this.getCarryingItem().save((HolderLookup.Provider)this.level().registryAccess()));
        }
        compound.putByte(TAG_VARIANT, this.getVariant().getIndex());
        compound.putFloat(TAG_HOLD_ANGLE, this.getItemAngle());
        compound.putBoolean(TAG_PLAYER_MADE, this.isPlayerMade());
        compound.putBoolean(TAG_HAS_LICHEN, ((Boolean)this.entityData.get(HAS_LICHEN)).booleanValue());
    }

    public static boolean spawnPredicate(EntityType<? extends Stoneling> type, ServerLevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource rand) {
        return pos.getY() <= StonelingsModule.maxYLevel && (MiscUtil.validSpawnLight((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)rand) || world.getBiome(pos).is(GlimmeringWealdModule.BIOME_NAME)) && MiscUtil.validSpawnLocation(type, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos);
    }

    public boolean checkSpawnRules(@NotNull LevelAccessor world, @NotNull MobSpawnType reason) {
        BlockPos pos = BlockPos.containing((Position)this.position()).below();
        BlockState state = world.getBlockState(pos);
        if (!BlockUtils.isStoneBased((BlockState)state, (BlockGetter)world, (BlockPos)pos)) {
            return false;
        }
        return StonelingsModule.dimensions.canSpawnHere(world) && super.checkSpawnRules(world, reason);
    }

    @Nullable
    protected SoundEvent getHurtSound(@NotNull DamageSource damageSourceIn) {
        return QuarkSounds.ENTITY_STONELING_CRY;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return QuarkSounds.ENTITY_STONELING_DIE;
    }

    public int getAmbientSoundInterval() {
        return 1200;
    }

    public void playAmbientSound() {
        SoundEvent sound = this.getAmbientSound();
        if (sound != null) {
            this.playSound(sound, this.getSoundVolume(), 1.0f);
        }
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        String customName;
        if (this.hasCustomName() && ((customName = this.getName().getString()).equalsIgnoreCase("michael stevens") || customName.equalsIgnoreCase("vsauce"))) {
            return QuarkSounds.ENTITY_STONELING_MICHAEL;
        }
        return null;
    }

    @NotNull
    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entity) {
        return new ClientboundAddEntityPacket((Entity)this, entity);
    }

    public float getWalkTargetValue(@NotNull BlockPos pos, LevelReader world) {
        return 0.5f - (float)world.getRawBrightness(pos, 0);
    }

    public static enum StonelingVariant implements SpawnGroupData
    {
        STONE("stone", Blocks.COBBLESTONE, Blocks.STONE),
        ANDESITE("andesite", Blocks.ANDESITE, Blocks.POLISHED_ANDESITE),
        DIORITE("diorite", Blocks.DIORITE, Blocks.POLISHED_DIORITE),
        GRANITE("granite", Blocks.GRANITE, Blocks.POLISHED_GRANITE),
        LIMESTONE("limestone", NewStoneTypesModule.limestoneBlock, NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.limestoneBlock)),
        CALCITE("calcite", Blocks.CALCITE),
        SHALE("shale", NewStoneTypesModule.shaleBlock, NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.shaleBlock)),
        JASPER("jasper", NewStoneTypesModule.jasperBlock, NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.jasperBlock)),
        DEEPSLATE("deepslate", Blocks.DEEPSLATE, Blocks.POLISHED_DEEPSLATE),
        TUFF("tuff", Blocks.TUFF, NewStoneTypesModule.polishedBlocks.get(Blocks.TUFF)),
        DRIPSTONE("dripstone", Blocks.DRIPSTONE_BLOCK, NewStoneTypesModule.polishedBlocks.get(Blocks.DRIPSTONE_BLOCK));

        private final ResourceLocation texture;
        private final List<Block> blocks;

        private StonelingVariant(String variantPath, Block ... blocks) {
            this.texture = Quark.asResource("textures/model/entity/stoneling/" + variantPath + ".png");
            this.blocks = Lists.newArrayList((Object[])blocks);
        }

        public static StonelingVariant byIndex(byte index) {
            StonelingVariant[] values = StonelingVariant.values();
            return values[Mth.clamp((int)index, (int)0, (int)(values.length - 1))];
        }

        public byte getIndex() {
            return (byte)this.ordinal();
        }

        public ResourceLocation getTexture() {
            return this.texture;
        }

        public List<Block> getBlocks() {
            return this.blocks;
        }
    }
}

