/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tweaks.module;

import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.play.entity.living.ZLivingFall;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;

@ZetaLoadModule(category="tweaks")
public class SaferCreaturesModule
extends ZetaModule {
    @Config(description="How many blocks should be subtracted from the rabbit fall height when calculating fall damage. 5 is the same value as vanilla frogs")
    public double heightReduction = 5.0;
    @Config
    public boolean enableSlimeFallDamageRemoval = true;

    @PlayEvent
    public void onFall(ZLivingFall event) {
        LivingEntity e = event.getEntity();
        EntityType type = e.m_6095_();
        float dist = event.getDistance();
        if (type == EntityType.f_20517_) {
            event.setDistance(Math.max(0.0f, dist - (float)this.heightReduction));
        } else if (type == EntityType.f_20526_ && this.enableSlimeFallDamageRemoval) {
            if (dist > 2.0f) {
                Vec3 movement = e.m_20184_();
                e.m_20334_(movement.f_82479_, -2.0, movement.f_82481_);
            }
            event.setDistance(0.0f);
        }
    }
}

