/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.client.tooltip;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.client.module.ImprovedTooltipsModule;
import org.violetmoon.quark.content.tools.item.AncientTomeItem;
import org.violetmoon.quark.content.tools.module.AncientTomesModule;
import org.violetmoon.zeta.client.event.play.ZGatherTooltipComponents;
import org.violetmoon.zeta.module.IDisableable;
import org.violetmoon.zeta.util.ItemNBTHelper;

public class EnchantedBookTooltips {
    private static List<ItemStack> testItems = null;
    private static Multimap<Enchantment, ItemStack> additionalStacks = null;
    public static final String TABLE_ONLY_DISPLAY = "quark:only_show_table_enchantments";
    private static ItemStack BOOK;

    public static void reloaded() {
        additionalStacks = null;
        testItems = null;
    }

    public static void makeTooltip(ZGatherTooltipComponents event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.m_41720_() == Items.f_42690_ || stack.m_41720_() == AncientTomesModule.ancient_tome) {
            List tooltip = event.getTooltipElements();
            int tooltipIndex = 0;
            List<EnchantmentInstance> enchants = EnchantedBookTooltips.getEnchantedBookEnchantments(stack);
            block0: for (EnchantmentInstance ed : enchants) {
                Component match = stack.m_41720_() == Items.f_42690_ ? ed.f_44947_.m_44700_(ed.f_44948_) : AncientTomeItem.getFullTooltipText(ed.f_44947_);
                while (tooltipIndex < tooltip.size()) {
                    Either elmAt = (Either)tooltip.get(tooltipIndex);
                    if (elmAt.left().isPresent() && ((FormattedText)elmAt.left().get()).equals(match)) {
                        boolean tableOnly = ItemNBTHelper.getBoolean((ItemStack)stack, (String)TABLE_ONLY_DISPLAY, (boolean)false);
                        List<ItemStack> items = EnchantedBookTooltips.getItemsForEnchantment(ed.f_44947_, tableOnly);
                        int itemCount = items.size();
                        int lines = (int)Math.ceil((double)itemCount / 10.0);
                        int len = 3 + Math.min(10, itemCount) * 9;
                        tooltip.add(tooltipIndex + 1, Either.right((Object)new EnchantedBookComponent(len, lines * 10, ed.f_44947_, tableOnly)));
                        continue block0;
                    }
                    ++tooltipIndex;
                }
            }
        }
    }

    private static List<ItemStack> getItemsForEnchantment(Enchantment e, boolean onlyForTable) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (ItemStack stack : EnchantedBookTooltips.getTestItems()) {
            IDisableable disableable;
            Item item = stack.m_41720_();
            if (item instanceof IDisableable && !(disableable = (IDisableable)item).isEnabled() || stack.m_41619_() || !e.m_6081_(stack) || onlyForTable && (!e.canApplyAtEnchantingTable(stack) || !stack.m_41792_() || Quark.ZETA.itemExtensions.get(stack).getEnchantmentValueZeta(stack) <= 0)) continue;
            list.add(stack);
        }
        if (onlyForTable) {
            if (BOOK == null) {
                BOOK = new ItemStack((ItemLike)Items.f_42517_);
            }
            list.add(BOOK);
        }
        if (EnchantedBookTooltips.getAdditionalStacks().containsKey((Object)e)) {
            list.addAll(EnchantedBookTooltips.getAdditionalStacks().get((Object)e));
        }
        return list;
    }

    private static List<EnchantmentInstance> getEnchantedBookEnchantments(ItemStack stack) {
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
        ArrayList<EnchantmentInstance> retList = new ArrayList<EnchantmentInstance>(enchantments.size());
        for (Enchantment enchantment : enchantments.keySet()) {
            if (enchantment == null) continue;
            int level = (Integer)enchantments.get(enchantment);
            retList.add(new EnchantmentInstance(enchantment, level));
        }
        return retList;
    }

    private static Multimap<Enchantment, ItemStack> getAdditionalStacks() {
        if (additionalStacks == null) {
            EnchantedBookTooltips.computeAdditionalStacks();
        }
        return additionalStacks;
    }

    public static List<ItemStack> getTestItems() {
        if (testItems == null) {
            EnchantedBookTooltips.computeTestItems();
        }
        return testItems;
    }

    private static void computeTestItems() {
        testItems = ImprovedTooltipsModule.enchantingStacks.stream().map(ResourceLocation::new).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.f_257033_).m_7745_(arg_0)).filter(i -> i != Items.f_41852_).map(ItemStack::new).toList();
    }

    private static void computeAdditionalStacks() {
        additionalStacks = HashMultimap.create();
        for (String s : ImprovedTooltipsModule.enchantingAdditionalStacks) {
            if (!s.contains("=")) continue;
            String[] tokens = s.split("=");
            String left = tokens[0];
            String right = tokens[1];
            BuiltInRegistries.f_256876_.m_6612_(new ResourceLocation(left)).ifPresent(ench -> {
                for (String itemId : right.split(",")) {
                    BuiltInRegistries.f_257033_.m_6612_(new ResourceLocation(itemId)).ifPresent(item -> additionalStacks.put(ench, (Object)new ItemStack((ItemLike)item)));
                }
            });
        }
    }

    public record EnchantedBookComponent(int width, int height, Enchantment enchantment, boolean tableOnly) implements ClientTooltipComponent,
    TooltipComponent
    {
        public void m_183452_(@NotNull Font font, int tooltipX, int tooltipY, @NotNull GuiGraphics guiGraphics) {
            PoseStack pose = guiGraphics.m_280168_();
            pose.m_85836_();
            pose.m_252880_((float)tooltipX, (float)tooltipY, 0.0f);
            pose.m_85841_(0.5f, 0.5f, 1.0f);
            List<ItemStack> items = EnchantedBookTooltips.getItemsForEnchantment(this.enchantment, this.tableOnly);
            int drawn = 0;
            for (ItemStack testStack : items) {
                guiGraphics.m_280480_(testStack, 6 + drawn % 10 * 18, drawn / 10 * 20);
                ++drawn;
            }
            pose.m_85849_();
            RenderSystem.applyModelViewMatrix();
        }

        public int m_142103_() {
            return this.height;
        }

        public int m_142069_(@NotNull Font font) {
            return this.width;
        }
    }
}

