/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.world.module;

import com.google.common.base.Functions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.handler.WoodSetHandler;
import org.violetmoon.quark.content.world.feature.AncientTreeTopperDecorator;
import org.violetmoon.quark.content.world.feature.MultiFoliageStraightTrunkPlacer;
import org.violetmoon.quark.content.world.feature.OffsetFancyFoliagePlacer;
import org.violetmoon.quark.content.world.item.AncientFruitItem;
import org.violetmoon.zeta.advancement.ManualTrigger;
import org.violetmoon.zeta.advancement.modifier.BalancedDietModifier;
import org.violetmoon.zeta.api.IAdvancementModifier;
import org.violetmoon.zeta.block.ZetaLeavesBlock;
import org.violetmoon.zeta.block.ZetaSaplingBlock;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZCommonSetup;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.event.play.loading.ZLootTableLoad;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.Hint;
import org.violetmoon.zeta.world.PassthroughTreeGrower;

@ZetaLoadModule(category="world")
public class AncientWoodModule
extends ZetaModule {
    @Config(flag="ancient_fruit_xp")
    public static boolean ancientFruitGivesExp = true;
    @Config
    @Config.Min(value=1.0)
    public static int ancientFruitExpValue = 10;
    @Config(description="Set to a value other than 0 to enable Ancient City loot chest generation (8 recommended if you do)")
    @Config.Min(value=0.0)
    public static int ancientCityLootWeight = 0;
    @Config
    @Config.Min(value=0.0)
    public static int ancientCityLootQuality = 1;
    @Config(description="Set to 0 to disable sniffer sniffing. The vanilla loot table has every entry at weight 1, so without editing it, it's impossible to make the sapling more rare")
    @Config.Min(value=0.0)
    public static int sniffingLootWeight = 1;
    @Config
    @Config.Min(value=0.0)
    public static int sniffingLootQuality = 0;
    public static WoodSetHandler.WoodSet woodSet;
    public static Block ancient_leaves;
    @Hint
    public static Block ancient_sapling;
    @Hint
    public static Item ancient_fruit;
    public static final ResourceKey<ConfiguredFeature<?, ?>> configuredFeatureKey;
    public static ManualTrigger ancientFruitTrigger;

    @LoadEvent
    public void setup(ZCommonSetup e) {
        e.enqueueWork(() -> {
            ComposterBlock.f_51914_.put((Object)ancient_sapling.m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)ancient_leaves.m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)ancient_fruit.m_5456_(), 0.65f);
            this.zeta().fuel.addFuel(ancient_sapling, 100);
        });
    }

    @LoadEvent
    public void register(ZRegister event) {
        woodSet = WoodSetHandler.addWoodSet(event, this, "ancient", MapColor.f_283919_, MapColor.f_283919_, true);
        ancient_leaves = new ZetaLeavesBlock(AncientWoodModule.woodSet.name, (ZetaModule)this, MapColor.f_283915_);
        ancient_sapling = new ZetaSaplingBlock("ancient", (ZetaModule)this, (AbstractTreeGrower)new PassthroughTreeGrower(configuredFeatureKey));
        event.getVariantRegistry().addFlowerPot(ancient_sapling, "ancient_sapling", (Function)Functions.identity());
        ancient_fruit = new AncientFruitItem(this);
        event.getAdvancementModifierRegistry().addModifier((IAdvancementModifier)new BalancedDietModifier((ZetaModule)this, (Set)ImmutableSet.of((Object)ancient_fruit)));
        ancientFruitTrigger = event.getAdvancementModifierRegistry().registerManualTrigger("ancient_fruit_overlevel");
        event.getRegistry().register(MultiFoliageStraightTrunkPlacer.TYPE, "multi_foliage_straight_trunk_placer", Registries.f_256963_);
        event.getRegistry().register(AncientTreeTopperDecorator.TYPE, "ancient_tree_topper_decorator", Registries.f_256845_);
        event.getRegistry().register(OffsetFancyFoliagePlacer.TYPE, "offset_fancy_foliage_placer", Registries.f_256905_);
    }

    @PlayEvent
    public void onLootTableLoad(ZLootTableLoad event) {
        int weight = 0;
        if (event.getName().equals((Object)BuiltInLootTables.f_230876_)) {
            weight = ancientCityLootWeight;
        }
        if (event.getName().equals((Object)BuiltInLootTables.f_283841_)) {
            weight = sniffingLootWeight;
        }
        if (weight > 0) {
            LootPoolEntryContainer entry = LootItem.m_79579_((ItemLike)ancient_sapling).m_79707_(weight).m_79711_(ancientCityLootQuality).m_7512_();
            event.add(entry);
        }
    }

    static {
        configuredFeatureKey = Quark.asResourceKey(Registries.f_256911_, "ancient_tree");
    }
}

