/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.client.resources;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.client.resources.AttributeIconEntry;
import org.violetmoon.quark.content.client.tooltip.AttributeTooltips;

public class AttributeTooltipManager
extends SimplePreparableReloadListener<Map<String, AttributeIconEntry>> {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(AttributeIconEntry.class, (Object)AttributeIconEntry.Serializer.INSTANCE).create();
    private static final Logger LOGGER = Quark.LOG;
    private static final TypeToken<Map<String, AttributeIconEntry>> ATTRIBUTE_ICON_ENTRY_TYPE = new TypeToken<Map<String, AttributeIconEntry>>(){};

    @NotNull
    protected Map<String, AttributeIconEntry> prepare(@NotNull ResourceManager manager, @NotNull ProfilerFiller profiler) {
        HashMap<String, AttributeIconEntry> tooltips = new HashMap<String, AttributeIconEntry>();
        profiler.m_7242_();
        try {
            for (Resource resource : manager.m_213829_(new ResourceLocation("quark", "attribute_tooltips.json"))) {
                profiler.m_6180_(resource.m_215506_());
                try (InputStream stream = resource.m_215507_();
                     InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                    profiler.m_6180_("parse");
                    Map map = (Map)GsonHelper.m_13767_((Gson)GSON, (Reader)reader, ATTRIBUTE_ICON_ENTRY_TYPE);
                    profiler.m_6182_("register");
                    if (map != null) {
                        tooltips.putAll(map);
                    }
                    profiler.m_7238_();
                }
                catch (RuntimeException err) {
                    LOGGER.warn("Invalid {} in resourcepack: '{}'", (Object)"attribute_tooltips.json", (Object)resource.m_215506_(), (Object)err);
                }
                profiler.m_7238_();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        profiler.m_7241_();
        return tooltips;
    }

    protected void apply(@NotNull Map<String, AttributeIconEntry> tooltips, @NotNull ResourceManager manager, @NotNull ProfilerFiller profiler) {
        AttributeTooltips.receiveAttributes(tooltips);
    }
}

