/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tweaks.module;

import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.play.entity.player.ZPlayerTick;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.Hint;

@ZetaLoadModule(category="tweaks")
public class CampfiresBoostElytraModule
extends ZetaModule {
    @Config
    public double boostStrength = 0.5;
    @Config
    public double maxSpeed = 1.0;
    @Hint
    Item campfire = Items.CAMPFIRE;
    @Hint
    Item soul_campfire = Items.SOUL_CAMPFIRE;

    @PlayEvent
    public void onPlayerTick(ZPlayerTick.Start event) {
        Vec3 motion;
        Player player = event.getPlayer();
        if (player.isFallFlying() && (motion = player.getDeltaMovement()).y() < this.maxSpeed) {
            int moves;
            BlockPos pos = player.blockPosition();
            Level world = player.level();
            for (moves = 0; world.isEmptyBlock(pos) && world.isInWorldBounds(pos) && moves < 20; ++moves) {
                pos = pos.below();
            }
            BlockState state = world.getBlockState(pos);
            Block block = state.getBlock();
            boolean isCampfire = state.is(BlockTags.CAMPFIRES);
            if (isCampfire && block instanceof CampfireBlock && ((Boolean)state.getValue((Property)CampfireBlock.LIT)).booleanValue() && ((Boolean)state.getValue((Property)CampfireBlock.SIGNAL_FIRE)).booleanValue()) {
                double force = this.boostStrength;
                if (moves > 16) {
                    force -= force * (1.0 - ((double)moves - 16.0) / 4.0);
                }
                if (block == Blocks.SOUL_CAMPFIRE) {
                    force *= -1.5;
                }
                player.setDeltaMovement(motion.x(), Math.min(this.maxSpeed, motion.y() + force), motion.z());
            }
        }
    }
}

