/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tweaks.module;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.Criterion;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.RecipeToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.GameRules;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.zeta.client.event.play.ZClientTick;
import org.violetmoon.zeta.client.event.play.ZScreen;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZConfigChanged;
import org.violetmoon.zeta.event.play.entity.player.ZPlayer;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;

@ZetaLoadModule(category="tweaks", antiOverlap={"nerb"})
public class AutomaticRecipeUnlockModule
extends ZetaModule {
    @Config(description="A list of recipe names that should NOT be added in by default")
    public static List<String> ignoredRecipes = Lists.newArrayList();
    @Config
    public static boolean forceLimitedCrafting = false;
    @Config
    public static boolean disableRecipeBook = false;
    @Config(description="If enabled, advancements granting recipes will be stopped from loading, potentially reducing the lagspike on first world join.")
    public static boolean filterRecipeAdvancements = true;
    private static boolean staticEnabled;

    @LoadEvent
    public final void configChanged(ZConfigChanged event) {
        staticEnabled = this.isEnabled();
    }

    @PlayEvent
    public void onPlayerLoggedIn(ZPlayer.LoggedIn event) {
        ServerPlayer spe;
        MinecraftServer server;
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer && (server = (spe = (ServerPlayer)player).getServer()) != null) {
            int shift;
            ArrayList<RecipeHolder> recipes = new ArrayList<RecipeHolder>(server.getRecipeManager().getRecipes());
            recipes.removeIf(recipe -> {
                if (recipe == null) {
                    return true;
                }
                recipe.value().getResultItem((HolderLookup.Provider)event.getPlayer().level().registryAccess());
                return ignoredRecipes.contains(Objects.toString(recipe.id())) || recipe.value().getResultItem((HolderLookup.Provider)event.getPlayer().level().registryAccess()).isEmpty();
            });
            int idx = 0;
            int maxShift = 1000;
            int size = recipes.size();
            do {
                shift = size - idx;
                int effShift = Math.min(maxShift, shift);
                List sectionedRecipes = recipes.subList(idx, idx + effShift);
                player.awardRecipes(sectionedRecipes);
                idx += effShift;
            } while (shift > maxShift);
            if (forceLimitedCrafting) {
                ((GameRules.BooleanValue)player.level().getGameRules().getRule(GameRules.RULE_LIMITED_CRAFTING)).set(true, server);
            }
        }
    }

    public static Map<ResourceLocation, AdvancementHolder> removeRecipeAdvancements(Map<ResourceLocation, AdvancementHolder> advancements) {
        if (!staticEnabled || !filterRecipeAdvancements) {
            return advancements;
        }
        HashMap<ResourceLocation, AdvancementHolder> advancementReal = new HashMap<ResourceLocation, AdvancementHolder>();
        advancementReal.putAll(advancements);
        int removeCount = 0;
        for (Map.Entry advancement : advancementReal.entrySet()) {
            if (!((ResourceLocation)advancement.getKey()).getPath().startsWith("recipes/") || !((AdvancementHolder)advancement.getValue()).value().criteria().containsKey("has_the_recipe")) continue;
            Advancement oldAdv = ((AdvancementHolder)advancement.getValue()).value();
            HashMap<String, Criterion> criteriaReal = new HashMap<String, Criterion>();
            for (Map.Entry oldCriteria : oldAdv.criteria().entrySet()) {
                if (((String)oldCriteria.getKey()).equals("has_the_recipe")) continue;
                criteriaReal.put((String)oldCriteria.getKey(), (Criterion)oldCriteria.getValue());
            }
            Advancement replacementAdv = new Advancement(oldAdv.parent(), oldAdv.display(), oldAdv.rewards(), criteriaReal, oldAdv.requirements(), oldAdv.sendsTelemetryEvent(), oldAdv.name());
            AdvancementHolder realAdvancementHolder = new AdvancementHolder(((AdvancementHolder)advancement.getValue()).id(), replacementAdv);
            advancementReal.replace((ResourceLocation)advancement.getKey(), realAdvancementHolder);
            ++removeCount;
        }
        Quark.LOG.info("[Automatic Recipe Unlock] Removed {} recipe advancements", (Object)removeCount);
        return advancementReal;
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends AutomaticRecipeUnlockModule {
        @PlayEvent
        public void onInitGui(ZScreen.Init.Post event) {
            LocalPlayer player = Minecraft.getInstance().player;
            Screen gui = event.getScreen();
            if (disableRecipeBook && player != null && gui instanceof RecipeUpdateListener) {
                player.getRecipeBook().getBookSettings().setOpen(RecipeBookType.CRAFTING, false);
                List widgets = event.getListenersList();
                for (GuiEventListener w : widgets) {
                    if (!(w instanceof ImageButton)) continue;
                    event.removeListener(w);
                    return;
                }
            }
        }

        @PlayEvent
        public void clientTick(ZClientTick.End event) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.player != null && mc.player.tickCount < 20) {
                ToastComponent toasts = mc.getToasts();
                Deque toastQueue = toasts.queued;
                for (Toast toast : toastQueue) {
                    if (!(toast instanceof RecipeToast)) continue;
                    RecipeToast recipeToast = (RecipeToast)toast;
                    List stacks = recipeToast.recipes;
                    if (stacks.size() <= 100) continue;
                    toastQueue.remove(toast);
                    return;
                }
            }
        }
    }
}

